/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.servlet;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.cryptomator.webdav.core.servlet.CopyingFileVisitor;
import org.cryptomator.webdav.core.servlet.DavFile;
import org.cryptomator.webdav.core.servlet.DavLocatorImpl;
import org.cryptomator.webdav.core.servlet.DavNode;
import org.cryptomator.webdav.core.servlet.DavResourceFactoryImpl;
import org.cryptomator.webdav.core.servlet.OSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DavFolder
extends DavNode {
    private static final Logger LOG = LoggerFactory.getLogger(DavFolder.class);
    private static final DavPropertyName PROPERTY_QUOTA_AVAILABLE = DavPropertyName.create((String)"quota-available-bytes");
    private static final DavPropertyName PROPERTY_QUOTA_USED = DavPropertyName.create((String)"quota-used-bytes");

    public DavFolder(DavResourceFactoryImpl factory, LockManager lockManager, DavLocatorImpl locator, Path path, Optional<BasicFileAttributes> optional, DavSession session) {
        super(factory, lockManager, locator, path, optional, session);
        this.properties.add((DavProperty)new ResourceType(1));
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)1));
    }

    public boolean isCollection() {
        return true;
    }

    public void spool(OutputContext outputContext) throws IOException {
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        if (resource instanceof DavFolder) {
            this.addMemberFolder((DavFolder)resource);
        } else if (resource instanceof DavFile) {
            assert (inputContext.hasStream());
            this.addMemberFile((DavFile)resource, inputContext.getInputStream());
        } else {
            throw new IllegalArgumentException("Unsupported resource type: " + resource.getClass().getName());
        }
    }

    private void addMemberFolder(DavFolder memberFolder) throws DavException {
        try {
            Files.createDirectory(memberFolder.path, new FileAttribute[0]);
        }
        catch (FileSystemException e) {
            String reason = Strings.nullToEmpty((String)e.getReason());
            if (reason.contains("path too long")) {
                throw new DavException(414);
            }
            throw new UncheckedIOException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void addMemberFile(DavFile memberFile, InputStream inputStream) throws DavException {
        try (ReadableByteChannel src = Channels.newChannel(inputStream);
             SeekableByteChannel dst = Files.newByteChannel(memberFile.path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            ByteStreams.copy((ReadableByteChannel)src, (WritableByteChannel)dst);
        }
        catch (FileSystemException e) {
            String reason = Strings.nullToEmpty((String)e.getReason());
            if (reason.contains("path too long")) {
                throw new DavException(414);
            }
            throw new UncheckedIOException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public DavResourceIterator getMembers() {
        DavResourceIteratorImpl davResourceIteratorImpl;
        block13: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);
            try {
                ArrayList<DavNode> children = new ArrayList<DavNode>();
                for (Path childPath : stream) {
                    try {
                        BasicFileAttributes childAttr = Files.readAttributes(childPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                        DavLocatorImpl childLocator = this.locator.resolveChild(childPath.getFileName().toString());
                        if (childAttr.isDirectory()) {
                            DavFolder childFolder = this.factory.createFolder(childLocator, childPath, Optional.of(childAttr), this.session);
                            children.add(childFolder);
                            continue;
                        }
                        if (childAttr.isRegularFile()) {
                            DavFile childFile = this.factory.createFile(childLocator, childPath, Optional.of(childAttr), this.session);
                            children.add(childFile);
                            continue;
                        }
                        LOG.warn("encountered unsupported node: {}", (Object)childPath);
                    }
                    catch (IOException e) {
                        LOG.error("Exception while reading attributes of {}. Skipping file in listing.", (Object)childPath, (Object)e);
                    }
                }
                davResourceIteratorImpl = new DavResourceIteratorImpl(children);
                if (stream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return davResourceIteratorImpl;
    }

    public void removeMember(DavResource member) throws DavException {
        for (ActiveLock lock : member.getLocks()) {
            member.unlock(lock.getToken());
        }
        if (member instanceof DavNode) {
            this.removeMemberInternal((DavNode)member);
        }
    }

    public void removeMemberInternal(DavNode member) throws DavException {
        try {
            MoreFiles.deleteRecursively((Path)member.path, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (NoSuchFileException e) {
            throw new DavException(404);
        }
        catch (IOException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public void move(DavResource destination) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (!(destination instanceof DavNode)) {
            throw new IllegalArgumentException("Destination not a DavFolder: " + destination.getClass().getName());
        }
        this.moveInternal((DavNode)destination);
    }

    private void moveInternal(DavNode destination) throws DavException {
        if (Files.isDirectory(destination.path.getParent(), new LinkOption[0])) {
            try {
                Files.move(this.path, destination.path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileSystemException e) {
                String reason = Strings.nullToEmpty((String)e.getReason());
                if (reason.contains("path too long")) {
                    throw new DavException(400);
                }
                throw new DavException(500, (Throwable)e);
            }
            catch (IOException e) {
                throw new DavException(500, (Throwable)e);
            }
        } else {
            throw new DavException(409, "Destination's parent doesn't exist.");
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (!(destination instanceof DavNode)) {
            throw new IllegalArgumentException("Destination not a DavNode: " + destination.getClass().getName());
        }
        this.copyInternal((DavNode)destination, shallow);
    }

    private void copyInternal(DavNode destination, boolean shallow) throws DavException {
        assert (this.exists());
        assert (this.attr.isPresent());
        if (!Files.isDirectory(destination.path.getParent(), new LinkOption[0])) {
            throw new DavException(409, "Destination's parent doesn't exist.");
        }
        try {
            if (shallow && destination instanceof DavFolder) {
                Files.createDirectory(destination.path, new FileAttribute[0]);
                BasicFileAttributeView attrView = Files.getFileAttributeView(destination.path, BasicFileAttributeView.class, new LinkOption[0]);
                if (attrView != null) {
                    BasicFileAttributes a = (BasicFileAttributes)this.attr.get();
                    attrView.setTimes(a.lastModifiedTime(), a.lastAccessTime(), a.creationTime());
                }
            } else {
                Files.walkFileTree(this.path, new CopyingFileVisitor(this.path, destination.path, StandardCopyOption.REPLACE_EXISTING));
            }
        }
        catch (FileSystemException e) {
            String reason = Strings.nullToEmpty((String)e.getReason());
            if (reason.contains("path too long")) {
                throw new DavException(400);
            }
            throw new DavException(500, (Throwable)e);
        }
        catch (IOException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    @Override
    public DavPropertyName[] getPropertyNames() {
        List<DavPropertyName> list = Arrays.asList(super.getPropertyNames());
        list.add(PROPERTY_QUOTA_AVAILABLE);
        list.add(PROPERTY_QUOTA_USED);
        return (DavPropertyName[])Iterables.toArray(list, DavPropertyName.class);
    }

    @Override
    public DavProperty<?> getProperty(DavPropertyName name) {
        if (PROPERTY_QUOTA_AVAILABLE.equals((Object)name)) {
            if (OSUtil.isMacOS15_4orNewer()) {
                return null;
            }
            try {
                long availableBytes = Files.getFileStore(this.path).getUsableSpace();
                return new DefaultDavProperty(name, (Object)availableBytes);
            }
            catch (IOException e) {
                return null;
            }
        }
        if (PROPERTY_QUOTA_USED.equals((Object)name)) {
            if (OSUtil.isMacOS15_4orNewer()) {
                return null;
            }
            try {
                long availableBytes = Files.getFileStore(this.path).getTotalSpace();
                long freeBytes = Files.getFileStore(this.path).getUsableSpace();
                long usedBytes = availableBytes - freeBytes;
                return new DefaultDavProperty(name, (Object)usedBytes);
            }
            catch (IOException e) {
                return null;
            }
        }
        return super.getProperty(name);
    }
}

