/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.cryptomator.webdav.core.servlet.DavLocatorImpl;
import org.cryptomator.webdav.core.servlet.DavNode;
import org.cryptomator.webdav.core.servlet.ExclusiveSharedLock;
import org.cryptomator.webdav.core.servlet.UncheckedDavException;

class ExclusiveSharedLockManager
implements LockManager {
    private final ConcurrentMap<DavLocatorImpl, Map<String, ActiveLock>> lockedResources = new ConcurrentHashMap<DavLocatorImpl, Map<String, ActiveLock>>();

    ExclusiveSharedLockManager() {
    }

    public ActiveLock createLock(LockInfo lockInfo, DavResource resource) throws DavException {
        Objects.requireNonNull(lockInfo);
        Objects.requireNonNull(resource);
        if (resource instanceof DavNode) {
            return this.createLockInternal(lockInfo, (DavNode)resource);
        }
        throw new IllegalArgumentException("Unsupported resource type " + String.valueOf(resource.getClass()));
    }

    private synchronized ActiveLock createLockInternal(LockInfo lockInfo, DavNode resource) throws DavException {
        boolean isLocked;
        DavLocatorImpl locator = resource.getLocator();
        this.removedExpiredLocksInLocatorHierarchy(locator);
        ActiveLock existingExclusiveLock = this.getLock(lockInfo.getType(), Scope.EXCLUSIVE, resource);
        ActiveLock existingSharedLock = this.getLock(lockInfo.getType(), Scope.SHARED, resource);
        boolean hasExclusiveLock = existingExclusiveLock != null;
        boolean hasSharedLock = existingSharedLock != null;
        boolean bl = isLocked = hasExclusiveLock || hasSharedLock;
        if (Scope.EXCLUSIVE.equals((Object)lockInfo.getScope()) && isLocked || Scope.SHARED.equals((Object)lockInfo.getScope()) && hasExclusiveLock) {
            throw new DavException(423, "Resource (or parent resource) already locked.");
        }
        for (Map.Entry potentialChild : this.lockedResources.entrySet()) {
            DavLocatorImpl childLocator = (DavLocatorImpl)potentialChild.getKey();
            Collection<ActiveLock> childLocks = ((Map)potentialChild.getValue()).values();
            if (!this.isChild(locator, childLocator) || !this.isAffectedByChildLocks(lockInfo, locator, childLocks, childLocator)) continue;
            throw new DavException(409, "Subresource already locked. " + String.valueOf(childLocator));
        }
        String token = "opaquelocktoken:" + String.valueOf(UUID.randomUUID());
        Map lockMap = Objects.requireNonNull(this.lockedResources.computeIfAbsent(locator, loc -> new HashMap()));
        return lockMap.computeIfAbsent(token, t -> new ExclusiveSharedLock((String)t, lockInfo));
    }

    private void removedExpiredLocksInLocatorHierarchy(DavLocatorImpl locator) {
        Objects.requireNonNull(locator);
        this.lockedResources.getOrDefault(locator, Collections.emptyMap()).values().removeIf(ActiveLock::isExpired);
        if (!locator.isRootLocation()) {
            this.removedExpiredLocksInLocatorHierarchy(locator.resolveParent());
        }
    }

    private boolean isChild(DavResourceLocator parent, DavResourceLocator child) {
        return child.getResourcePath().startsWith(parent.getResourcePath());
    }

    private boolean isAffectedByChildLocks(LockInfo parentLockInfo, DavLocatorImpl parentLocator, Collection<ActiveLock> childLocks, DavLocatorImpl childLocator) {
        for (ActiveLock lock : childLocks) {
            if (Scope.SHARED.equals((Object)lock.getScope()) && Scope.SHARED.equals((Object)parentLockInfo.getScope()) || !parentLockInfo.isDeep() && !childLocator.resolveParent().equals(parentLocator)) continue;
            return true;
        }
        return false;
    }

    public ActiveLock refreshLock(LockInfo lockInfo, String lockToken, DavResource resource) throws DavException {
        ActiveLock lock = this.getLock(lockInfo.getType(), lockInfo.getScope(), resource);
        if (lock == null) {
            throw new DavException(412);
        }
        if (!lock.isLockedByToken(lockToken)) {
            throw new DavException(423);
        }
        lock.setTimeout(lockInfo.getTimeout());
        return lock;
    }

    public synchronized void releaseLock(String lockToken, DavResource resource) throws DavException {
        if (resource instanceof DavNode) {
            try {
                this.releaseLockInternal(lockToken, (DavNode)resource);
            }
            catch (UncheckedDavException e) {
                throw e.toDavException();
            }
        } else {
            throw new IllegalArgumentException("Unsupported resource type " + String.valueOf(resource.getClass()));
        }
    }

    private synchronized void releaseLockInternal(String lockToken, DavNode resource) throws UncheckedDavException {
        this.lockedResources.compute(resource.getLocator(), (loc, locks) -> {
            if (locks == null || locks.isEmpty()) {
                return null;
            }
            if (!locks.containsKey(lockToken)) {
                throw new UncheckedDavException(423, "Resource locked with different token.");
            }
            locks.remove(lockToken);
            return locks.isEmpty() ? null : locks;
        });
    }

    public ActiveLock getLock(Type type, Scope scope, DavResource resource) {
        if (resource instanceof DavNode) {
            DavNode node = (DavNode)resource;
            return this.getLockInternal(type, scope, node.getLocator(), 0);
        }
        throw new IllegalArgumentException("Unsupported resource type " + String.valueOf(resource.getClass()));
    }

    private ActiveLock getLockInternal(Type type, Scope scope, DavLocatorImpl locator, int depth) {
        if (this.lockedResources.containsKey(locator)) {
            for (ActiveLock lock : ((Map)this.lockedResources.get(locator)).values()) {
                if (!type.equals((Object)lock.getType()) || !scope.equals((Object)lock.getScope()) || depth != 0 && !lock.isDeep()) continue;
                return lock;
            }
        }
        if (locator.isRootLocation()) {
            return null;
        }
        return this.getLockInternal(type, scope, locator.resolveParent(), depth + 1);
    }

    public boolean hasLock(String lockToken, DavResource resource) {
        if (resource instanceof DavNode) {
            DavNode node = (DavNode)resource;
            return this.lockedResources.getOrDefault(node.getLocator(), Collections.emptyMap()).containsKey(lockToken);
        }
        throw new IllegalArgumentException("Unsupported resource type " + String.valueOf(resource.getClass()));
    }
}

