" firejail.vim.  Generated from firejail.vim.in by make.
" Vim syntax file
" Language: Firejail security sandbox profile
" URL: https://github.com/netblue30/firejail

if exists("b:current_syntax")
  finish
endif


syn iskeyword @,48-57,_,.,-


syn keyword fjTodo TODO FIXME XXX NOTE contained
syn match fjComment "#.*$" contains=fjTodo

"TODO: highlight "dangerous" capabilities differently, as is done in apparmor.vim?
syn keyword fjCapability audit_control audit_read audit_write block_suspend chown dac_override dac_read_search fowner fsetid ipc_lock ipc_owner kill lease linux_immutable mac_admin mac_override mknod net_admin net_bind_service net_broadcast net_raw setgid setfcap setpcap setuid sys_admin sys_boot sys_chroot sys_module sys_nice sys_pacct sys_ptrace sys_rawio sys_resource sys_time sys_tty_config syslog wake_alarm nextgroup=fjCapabilityList contained
syn match fjCapabilityList /,/ nextgroup=fjCapability contained

syn keyword fjNamespaces cgroup ipc net mnt pid time user uts nextgroup=fjNamespacesList contained
syn match fjNamespacesList /,/ nextgroup=fjNamespaces contained

syn keyword fjProtocol unix inet inet6 netlink packet nextgroup=fjProtocolList contained
syn match fjProtocolList /,/ nextgroup=fjProtocol contained

" Syscalls (auto-generated)
syn keyword fjSyscall _llseek _newselect _sysctl accept accept4 access acct add_key adjtimex afs_syscall alarm arc_gettls arc_settls arc_usr_cmpxchg arch_prctl arm_fadvise64_64 arm_sync_file_range atomic_barrier atomic_cmpxchg_32 available165 available170 available222 available238 available255 available259 available271 available286 available287 available302 available303 available315 available319 available4 available5 available51 available6 available7 available8 available9 bdflush bind bpf break brk cachectl cacheflush cachestat capget capset chdir chmod chown chown32 chroot clock_adjtime clock_adjtime64 clock_getres clock_getres_time64 clock_gettime clock_gettime64 clock_nanosleep clock_nanosleep_time64 clock_settime clock_settime64 clone clone3 close close_range connect copy_file_range creat create_module delete_module dipc dup dup2 dup3 epoll_create epoll_create1 epoll_ctl epoll_ctl_old epoll_pwait epoll_pwait2 epoll_wait epoll_wait_old eventfd eventfd2 exec_with_loader execv execve execveat exit exit_group faccessat faccessat2 fadvise64 fadvise64_64 fallocate fanotify_init fanotify_mark fchdir fchmod fchmodat fchmodat2 fchown fchown32 fchownat fcntl fcntl64 fdatasync fgetxattr file_getattr file_setattr finit_module flistxattr flock fork fremovexattr fsconfig fsetxattr fsmount fsopen fspick fstat fstat64 fstatat64 fstatfs fstatfs64 fsync ftime ftruncate ftruncate64 futex futex_requeue futex_time64 futex_wait futex_waitv futex_wake futimesat get_kernel_syms get_mempolicy get_robust_list get_thread_area getcpu getcwd getdents getdents64 getdomainname getdtablesize getegid getegid32 geteuid geteuid32 getgid getgid32 getgroups getgroups32 gethostname getitimer getpagesize getpeername getpgid getpgrp getpid getpmsg getppid getpriority getrandom getresgid getresgid32 getresuid getresuid32 getrlimit getrusage getsid getsockname getsockopt gettid gettimeofday getuid getuid32 getxattr getxattrat getxgid getxpid getxuid gtty idle init_module inotify_add_watch inotify_init inotify_init1 inotify_rm_watch io_cancel io_destroy io_getevents io_pgetevents io_pgetevents_time64 io_setup io_submit io_uring_enter io_uring_register io_uring_setup ioctl ioperm iopl ioprio_get ioprio_set ipc kcmp kern_features kexec_file_load kexec_load keyctl kill landlock_add_rule landlock_create_ruleset landlock_restrict_self lchown lchown32 lgetxattr link linkat listen listmount listxattr listxattrat llistxattr llseek lock lookup_dcookie lremovexattr lseek lsetxattr lsm_get_self_attr lsm_list_modules lsm_set_self_attr lstat lstat64 madvise map_shadow_stack mbind membarrier memfd_create memfd_secret memory_ordering migrate_pages mincore mkdir mkdirat mknod mknodat mlock mlock2 mlockall mmap mmap2 modify_ldt mount mount_setattr move_mount move_pages mprotect mpx mq_getsetattr mq_notify mq_open mq_timedreceive mq_timedreceive_time64 mq_timedsend mq_timedsend_time64 mq_unlink mremap mseal msgctl msgget msgrcv msgsnd msync multiplexer munlock munlockall munmap name_to_handle_at nanosleep newfstatat nfsservctl nice old_adjtimex oldfstat oldlstat oldolduname oldstat oldumount olduname open open_by_handle_at open_tree open_tree_attr openat openat2 or1k_atomic osf_adjtime osf_afs_syscall osf_alt_plock osf_alt_setsid osf_alt_sigpending osf_asynch_daemon osf_audcntl osf_audgen osf_chflags osf_execve osf_exportfs osf_fchflags osf_fdatasync osf_fpathconf osf_fstat osf_fstatfs osf_fstatfs64 osf_fuser osf_getaddressconf osf_getdirentries osf_getdomainname osf_getfh osf_getfsstat osf_gethostid osf_getitimer osf_getlogin osf_getmnt osf_getrusage osf_getsysinfo osf_gettimeofday osf_kloadcall osf_kmodcall osf_lstat osf_memcntl osf_mincore osf_mount osf_mremap osf_msfs_syscall osf_msleep osf_mvalid osf_mwakeup osf_naccept osf_nfssvc osf_ngetpeername osf_ngetsockname osf_nrecvfrom osf_nrecvmsg osf_nsendmsg osf_ntp_adjtime osf_ntp_gettime osf_old_creat osf_old_fstat osf_old_getpgrp osf_old_killpg osf_old_lstat osf_old_open osf_old_sigaction osf_old_sigblock osf_old_sigreturn osf_old_sigsetmask osf_old_sigvec osf_old_stat osf_old_vadvise osf_old_vtrace osf_old_wait osf_oldquota osf_pathconf osf_pid_block osf_pid_unblock osf_plock osf_priocntlset osf_profil osf_proplist_syscall osf_reboot osf_revoke osf_sbrk osf_security osf_select osf_set_program_attributes osf_set_speculative osf_sethostid osf_setitimer osf_setlogin osf_setsysinfo osf_settimeofday osf_signal osf_sigprocmask osf_sigsendset osf_sigstack osf_sigwaitprim osf_sstk osf_stat osf_statfs osf_statfs64 osf_subsys_info osf_swapctl osf_swapon osf_syscall osf_sysinfo osf_table osf_uadmin osf_usleep_thread osf_uswitch osf_utc_adjtime osf_utc_gettime osf_utimes osf_utsname osf_wait4 osf_waitid pause pciconfig_iobase pciconfig_read pciconfig_write perf_event_open perfctr personality pidfd_getfd pidfd_open pidfd_send_signal pipe pipe2 pivot_root pkey_alloc pkey_free pkey_mprotect poll ppoll ppoll_time64 prctl pread64 preadv preadv2 prlimit64 process_madvise process_mrelease process_vm_readv process_vm_writev prof profil pselect6 pselect6_time64 ptrace putpmsg pwrite64 pwritev pwritev2 query_module quotactl quotactl_fd read readahead readdir readlink readlinkat readv reboot recv recvfrom recvmmsg recvmmsg_time64 recvmsg remap_file_pages removexattr removexattrat rename renameat renameat2 request_key reserved152 reserved153 reserved177 reserved193 reserved221 reserved253 reserved82 restart_syscall riscv_flush_icache riscv_hwprobe rmdir rseq rt_sigaction rt_sigpending rt_sigprocmask rt_sigqueueinfo rt_sigreturn rt_sigsuspend rt_sigtimedwait rt_sigtimedwait_time64 rt_tgsigqueueinfo rtas s390_guarded_storage s390_pci_mmio_read s390_pci_mmio_write s390_runtime_instr s390_sthyi sched_get_affinity sched_get_priority_max sched_get_priority_min sched_getaffinity sched_getattr sched_getparam sched_getscheduler sched_rr_get_interval sched_rr_get_interval_time64 sched_set_affinity sched_setaffinity sched_setattr sched_setparam sched_setscheduler sched_yield seccomp security select semctl semget semop semtimedop semtimedop_time64 send sendfile sendfile64 sendmmsg sendmsg sendto set_mempolicy set_mempolicy_home_node set_robust_list set_thread_area set_tid_address setdomainname setfsgid setfsgid32 setfsuid setfsuid32 setgid setgid32 setgroups setgroups32 sethae sethostname setitimer setns setpgid setpgrp setpriority setregid setregid32 setresgid setresgid32 setresuid setresuid32 setreuid setreuid32 setrlimit setsid setsockopt settimeofday setuid setuid32 setxattr setxattrat sgetmask shmat shmctl shmdt shmget shutdown sigaction sigaltstack signal signalfd signalfd4 sigpending sigprocmask sigreturn sigsuspend socket socketcall socketpair spill splice spu_create spu_run ssetmask stat stat64 statfs statfs64 statmount statx stime stty subpage_prot swapcontext swapoff swapon switch_endian symlink symlinkat sync sync_file_range sync_file_range2 syncfs sys_debug_setcontext syscall sysfs sysinfo syslog sysmips tee tgkill time timer_create timer_delete timer_getoverrun timer_gettime timer_gettime64 timer_settime timer_settime64 timerfd timerfd_create timerfd_gettime timerfd_gettime64 timerfd_settime timerfd_settime64 times tkill truncate truncate64 tuxcall ugetrlimit ulimit umask umount umount2 uname unlink unlinkat unshare unused109 unused150 unused18 unused28 unused59 unused84 uprobe uretprobe uselib userfaultfd ustat utime utimensat utimensat_time64 utimes utrap_install vfork vhangup vm86 vm86old vmsplice vserver wait4 waitid waitpid write writev xtensa nextgroup=fjSyscallErrno contained
" Syscall groups (auto-generated)
syn match fjSyscall /\v\@(aio|all|basic-io|chown|clock|cpu-emulation|debug|default|default-keep|default-nodebuggers|file-system|io-event|ipc|keyring|memfd|memlock|module|mount|network-io|obsolete|privileged|process|raw-io|reboot|resources|sandbox|setuid|signal|swap|sync|system-service|timer)>/ nextgroup=fjSyscallErrno contained
syn match fjSyscall /\$[0-9]\+/ nextgroup=fjSyscallErrno contained
" Errnos (auto-generated)
syn match fjSyscallErrno /\v(:(E2BIG|EACCES|EADDRINUSE|EADDRNOTAVAIL|EADV|EAFNOSUPPORT|EAGAIN|EALREADY|EBADE|EBADF|EBADFD|EBADMSG|EBADR|EBADRQC|EBADSLT|EBFONT|EBUSY|ECANCELED|ECHILD|ECHRNG|ECOMM|ECONNABORTED|ECONNREFUSED|ECONNRESET|EDEADLK|EDEADLOCK|EDESTADDRREQ|EDOM|EDOTDOT|EDQUOT|EEXIST|EFAULT|EFBIG|EHOSTDOWN|EHOSTUNREACH|EHWPOISON|EIDRM|EILSEQ|EINPROGRESS|EINTR|EINVAL|EIO|EISCONN|EISDIR|EISNAM|EKEYEXPIRED|EKEYREJECTED|EKEYREVOKED|EL2HLT|EL2NSYNC|EL3HLT|EL3RST|ELIBACC|ELIBBAD|ELIBEXEC|ELIBMAX|ELIBSCN|ELNRNG|ELOOP|EMEDIUMTYPE|EMFILE|EMLINK|EMSGSIZE|EMULTIHOP|ENAMETOOLONG|ENAVAIL|ENETDOWN|ENETRESET|ENETUNREACH|ENFILE|ENOANO|ENOATTR|ENOBUFS|ENOCSI|ENODATA|ENODEV|ENOENT|ENOEXEC|ENOKEY|ENOLCK|ENOLINK|ENOMEDIUM|ENOMEM|ENOMSG|ENONET|ENOPKG|ENOPROTOOPT|ENOSPC|ENOSR|ENOSTR|ENOSYS|ENOTBLK|ENOTCONN|ENOTDIR|ENOTEMPTY|ENOTNAM|ENOTRECOVERABLE|ENOTSOCK|ENOTSUP|ENOTTY|ENOTUNIQ|ENXIO|EOPNOTSUPP|EOVERFLOW|EOWNERDEAD|EPERM|EPFNOSUPPORT|EPIPE|EPROTO|EPROTONOSUPPORT|EPROTOTYPE|ERANGE|EREMCHG|EREMOTE|EREMOTEIO|ERESTART|ERFKILL|EROFS|ESHUTDOWN|ESOCKTNOSUPPORT|ESPIPE|ESRCH|ESRMNT|ESTALE|ESTRPIPE|ETIME|ETIMEDOUT|ETOOMANYREFS|ETXTBSY|EUCLEAN|EUNATCH|EUSERS|EWOULDBLOCK|EXDEV|EXFULL)>)?/ nextgroup=fjSyscallList contained
syn match fjSyscallList /,/ nextgroup=fjSyscall contained

syn keyword fjX11Sandbox none xephyr xorg xpra xvfb contained
syn keyword fjSeccompAction kill log ERRNO contained

syn match fjEnvVar "[A-Za-z0-9_]\+=" contained
syn match fjRmenvVar "[A-Za-z0-9_]\+" contained

syn keyword fjAll all contained
syn keyword fjNone none contained
syn keyword fjLo lo contained
syn keyword fjFilter filter contained

" Variable names (auto-generated)
syn match fjVar /\v\$\{(CFG|DESKTOP|DOCUMENTS|DOWNLOADS|HOME|MUSIC|PATH|PICTURES|RUNUSER|VIDEOS)}/

" Profile commands with 1 argument (auto-generated)
syn match fjCommand /\v(apparmor|bind|blacklist|blacklist-nolog|caps\.drop|caps\.keep|cpu|dbus-system|dbus-system\.broadcast|dbus-system\.call|dbus-system\.own|dbus-system\.see|dbus-system\.talk|dbus-user|dbus-user\.broadcast|dbus-user\.call|dbus-user\.own|dbus-user\.see|dbus-user\.talk|defaultgw|dns|env|hostname|hosts-file|ignore|include|ip|ip6|iprange|join-or-start|keep-fd|landlock\.fs\.execute|landlock\.fs\.makedev|landlock\.fs\.makeipc|landlock\.fs\.read|landlock\.fs\.write|mac|mkdir|mkfile|mtu|name|net|netfilter|netfilter6|netmask|netns|nice|noblacklist|noexec|nowhitelist|private|private-bin|private-cwd|private-etc|private-home|private-lib|private-opt|private-srv|protocol|read-only|read-write|restrict-namespaces|rlimit-as|rlimit-cpu|rlimit-fsize|rlimit-nofile|rlimit-nproc|rlimit-sigpending|rmenv|seccomp|seccomp-error-action|seccomp\.32|seccomp\.32\.drop|seccomp\.32\.keep|seccomp\.drop|seccomp\.keep|shell|timeout|tmpfs|veth-name|warn|whitelist|whitelist-ro|x11|xephyr-screen) / skipwhite contained
" Profile commands with 0 arguments (auto-generated)
syn match fjCommand /\v(allow-bwrap|allow-debuggers|allusers|apparmor|apparmor-replace|apparmor-stack|caps|deterministic-exit-code|deterministic-shutdown|disable-mnt|ipc-namespace|keep-config-pulse|keep-dev-ntsync|keep-dev-shm|keep-dev-tpm|keep-hostname|keep-shell-rc|keep-var-tmp|landlock\.enforce|machine-id|memory-deny-write-execute|netfilter|netlock|no3d|noautopulse|nodbus|nodvd|nogroups|noinput|nonewprivs|noprinters|noroot|nosound|notpm|notv|nou2f|novideo|private|private-cache|private-cwd|private-dev|private-etc|private-lib|private-tmp|quiet|restrict-namespaces|seccomp|seccomp\.block-secondary|tab|tracelog|writable-etc|writable-run-user|writable-var|writable-var-log|x11)$/ contained
syn match fjCommand /ignore / nextgroup=fjCommand,fjCommandNoCond skipwhite contained
syn match fjCommand /caps\.drop / nextgroup=fjCapability,fjAll skipwhite contained
syn match fjCommand /caps\.keep / nextgroup=fjCapability skipwhite contained
syn match fjCommand /protocol / nextgroup=fjProtocol skipwhite contained
syn match fjCommand /restrict-namespaces / nextgroup=fjNamespaces skipwhite contained
syn match fjCommand /\vseccomp(\.32)?(\.drop|\.keep)? / nextgroup=fjSyscall skipwhite contained
syn match fjCommand /x11 / nextgroup=fjX11Sandbox skipwhite contained
syn match fjCommand /env / nextgroup=fjEnvVar skipwhite contained
syn match fjCommand /rmenv / nextgroup=fjRmenvVar skipwhite contained
syn match fjCommand /shell / nextgroup=fjNone skipwhite contained
syn match fjCommand /net / nextgroup=fjNone,fjLo skipwhite contained
syn match fjCommand /ip / nextgroup=fjNone skipwhite contained
syn match fjCommand /seccomp-error-action / nextgroup=fjSeccompAction skipwhite contained
syn match fjCommand /\vdbus-(user|system) / nextgroup=fjFilter,fjNone skipwhite contained
syn match fjCommand /\vdbus-(user|system)\.(broadcast|call|own|see|talk) / skipwhite contained
" Commands that can't be inside a ?CONDITIONAL: statement
syn match fjCommandNoCond /include / skipwhite contained
syn match fjCommandNoCond /quiet$/ contained

" Conditionals (auto-generated)
syn match fjConditional /\v\?(ALLOW_TRAY|BROWSER_ALLOW_DRM|BROWSER_DISABLE_U2F|HAS_APPIMAGE|HAS_NET|HAS_NODBUS|HAS_NOSOUND|HAS_PRIVATE|HAS_X11) ?:/ nextgroup=fjCommand skipwhite contained

" A line is either a command, a conditional or a comment
syn match fjStatement /^/ nextgroup=fjCommand,fjCommandNoCond,fjConditional,fjComment

hi def link fjTodo Todo
hi def link fjComment Comment
hi def link fjCommand Statement
hi def link fjCommandNoCond Statement
hi def link fjConditional Macro
hi def link fjVar Identifier
hi def link fjCapability Type
hi def link fjProtocol Type
hi def link fjSyscall Type
hi def link fjSyscallErrno Constant
hi def link fjX11Sandbox Type
hi def link fjEnvVar Type
hi def link fjRmenvVar Type
hi def link fjAll Type
hi def link fjNone Type
hi def link fjLo Type
hi def link fjFilter Type
hi def link fjSeccompAction Type


let b:current_syntax = "firejail"
