"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const Note_1 = require("@joplin/lib/models/Note");
const time_1 = require("@joplin/lib/time");
class Command extends base_command_1.default {
    usage() {
        return 'done <note>';
    }
    description() {
        return (0, locale_1._)('Marks a to-do as done.');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    static async handleAction(commandInstance, args, isCompleted) {
        const note = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_NOTE, args.note);
        commandInstance.encryptionCheck(note);
        if (!note)
            throw new Error((0, locale_1._)('Cannot find "%s".', args.note));
        if (!note.is_todo)
            throw new Error((0, locale_1._)('Note is not a to-do: "%s"', args.note));
        const todoCompleted = !!note.todo_completed;
        if (isCompleted === todoCompleted)
            return;
        await Note_1.default.save({
            id: note.id,
            todo_completed: isCompleted ? time_1.default.unixMs() : 0,
        });
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        await Command.handleAction(this, args, true);
    }
}
module.exports = Command;
//# sourceMappingURL=command-done.js.map