"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const Folder_1 = require("@joplin/lib/models/Folder");
const Note_1 = require("@joplin/lib/models/Note");
const Tag_1 = require("@joplin/lib/models/Tag");
class Command extends base_command_1.default {
    usage() {
        return 'dump';
    }
    description() {
        return 'Dumps the complete database as JSON.';
    }
    hidden() {
        return true;
    }
    async action() {
        let items = [];
        const folders = await Folder_1.default.all();
        for (let i = 0; i < folders.length; i++) {
            const folder = folders[i];
            const notes = await Note_1.default.previews(folder.id);
            items.push(folder);
            items = items.concat(notes);
        }
        const tags = await Tag_1.default.all();
        for (let i = 0; i < tags.length; i++) {
            tags[i].notes_ = await Tag_1.default.noteIds(tags[i].id);
        }
        items = items.concat(tags);
        this.stdout(JSON.stringify(items));
    }
}
module.exports = Command;
//# sourceMappingURL=command-dump.js.map