"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BaseCommand = require('./base-command').default;
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const Folder_1 = require("@joplin/lib/models/Folder");
class Command extends BaseCommand {
    usage() {
        return 'mkbook <new-notebook>';
    }
    description() {
        return (0, locale_1._)('Creates a new notebook.');
    }
    options() {
        return [
            ['-p, --parent <parent-notebook>', (0, locale_1._)('Create a new notebook under a parent notebook.')],
        ];
    }
    // validDestinationFolder check for presents and ambiguous folders
    async validDestinationFolder(targetFolder) {
        const destinationFolder = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_FOLDER, targetFolder);
        if (!destinationFolder) {
            throw new Error((0, locale_1._)('Cannot find: "%s"', targetFolder));
        }
        const destinationDups = await Folder_1.default.search({ titlePattern: targetFolder, limit: 2 });
        if (destinationDups.length > 1) {
            throw new Error((0, locale_1._)('Ambiguous notebook "%s". Please use short notebook id instead - press "ti" to see the short notebook id', targetFolder));
        }
        return destinationFolder;
    }
    async saveAndSwitchFolder(newFolder) {
        const folder = await Folder_1.default.save(newFolder, { userSideValidation: true });
        (0, app_1.default)().switchCurrentFolder(folder);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const targetFolder = args.options.parent;
        const newFolder = {
            title: args['new-notebook'],
        };
        if (targetFolder) {
            const destinationFolder = await this.validDestinationFolder(targetFolder);
            newFolder.parent_id = destinationFolder.id;
            await this.saveAndSwitchFolder(newFolder);
        }
        else {
            await this.saveAndSwitchFolder(newFolder);
        }
    }
}
module.exports = Command;
//# sourceMappingURL=command-mkbook.js.map