"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const Folder_1 = require("@joplin/lib/models/Folder");
const Note_1 = require("@joplin/lib/models/Note");
class Command extends base_command_1.default {
    usage() {
        return 'mv <item> [notebook]';
    }
    description() {
        return (0, locale_1._)('Moves the given <item> to [notebook]');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const pattern = args['item'];
        const destination = args['notebook'];
        let folder = null;
        if (destination !== 'root') {
            folder = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_FOLDER, destination);
            if (!folder)
                throw new Error((0, locale_1._)('Cannot find "%s".', destination));
        }
        const destinationDuplicates = await Folder_1.default.search({ titlePattern: destination, limit: 2 });
        if (destinationDuplicates.length > 1) {
            throw new Error((0, locale_1._)('Ambiguous notebook "%s". Please use short notebook id instead - press "ti" to see the short notebook id', destination));
        }
        const itemFolder = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_FOLDER, pattern);
        if (itemFolder) {
            const sourceDuplicates = await Folder_1.default.search({ titlePattern: pattern, limit: 2 });
            if (sourceDuplicates.length > 1) {
                throw new Error((0, locale_1._)('Ambiguous notebook "%s". Please use notebook id instead - press "ti" to see the short notebook id or use $b for current selected notebook', pattern));
            }
            if (destination === 'root') {
                await Folder_1.default.moveToFolder(itemFolder.id, '');
            }
            else {
                await Folder_1.default.moveToFolder(itemFolder.id, folder.id);
            }
        }
        else {
            const notes = await (0, app_1.default)().loadItems(BaseModel_1.default.TYPE_NOTE, pattern);
            if (notes.length === 0)
                throw new Error((0, locale_1._)('Cannot find "%s".', pattern));
            for (let i = 0; i < notes.length; i++) {
                await Note_1.default.moveToFolder(notes[i].id, folder.id);
            }
        }
    }
}
module.exports = Command;
//# sourceMappingURL=command-mv.js.map