"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const locale_1 = require("@joplin/lib/locale");
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const Logger_1 = require("@joplin/utils/Logger");
const ShareService_1 = require("@joplin/lib/services/share/ShareService");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const SyncTargetRegistry_1 = require("@joplin/lib/SyncTargetRegistry");
const Setting_1 = require("@joplin/lib/models/Setting");
const registry_1 = require("@joplin/lib/registry");
const logger = Logger_1.default.create('command-publish');
class Command extends base_command_1.default {
    usage() {
        return 'publish [note]';
    }
    description() {
        return (0, locale_1._)('Publishes a note to Joplin Server or Joplin Cloud');
    }
    options() {
        return [
            ['-f, --force', (0, locale_1._)('Do not ask for user confirmation.')],
        ];
    }
    enabled() {
        return SyncTargetRegistry_1.default.isJoplinServerOrCloud(Setting_1.default.value('sync.target'));
    }
    async action(args) {
        var _a;
        const targetNote = await (0, app_1.default)().loadItemOrFail(BaseModel_1.ModelType.Note, args.note);
        const parent = await (0, app_1.default)().loadItem(BaseModel_1.ModelType.Folder, targetNote.parent_id);
        const force = args.options.force;
        const alreadyShared = !!targetNote.is_shared;
        const ok = force || alreadyShared ? true : await this.prompt((0, locale_1._)('Publish note "%s" (in notebook "%s")?', targetNote.title, (_a = parent.title) !== null && _a !== void 0 ? _a : '<root>'), { booleanAnswerDefault: 'n' });
        if (!ok)
            return;
        logger.info('Share note: ', targetNote.id);
        const share = await ShareService_1.default.instance().shareNote(targetNote.id, false);
        this.stdout((0, locale_1._)('Synchronising...'));
        await registry_1.reg.waitForSyncFinishedThenSync();
        const userId = ShareService_1.default.instance().userId;
        const shareUrl = ShareService_1.default.instance().shareUrl(userId, share);
        this.stdout((0, locale_1._)('Published at URL: %s', shareUrl));
    }
}
module.exports = Command;
//# sourceMappingURL=command-publish.js.map