"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringHasher = void 0;
const util_utf8_1 = require("@aws-sdk/util-utf8");
const stringHasher = (checksumAlgorithmFn, body) => {
    const hash = new checksumAlgorithmFn();
    hash.update((0, util_utf8_1.toUint8Array)(body || ""));
    return hash.digest();
};
exports.stringHasher = stringHasher;
