"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const htmlparser2 = require('@joplin/fork-htmlparser2');
var EventTypes;
(function (EventTypes) {
    EventTypes[EventTypes["OpenTag"] = 0] = "OpenTag";
    EventTypes[EventTypes["Text"] = 1] = "Text";
    EventTypes[EventTypes["CloseTag"] = 2] = "CloseTag";
})(EventTypes || (EventTypes = {}));
const parseHtmlAsync = async (html, callbacks) => {
    const events = [];
    const parser = new htmlparser2.Parser({
        onopentag: (name, attrs) => {
            events.push({
                type: EventTypes.OpenTag,
                name,
                attrs,
            });
        },
        ontext: (decodedText) => {
            events.push({
                type: EventTypes.Text,
                decodedText,
            });
        },
        onclosetag: (name) => {
            events.push({
                type: EventTypes.CloseTag,
                name,
            });
        },
    }, { decodeEntities: true });
    parser.write(html);
    parser.end();
    for (const event of events) {
        if (event.type === EventTypes.OpenTag) {
            await callbacks.onopentag(event.name, event.attrs);
        }
        else if (event.type === EventTypes.CloseTag) {
            await callbacks.onclosetag(event.name);
        }
        else if (event.type === EventTypes.Text) {
            await callbacks.ontext(event.decodedText);
        }
        else {
            const exhaustivenessCheck = event;
            throw new Error(`Unknown event type: ${exhaustivenessCheck}`);
        }
    }
};
exports.default = parseHtmlAsync;
//# sourceMappingURL=parseHtmlAsync.js.map