"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const PerformanceLogger_1 = require("./PerformanceLogger");
describe('PerformanceLogger', () => {
    beforeEach(() => {
        PerformanceLogger_1.default.reset_();
    });
    test('should buffer log messages created before a logger is attached', () => {
        const logger = PerformanceLogger_1.default.create();
        logger.mark('test/Test');
        const log = [];
        PerformanceLogger_1.default.setLogger({
            info: (message) => log.push(`info: ${message}`),
            debug: (message) => log.push(`debug: ${message}`),
        });
        expect(log).toHaveLength(1);
        expect(log[0]).toMatch(/^info: Performance: test\/Test: Mark at/);
        // Should continue using the set logger
        const task = logger.taskStart('test/Test task');
        expect(log).toHaveLength(2);
        task.onEnd();
        expect(log).toHaveLength(3);
    });
});
//# sourceMappingURL=PerformanceLogger.test.js.map