"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const locale_1 = require("../locale");
exports.declaration = {
    name: 'openMasterPasswordDialog',
    label: () => (0, locale_1._)('Manage master password...'),
    iconName: 'fas fa-key',
};
const runtime = () => {
    return {
        execute: async (context, isOpen = true) => {
            context.dispatch({
                type: 'DIALOG_OPEN',
                name: 'masterPassword',
                isOpen: isOpen,
            });
        },
    };
};
exports.runtime = runtime;
//# sourceMappingURL=openMasterPasswordDialog.js.map