"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const locale_1 = require("../locale");
const Note_1 = require("../models/Note");
const shim_1 = require("../shim");
exports.declaration = {
    name: 'permanentlyDeleteNote',
    label: () => (0, locale_1._)('Permanently delete note'),
    iconName: 'fa-times',
};
const runtime = () => {
    return {
        execute: async (context, noteIds = null) => {
            if (noteIds === null)
                noteIds = context.state.selectedNoteIds;
            if (!noteIds.length)
                return;
            const msg = await Note_1.default.permanentlyDeleteMessage(noteIds);
            const deleteIndex = 0;
            const result = await shim_1.default.showMessageBox(msg, {
                buttons: [(0, locale_1._)('Delete'), (0, locale_1._)('Cancel')],
                defaultId: 1,
                cancelId: 1,
                type: shim_1.MessageBoxType.Confirm,
            });
            if (result === deleteIndex) {
                await Note_1.default.batchDelete(noteIds, { toTrash: false, sourceDescription: 'permanentlyDeleteNote command' });
            }
        },
        enabledCondition: '(!noteIsReadOnly || inTrash) && someNotesSelected',
    };
};
exports.runtime = runtime;
//# sourceMappingURL=permanentlyDeleteNote.js.map