"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const CommandService_1 = require("../services/CommandService");
const locale_1 = require("../locale");
const Logger_1 = require("@joplin/utils/Logger");
const getActivePluginEditorViews_1 = require("../services/plugins/utils/getActivePluginEditorViews");
const getShownPluginEditorView_1 = require("../services/plugins/utils/getShownPluginEditorView");
const logger = Logger_1.default.create('toggleEditorPlugin');
exports.declaration = {
    name: 'toggleEditorPlugin',
    label: () => (0, locale_1._)('Toggle editor plugin'),
    iconName: 'fas fa-eye',
};
const runtime = () => {
    return {
        execute: async (context) => {
            const activeWindowId = context.state.windowId;
            const activePluginStates = (0, getActivePluginEditorViews_1.default)(context.state.pluginService.plugins, activeWindowId);
            if (activePluginStates.length === 0) {
                logger.warn('No editor plugin to toggle to');
                return;
            }
            let showedView = false;
            const setEditorPluginVisible = async (viewId, visible) => {
                await CommandService_1.default.instance().execute('showEditorPlugin', viewId, visible);
                showedView || (showedView = visible);
            };
            const { editorView: visibleView } = (0, getShownPluginEditorView_1.default)(context.state.pluginService.plugins, activeWindowId);
            // Hide the visible view
            if (visibleView) {
                await setEditorPluginVisible(visibleView.id, false);
            }
            // Show the next view
            const visibleViewIndex = activePluginStates.findIndex(state => state.editorView.id === (visibleView === null || visibleView === void 0 ? void 0 : visibleView.id));
            const nextIndex = visibleViewIndex + 1;
            if (nextIndex < activePluginStates.length) {
                await setEditorPluginVisible(activePluginStates[nextIndex].editorView.id, true);
            }
            if (!showedView) {
                // When the plugin editor goes from visible to hidden, we need to reload the note
                // because it may have been changed via the data API.
                context.dispatch({
                    type: 'EDITOR_NOTE_NEEDS_RELOAD',
                });
            }
        },
        enabledCondition: 'hasActivePluginEditor',
    };
};
exports.runtime = runtime;
//# sourceMappingURL=toggleEditorPlugin.js.map