"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const MasterKey_1 = require("../../models/MasterKey");
const EncryptionService_1 = require("../../services/e2ee/EncryptionService");
const syncInfoUtils_1 = require("../../services/synchronizer/syncInfoUtils");
const test_utils_1 = require("../../testing/test-utils");
const utils_1 = require("./utils");
const react_hooks_1 = require("@testing-library/react-hooks");
const useWrappedPasswordChecker = ({ masterKeys = [], activeMasterKeyId = '', masterPassword = '', passwords = {}, }) => (0, utils_1.usePasswordChecker)(masterKeys, activeMasterKeyId, masterPassword, passwords);
describe('EncryptionConfigScreen/utils', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(0);
        await (0, test_utils_1.switchClient)(0);
        (0, syncInfoUtils_1.setEncryptionEnabled)(true);
    });
    test('should not mark keys as master password keys if the master password is incorrect for that key', async () => {
        const makeMasterKey = async (password) => {
            const result = await EncryptionService_1.default.instance().generateMasterKey(password, {
                encryptionMethod: EncryptionService_1.EncryptionMethod.SJCL4,
            });
            return await MasterKey_1.default.save(result);
        };
        const activeMasterKey = await makeMasterKey('master-password');
        const secondaryMasterKey = await makeMasterKey('some other password');
        const masterKeys = [
            activeMasterKey,
            secondaryMasterKey,
        ];
        const initialProps = {
            masterKeys,
            activeMasterKeyId: activeMasterKey.id,
            masterPassword: 'master-password',
            passwords: {
                [activeMasterKey.id]: 'master-password',
                [secondaryMasterKey.id]: 'some other password',
            },
        };
        const hook = (0, react_hooks_1.renderHook)(useWrappedPasswordChecker, {
            initialProps,
        });
        // Different password from the master password should cause the secondary key
        // to be marked as not using the master password.
        await hook.waitFor(() => {
            expect(hook.result.current.masterPasswordKeys).toMatchObject({
                [activeMasterKey.id]: true,
                [secondaryMasterKey.id]: false,
            });
        });
        // Same password as the master password but fails to decrypt: Should not be marked
        // as using the master password.
        hook.rerender(Object.assign(Object.assign({}, initialProps), { passwords: Object.assign(Object.assign({}, initialProps.passwords), { [secondaryMasterKey.id]: 'primary' }) }));
        await hook.waitFor(() => {
            expect(hook.result.current.masterPasswordKeys).toMatchObject({
                [activeMasterKey.id]: true,
                [secondaryMasterKey.id]: false,
            });
        });
    });
});
//# sourceMappingURL=utils.test.js.map