"use strict";
// This is a driver for better-sqlite3. It may be interesting to use it instead
// of node-sqlite because it breaks all the time when we try to compile any app.
// The performance improvement probably won't matter.
//
// The issue however is that better-sqlite3 uses the option SQLITE_DQS=0, which
// disallows using double quotes around strings, and that's what we're using
// everywhere. So the only way to make it work would be to do a custom
// compilation, as described there, and set SQLITE_DQS=1:
//
// https://github.com/JoshuaWise/better-sqlite3/blob/master/docs/compilation.md
Object.defineProperty(exports, "__esModule", { value: true });
const Database = require('better-sqlite3');
class DatabaseDriverBetterSqlite {
    constructor() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        this.db_ = null;
    }
    open(options) {
        this.db_ = new Database(options.name);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    sqliteErrorToJsError(error, sql = null, params = null) {
        console.error(error.toString(), ' ---- ', sql, params);
        const msg = [error.toString()];
        if (sql)
            msg.push(sql);
        if (params)
            msg.push(params);
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        const output = new Error(msg.join(': '));
        if (error.code)
            output.code = error.code;
        return output;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async selectOne(sql, params = null) {
        return this.db_.prepare(sql).get(params ? params : []);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async selectAll(sql, params = null) {
        return this.db_.prepare(sql).all(params ? params : []);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async exec(sql, params = null) {
        return this.db_.prepare(sql).run(params ? params : []);
    }
    lastInsertId() {
        throw new Error('NOT IMPLEMENTED');
    }
}
exports.default = DatabaseDriverBetterSqlite;
//# sourceMappingURL=database-driver-better-sqlite.js.map