"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_1 = require("./testing/test-utils");
describe('file-api-driver', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
        await (0, test_utils_1.fileApi)().clearRoot();
    });
    afterAll(async () => {
        await (0, test_utils_1.afterAllCleanUp)();
    });
    it('should create a file', (async () => {
        await (0, test_utils_1.fileApi)().put('test.txt', 'testing');
        const content = await (0, test_utils_1.fileApi)().get('test.txt');
        expect(content).toBe('testing');
    }));
    it('should get a file info', (async () => {
        await (0, test_utils_1.fileApi)().put('test1.txt', 'testing');
        await (0, test_utils_1.fileApi)().mkdir('sub');
        await (0, test_utils_1.fileApi)().put('sub/test2.txt', 'testing');
        // Note: Although the stat object includes an "isDir" property, this is
        // not actually used by the synchronizer so not required by any sync
        // target.
        {
            const stat = await (0, test_utils_1.fileApi)().stat('test1.txt');
            expect(stat.path).toBe('test1.txt');
            expect(!!stat.updated_time).toBe(true);
            expect(stat.isDir).toBe(false);
        }
        {
            const stat = await (0, test_utils_1.fileApi)().stat('sub/test2.txt');
            expect(stat.path).toBe('sub/test2.txt');
            expect(!!stat.updated_time).toBe(true);
            expect(stat.isDir).toBe(false);
        }
    }));
    it('should create a file in a subdirectory', (async () => {
        await (0, test_utils_1.fileApi)().mkdir('subdir');
        await (0, test_utils_1.fileApi)().put('subdir/test.txt', 'testing');
        const content = await (0, test_utils_1.fileApi)().get('subdir/test.txt');
        expect(content).toBe('testing');
    }));
    it('should list files', (async () => {
        await (0, test_utils_1.fileApi)().mkdir('subdir');
        await (0, test_utils_1.fileApi)().put('subdir/test1.txt', 'testing1');
        await (0, test_utils_1.fileApi)().put('subdir/test2.txt', 'testing2');
        const files = await (0, test_utils_1.fileApi)().list('subdir');
        expect(files.items.length).toBe(2);
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        expect(files.items.map((f) => f.path).sort()).toEqual(['test1.txt', 'test2.txt'].sort());
    }));
    it('should delete a file', (async () => {
        await (0, test_utils_1.fileApi)().put('test1.txt', 'testing1');
        await (0, test_utils_1.fileApi)().delete('test1.txt');
        const files = await (0, test_utils_1.fileApi)().list('');
        expect(files.items.length).toBe(0);
    }));
});
//# sourceMappingURL=file-api-driver.test.js.map