"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Logger_1 = require("@joplin/utils/Logger");
const shim_1 = require("./shim");
const logger = Logger_1.default.create('geolocation-node');
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const fetchJson = async (url) => {
    let r = await shim_1.default.fetch(url);
    if (!r.ok)
        throw new Error(`Could not get geolocation: ${await r.text()}`);
    r = await r.json();
    return r;
};
const geoipServices = {
    ipwhois: async () => {
        const r = await fetchJson('https://ipwho.is/');
        if (!('latitude' in r) || !('longitude' in r))
            throw new Error(`Invalid geolocation response: ${r ? JSON.stringify(r) : '<null>'}`);
        return {
            timestamp: Date.now(),
            coords: {
                longitude: r.longitude,
                altitude: 0,
                latitude: r.latitude,
            },
        };
    },
};
class default_1 {
    static async currentPosition(options = null) {
        if (!options)
            options = {};
        for (const [serviceName, handler] of Object.entries(geoipServices)) {
            try {
                const response = await handler();
                return response;
            }
            catch (error) {
                logger.warn(`Could not get geolocation from service "${serviceName}"`);
                logger.warn(error);
            }
        }
        throw new Error('Could not get geolocation from any of the services');
    }
}
exports.default = default_1;
//# sourceMappingURL=geolocation-node.js.map