"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const react_hooks_1 = require("@testing-library/react-hooks");
const useNowEffect_1 = require("./useNowEffect");
describe('useNowEffect', () => {
    test('should call the cleanup callback when the effect function is called and after unmount', async () => {
        const cleanupFunction = jest.fn(() => { });
        const effectFunction = jest.fn(() => cleanupFunction);
        const useTestHook = (dependencies) => {
            return (0, useNowEffect_1.default)(effectFunction, dependencies);
        };
        const hook = (0, react_hooks_1.renderHook)(useTestHook, { initialProps: [0] });
        expect(cleanupFunction).not.toHaveBeenCalled();
        expect(effectFunction).toHaveBeenCalledTimes(1);
        hook.rerender([0]);
        expect(cleanupFunction).not.toHaveBeenCalled();
        expect(effectFunction).toHaveBeenCalledTimes(1);
        hook.rerender([1]);
        expect(cleanupFunction).toHaveBeenCalledTimes(1);
        expect(effectFunction).toHaveBeenCalledTimes(2);
        hook.unmount();
        expect(cleanupFunction).toHaveBeenCalledTimes(2);
        expect(effectFunction).toHaveBeenCalledTimes(2);
    });
});
//# sourceMappingURL=useNowEffect.test.js.map