"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class NotePositionService {
    constructor() {
        this.cursorFallback_ = new Map();
        this.cursorLocations_ = new Map();
        this.scrollFallback_ = new Map();
        this.scrollLocations_ = new Map();
    }
    static instance() {
        var _a;
        (_a = this.instance_) !== null && _a !== void 0 ? _a : (this.instance_ = new NotePositionService());
        return this.instance_;
    }
    toFallbackKey_(noteId) {
        return `note:${noteId}`;
    }
    toKey_(noteId, windowId) {
        return `note-window:${windowId}--${noteId}`;
    }
    getCursorPosition(noteId, windowId) {
        var _a, _b;
        // If available, use the cursor position for the current window
        return (_b = (_a = this.cursorLocations_.get(this.toKey_(noteId, windowId))) !== null && _a !== void 0 ? _a : this.cursorFallback_.get(this.toFallbackKey_(noteId))) !== null && _b !== void 0 ? _b : {};
    }
    updateCursorPosition(noteId, windowId, position) {
        const key = this.toKey_(noteId, windowId);
        this.cursorLocations_.set(key, Object.assign(Object.assign({}, this.cursorLocations_.get(key)), position));
        const fallbackKey = this.toFallbackKey_(noteId);
        this.cursorFallback_.set(fallbackKey, Object.assign(Object.assign({}, this.cursorFallback_.get(fallbackKey)), position));
    }
    getScrollPercent(noteId, windowId) {
        var _a, _b;
        return (_b = (_a = this.scrollLocations_.get(this.toKey_(noteId, windowId))) !== null && _a !== void 0 ? _a : this.scrollFallback_.get(this.toFallbackKey_(noteId))) !== null && _b !== void 0 ? _b : 0;
    }
    updateScrollPosition(noteId, windowId, percent) {
        const key = this.toKey_(noteId, windowId);
        this.scrollLocations_.set(key, percent);
        this.scrollFallback_.set(this.toFallbackKey_(noteId), percent);
    }
}
exports.default = NotePositionService;
//# sourceMappingURL=NotePositionService.js.map