"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Setting_1 = require("../../models/Setting");
const PluginService_1 = require("../../services/plugins/PluginService");
const Logger_1 = require("@joplin/utils/Logger");
const shim_1 = require("../../shim");
const logger = Logger_1.default.create('loadPlugins');
const loadPlugins = async ({ pluginRunner, platformImplementation, pluginSettings, store, reloadAll, cancelEvent, }) => {
    try {
        const pluginService = PluginService_1.default.instance();
        pluginService.initialize(platformImplementation.versionInfo.version, platformImplementation, pluginRunner, store);
        pluginService.isSafeMode = Setting_1.default.value('isSafeMode');
        if (reloadAll) {
            logger.info('Reloading all plugins.');
        }
        for (const pluginId of pluginService.pluginIds) {
            if (reloadAll || (pluginSettings[pluginId] && !pluginSettings[pluginId].enabled)) {
                logger.info('Unloading plugin', pluginId);
                await pluginService.unloadPlugin(pluginId);
            }
            if (cancelEvent.cancelled) {
                logger.info('Cancelled.');
                return;
            }
        }
        await pluginService.loadAndRunDevPlugins(pluginSettings);
        if (cancelEvent.cancelled) {
            logger.info('Cancelled.');
            return;
        }
        if (await shim_1.default.fsDriver().exists(Setting_1.default.value('pluginDir'))) {
            logger.info('Running user-installed plugins...');
            await pluginService.loadAndRunPlugins(Setting_1.default.value('pluginDir'), pluginSettings);
        }
    }
    catch (error) {
        console.error(error);
        throw error;
    }
};
exports.default = loadPlugins;
//# sourceMappingURL=loadPlugins.js.map