"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BasePlatformImplementation_1 = require("../BasePlatformImplementation");
const shim_1 = require("../../../shim");
const Setting_1 = require("../../../models/Setting");
const registry_1 = require("../../../registry");
class MockPlatformImplementation extends BasePlatformImplementation_1.default {
    get versionInfo() {
        return {
            version: shim_1.default.appVersion(),
            syncVersion: Setting_1.default.value('syncVersion'),
            platform: 'desktop',
            profileVersion: registry_1.reg.db().version(),
        };
    }
    get nativeImage() {
        return null;
    }
    get imaging() {
        return null;
    }
    get joplin() {
        return { views: { dialogs: { showMessageBox: jest.fn(), showOpenDialog: jest.fn() } } };
    }
    get clipboard() {
        return null;
    }
}
exports.default = MockPlatformImplementation;
//# sourceMappingURL=MockPlatformImplementation.js.map