"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
const path_utils_1 = require("../../path-utils");
const shim_1 = require("../../shim");
const cssToTheme_1 = require("./cssToTheme");
async function default_1(cssBaseDir) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    const themeDirs = (await shim_1.default.fsDriver().readDirStats(cssBaseDir)).filter((f) => f.isDirectory());
    const output = {};
    for (const themeDir of themeDirs) {
        const themeName = (0, path_utils_1.filename)(themeDir.path);
        const cssFile = `${cssBaseDir}/${themeDir.path}/colors.css`;
        const cssContent = await shim_1.default.fsDriver().readFile(cssFile, 'utf8');
        let themeId = themeName;
        const manifestFile = `${cssBaseDir}/${themeDir.path}/manifest.json`;
        if (await shim_1.default.fsDriver().exists(manifestFile)) {
            const manifest = JSON.parse(await shim_1.default.fsDriver().readFile(manifestFile, 'utf8'));
            if (manifest.id)
                themeId = manifest.id;
        }
        output[themeId] = (0, cssToTheme_1.default)(cssContent, cssFile);
    }
    return output;
}
//# sourceMappingURL=loadCssToTheme.js.map