"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_1 = require("../../testing/test-utils");
const Folder_1 = require("../../models/Folder");
const syncInfoUtils_1 = require("../synchronizer/syncInfoUtils");
const EncryptionService_1 = require("../e2ee/EncryptionService");
const utils_1 = require("../e2ee/utils");
describe('Synchronizer.ppk', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(2);
        await (0, test_utils_1.switchClient)(1);
    });
    it('should not create a public private key pair if not using E2EE', async () => {
        await Folder_1.default.save({});
        expect((0, syncInfoUtils_1.localSyncInfo)().ppk).toBeFalsy();
        await (0, test_utils_1.synchronizerStart)();
        const remoteInfo = await (0, syncInfoUtils_1.fetchSyncInfo)((0, test_utils_1.fileApi)());
        expect((0, syncInfoUtils_1.localSyncInfo)().ppk).toBeFalsy();
        expect(remoteInfo.ppk).toBeFalsy();
    });
    it('should create a public private key pair if it does not exist', async () => {
        await (0, utils_1.updateMasterPassword)('', '111111');
        (0, syncInfoUtils_1.setEncryptionEnabled)(true);
        await (0, test_utils_1.loadEncryptionMasterKey)();
        const beforeTime = Date.now();
        await Folder_1.default.save({});
        expect((0, syncInfoUtils_1.localSyncInfo)().ppk).toBeFalsy();
        await (0, test_utils_1.synchronizerStart)();
        const remoteInfo = await (0, syncInfoUtils_1.fetchSyncInfo)((0, test_utils_1.fileApi)());
        expect((0, syncInfoUtils_1.localSyncInfo)().ppk).toBeTruthy();
        expect(remoteInfo.ppk).toBeTruthy();
        const clientLocalPPK1 = (0, syncInfoUtils_1.localSyncInfo)().ppk;
        expect(clientLocalPPK1.createdTime).toBeGreaterThanOrEqual(beforeTime);
        expect(clientLocalPPK1.privateKey.encryptionMethod).toBe(EncryptionService_1.EncryptionMethod.SJCL4);
        // Rather arbitrary length check - it's just to make sure there's
        // something there. Other tests should ensure the content is valid or
        // not.
        expect(clientLocalPPK1.privateKey.ciphertext.length).toBeGreaterThan(320);
        expect(clientLocalPPK1.publicKey.length).toBeGreaterThan(320);
        await (0, test_utils_1.switchClient)(2);
        expect((0, syncInfoUtils_1.localSyncInfo)().ppk).toBeFalsy();
        await (0, test_utils_1.synchronizerStart)();
        expect((0, syncInfoUtils_1.localSyncInfo)().ppk).toBeTruthy();
        const clientLocalPPK2 = (0, syncInfoUtils_1.localSyncInfo)().ppk;
        expect(clientLocalPPK1.privateKey.ciphertext).toBe(clientLocalPPK2.privateKey.ciphertext);
        expect(clientLocalPPK1.publicKey).toBe(clientLocalPPK2.publicKey);
    });
});
//# sourceMappingURL=Synchronizer.ppk.test.js.map