"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _1 = require(".");
const BaseModel_1 = require("../../BaseModel");
const Folder_1 = require("../../models/Folder");
const Note_1 = require("../../models/Note");
const object_1 = require("@joplin/utils/object");
const restoreItems = async (itemType, itemsOrIds, options = null) => {
    if (!itemsOrIds.length)
        return;
    options = Object.assign({ targetFolderId: null, useRestoreFolder: false }, options);
    const ModelClass = itemType === BaseModel_1.ModelType.Note ? Note_1.default : Folder_1.default;
    let items = [];
    if (typeof itemsOrIds[0] === 'string') {
        items = await ModelClass.byIds(itemsOrIds, { fields: ['id', 'parent_id', 'deleted_time'] });
    }
    else {
        items = itemsOrIds;
    }
    let restoreFolder = null;
    for (const item of items) {
        (0, object_1.checkObjectHasProperties)(item, ['id', 'parent_id']);
        let itemParentId = item.parent_id;
        const parentItem = await Folder_1.default.load(item.parent_id, { fields: ['id', 'deleted_time'] });
        if (!parentItem || parentItem.deleted_time) {
            if (options.useRestoreFolder) {
                if (!restoreFolder)
                    restoreFolder = await (0, _1.getRestoreFolder)();
                itemParentId = restoreFolder.id;
            }
            else {
                itemParentId = '';
            }
        }
        if (options.targetFolderId !== null)
            itemParentId = options.targetFolderId;
        let toSave = null;
        if (itemType === BaseModel_1.ModelType.Note) {
            // We need to preview conflicts -- they can be trashed.
            toSave = await Note_1.default.preview(item.id, { excludeConflicts: false });
        }
        else {
            toSave = await Folder_1.default.load(item.id);
        }
        toSave = Object.assign(Object.assign({}, toSave), { deleted_time: 0, updated_time: Date.now(), parent_id: itemParentId });
        await ModelClass.save(toSave, {
            autoTimestamp: false,
        });
        if (itemType === BaseModel_1.ModelType.Folder) {
            const childrenFolderIds = await Folder_1.default.childrenIds(item.id, { includeDeleted: true });
            const childrenFolders = await Folder_1.default.byIds(childrenFolderIds, { fields: ['id', 'parent_id', 'deleted_time'] });
            const deletedChildrenFolders = childrenFolders.filter(f => !!f.deleted_time);
            await restoreItems(BaseModel_1.ModelType.Folder, deletedChildrenFolders);
            const notes = await Folder_1.default.notes(item.id, {
                fields: ['id', 'parent_id'],
                includeDeleted: true,
            });
            await restoreItems(BaseModel_1.ModelType.Note, notes);
        }
    }
};
exports.default = restoreItems;
//# sourceMappingURL=restoreItems.js.map