"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const Setting_1 = require("../../models/Setting");
const fs_extra_1 = require("fs-extra");
const PluginService_1 = require("../../services/plugins/PluginService");
const setPluginEnabled = (id, enabled) => {
    const newPluginStates = Object.assign(Object.assign({}, Setting_1.default.value('plugins.states')), { [id]: Object.assign(Object.assign({}, (0, PluginService_1.defaultPluginSetting)()), { enabled }) });
    Setting_1.default.setValue('plugins.states', newPluginStates);
};
const createTestPlugin = async (manifest, { onStart = '', enabled = true } = {}) => {
    const pluginSource = `
		/* joplin-manifest:
		${JSON.stringify(manifest)}
		*/

		joplin.plugins.register({
			onStart: async function() {
				${onStart}
			},
		});
	`;
    const pluginPath = (0, path_1.join)(Setting_1.default.value('pluginDir'), `${manifest.id}.js`);
    await (0, fs_extra_1.writeFile)(pluginPath, pluginSource, 'utf-8');
    setPluginEnabled(manifest.id, enabled);
    return {
        manifest,
        setEnabled: (enabled) => {
            setPluginEnabled(manifest.id, enabled);
        },
    };
};
exports.default = createTestPlugin;
//# sourceMappingURL=createTestPlugin.js.map