"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const redux_1 = require("redux");
const reducer_1 = require("../../reducer");
const ShareService_1 = require("../../services/share/ShareService");
const test_utils_1 = require("../test-utils");
const testReducer = (state = reducer_1.defaultState, action) => {
    return (0, reducer_1.default)(state, action);
};
// Initializes a share service with mocks
const mockShareService = (apiCallHandler, service, store) => {
    service !== null && service !== void 0 ? service : (service = new ShareService_1.default());
    const api = {
        exec: (method, path = '', query = null, body = null, headers = null, options = null) => {
            if (apiCallHandler.onExec) {
                return apiCallHandler.onExec(method, path, query, body, headers, options);
            }
            if (path === 'api/shares') {
                if (method === 'GET') {
                    return apiCallHandler.getShares(query);
                }
                else if (method === 'POST') {
                    return apiCallHandler.postShares(query);
                }
            }
            else if (method === 'GET' && path === 'api/share_users') {
                return apiCallHandler.getShareInvitations(query);
            }
            const shareUsersMatch = path.match(/^api\/shares\/([^/]+)\/users$/);
            const shareId = shareUsersMatch === null || shareUsersMatch === void 0 ? void 0 : shareUsersMatch[1];
            if (shareId) {
                if (method === 'GET' && apiCallHandler.getShareUsers) {
                    return apiCallHandler.getShareUsers(shareId);
                }
                if (method === 'POST' && apiCallHandler.postShareUsers) {
                    return apiCallHandler.postShareUsers(shareId, body);
                }
            }
            if (apiCallHandler.onUnhandled) {
                return apiCallHandler.onUnhandled(method, path, query, body, headers, options);
            }
            return null;
        },
        personalizedUserContentBaseUrl(_userId) {
            return null;
        },
    };
    store !== null && store !== void 0 ? store : (store = (0, redux_1.createStore)(testReducer));
    service.initialize(store, (0, test_utils_1.encryptionService)(), api);
    return service;
};
exports.default = mockShareService;
//# sourceMappingURL=mockShareService.js.map