"use strict";
// The purpose of this handler is to have all focus/blur calls go through the same place, which
// makes it easier to log what happens. This is useful when one unknown component is stealing focus
// from another component. Potentially it could also be used to resolve conflict situations when
// multiple components try to set the focus at the same time.
Object.defineProperty(exports, "__esModule", { value: true });
exports.blur = exports.focus = void 0;
const Logger_1 = require("@joplin/utils/Logger");
const logger = Logger_1.default.create('focusHandler');
var ToggleFocusAction;
(function (ToggleFocusAction) {
    ToggleFocusAction["Focus"] = "focus";
    ToggleFocusAction["Blur"] = "blur";
})(ToggleFocusAction || (ToggleFocusAction = {}));
const toggleFocus = (source, element, action, options) => {
    if (!element) {
        logger.warn(`Tried action "${action}" on an undefined element: ${source}`);
        return;
    }
    if (!element[action]) {
        logger.warn(`Element does not have a "${action}" method: ${source}`);
        return;
    }
    logger.debug(`Action "${action}" from "${source}"`);
    if (options) {
        element[action](options);
    }
    else {
        element[action]();
    }
};
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const focus = (source, element, options = null) => {
    toggleFocus(source, element, ToggleFocusAction.Focus, options);
};
exports.focus = focus;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const blur = (source, element) => {
    toggleFocus(source, element, ToggleFocusAction.Blur, null);
};
exports.blur = blur;
//# sourceMappingURL=focusHandler.js.map