"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeUserFetcher = void 0;
const eventManager_1 = require("../eventManager");
const Setting_1 = require("../models/Setting");
const isJoplinServerVariant_1 = require("../models/utils/isJoplinServerVariant");
const registry_1 = require("../registry");
const Logger_1 = require("@joplin/utils/Logger");
const logger = Logger_1.default.create('userFetcher');
const userFetcher = async () => {
    if (!(0, isJoplinServerVariant_1.default)(Setting_1.default.value('sync.target')))
        return;
    const syncTarget = registry_1.reg.syncTarget();
    const fileApi = await syncTarget.fileApi();
    const api = fileApi.driver().api();
    if (!api.userId) {
        // That can happen if we don't have a session yet or if it has been
        // cleared
        logger.info('Skipping fetching user because user ID is not available');
        return;
    }
    const owner = await api.exec('GET', `api/users/${api.userId}`);
    logger.info('Got user:', owner);
    Setting_1.default.setValue('sync.10.inboxId', owner.inbox ? owner.inbox.jop_id : '');
    Setting_1.default.setValue('sync.10.inboxEmail', owner.inbox_email ? owner.inbox_email : '');
    Setting_1.default.setValue('sync.10.canUseSharePermissions', !!owner.can_use_share_permissions);
    Setting_1.default.setValue('sync.10.accountType', owner.account_type);
    Setting_1.default.setValue('sync.10.userEmail', owner.email);
};
// Listen to the event only once
const initializeUserFetcher = () => {
    eventManager_1.default.once(eventManager_1.EventName.SessionEstablished, userFetcher);
};
exports.initializeUserFetcher = initializeUserFetcher;
exports.default = userFetcher;
//# sourceMappingURL=userFetcher.js.map