"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const webDAVUtils_1 = require("./webDAVUtils");
const Setting_1 = require("../models/Setting");
describe('checkProviderIsSupported', () => {
    describe('when no unsupported provider is already configured', () => {
        beforeAll(() => {
            Setting_1.default.setValue('sync.allowUnsupportedProviders', 0);
        });
        it('should not throw when no provider path is provided ', () => {
            expect(() => (0, webDAVUtils_1.default)('')).not.toThrow();
        });
        it('should not throw when a valid provider path is provided', () => {
            expect(() => (0, webDAVUtils_1.default)('https://good-webdav-provider.com')).not.toThrow();
        });
        it('should not throw when a valid provider path with a name that contains an unsupported provider is provided', () => {
            expect(() => (0, webDAVUtils_1.default)('https://hopcloudabc.com')).not.toThrow();
        });
        it('should throw an error with the name of the provider when an unsupported provider path is provided', () => {
            expect(() => (0, webDAVUtils_1.default)('https://jianguoyun.com')).toThrowError('The WebDAV implementation of jianguoyun is incompatible with Joplin, and as such is no longer supported. Please use a different sync method.');
            expect(() => (0, webDAVUtils_1.default)('https://api.jianguoyun.com')).toThrowError('The WebDAV implementation of jianguoyun is incompatible with Joplin, and as such is no longer supported. Please use a different sync method.');
            // expect(() => checkProviderIsSupported('https://api-pcloud-test.com')).toThrowError('The WebDAV implementation of pcloud is incompatible with Joplin, and as such is no longer supported. Please use a different sync method.');
        });
        // expect(() => checkProviderIsSupported('?param=pcloud')).toThrowError('The WebDAV implementation of pcloud is incompatible with Joplin, and as such is no longer supported. Please use a different sync method.');
    });
    describe('when an unsupported provider is already configured', () => {
        beforeAll(() => {
            Setting_1.default.setValue('sync.allowUnsupportedProviders', 1);
        });
        it('should not throw when an unsupported provider is already configured', () => {
            expect(() => (0, webDAVUtils_1.default)('pcloud')).not.toThrow();
        });
    });
});
//# sourceMappingURL=webDAVUtils.test.js.map