"use strict";
// This rule is used to add a media player for certain resource types below
// the link.
Object.defineProperty(exports, "__esModule", { value: true });
const MdToHtml_1 = require("../../MdToHtml");
const renderMedia_1 = require("../renderMedia");
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function plugin(markdownIt, ruleOptions) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    const defaultRender = markdownIt.renderer.rules.link_close || function (tokens, idx, options, _env, self) {
        return self.renderToken(tokens, idx, options);
    };
    const linkIndexes = {};
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    markdownIt.renderer.rules.link_close = function (tokens, idx, options, env, self) {
        const defaultOutput = defaultRender(tokens, idx, options, env, self);
        const link = ruleOptions.context.currentLinks.pop();
        if (!link || ruleOptions.linkRenderingType === MdToHtml_1.LinkRenderingType.HrefHandler || ruleOptions.plainResourceRendering)
            return defaultOutput;
        return [defaultOutput, (0, renderMedia_1.default)(link, ruleOptions, linkIndexes)].join('');
    };
}
exports.default = { plugin };
//# sourceMappingURL=link_close.js.map