"use strict";
/* eslint-disable import/prefer-default-export */
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchWithRetry = void 0;
const time_1 = require("./time");
const node_fetch_1 = require("node-fetch");
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const fetchWithRetry = async (url, opts = null) => {
    if (!opts)
        opts = {};
    let retry = opts && opts.retry || 3;
    while (retry > 0) {
        try {
            return (0, node_fetch_1.default)(url, opts);
        }
        catch (e) {
            if (opts && opts.callback) {
                opts.callback(retry);
            }
            retry = retry - 1;
            if (retry === 0) {
                throw e;
            }
            if (opts && opts.pause) {
                await (0, time_1.msleep)(opts.pause);
            }
        }
    }
    return null;
};
exports.fetchWithRetry = fetchWithRetry;
//# sourceMappingURL=net.js.map