"use strict";
// -----------------------------------------------------------------------------------------------
// NOTE: Some of the code in here is copied from @joplin/lib/time. New time-related code should be
// added here, and should be based on dayjs (not moment)
// -----------------------------------------------------------------------------------------------
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatMsToUTC = exports.goBackInTime = exports.formatMsToDurationCompat = exports.formatDateTimeLocalToMs = exports.isValidDate = exports.formatMsToDateTimeLocal = exports.formatMsToLocal = exports.setTimeFormat = exports.setDateFormat = exports.setTimeLocale = exports.formatMsToRelative = exports.msleep = exports.Month = exports.Week = exports.Day = exports.Hour = exports.Minute = exports.Second = void 0;
exports.timerPush = timerPush;
exports.timerPop = timerPop;
const dayJsUtc = require("dayjs/plugin/utc");
// A require() is needed here for this to work in React Native.
const dayjs = require('dayjs');
const dayJsRelativeTime = require('dayjs/plugin/relativeTime');
const supportedLocales = {
    'ar': require('dayjs/locale/ar'),
    'bg': require('dayjs/locale/bg'),
    'bs': require('dayjs/locale/bs'),
    'ca': require('dayjs/locale/ca'),
    'cs': require('dayjs/locale/cs'),
    'da': require('dayjs/locale/da'),
    'de': require('dayjs/locale/de'),
    'el': require('dayjs/locale/el'),
    'en-gb': require('dayjs/locale/en-gb'),
    'en': require('dayjs/locale/en'),
    'eo': require('dayjs/locale/eo'),
    'es': require('dayjs/locale/es'),
    'et': require('dayjs/locale/et'),
    'eu': require('dayjs/locale/eu'),
    'fa': require('dayjs/locale/fa'),
    'fi': require('dayjs/locale/fi'),
    'fr': require('dayjs/locale/fr'),
    'gl': require('dayjs/locale/gl'),
    'hr': require('dayjs/locale/hr'),
    'hu': require('dayjs/locale/hu'),
    'id': require('dayjs/locale/id'),
    'it': require('dayjs/locale/it'),
    'ja': require('dayjs/locale/ja'),
    'ko': require('dayjs/locale/ko'),
    'nb': require('dayjs/locale/nb'),
    'nl-be': require('dayjs/locale/nl-be'),
    'nl': require('dayjs/locale/nl'),
    'pl': require('dayjs/locale/pl'),
    'pt-br': require('dayjs/locale/pt-br'),
    'pt': require('dayjs/locale/pt'),
    'ro': require('dayjs/locale/ro'),
    'ru': require('dayjs/locale/ru'),
    'sl': require('dayjs/locale/sl'),
    'sr': require('dayjs/locale/sr'),
    'sv': require('dayjs/locale/sv'),
    'th': require('dayjs/locale/th'),
    'tr': require('dayjs/locale/tr'),
    'uk': require('dayjs/locale/uk'),
    'vi': require('dayjs/locale/vi'),
    'zh-cn': require('dayjs/locale/zh-cn'),
    'zh-tw': require('dayjs/locale/zh-tw'),
};
exports.Second = 1000;
exports.Minute = 60 * exports.Second;
exports.Hour = 60 * exports.Minute;
exports.Day = 24 * exports.Hour;
exports.Week = 7 * exports.Day;
exports.Month = 30 * exports.Day;
function initDayJs() {
    dayjs.extend(dayJsRelativeTime);
    dayjs.extend(dayJsUtc);
}
initDayJs();
let dateFormat_ = 'DD/MM/YYYY';
let timeFormat_ = 'HH:mm';
const msleep = (ms) => {
    return new Promise(resolve => setTimeout(resolve, ms));
};
exports.msleep = msleep;
const perfTimers_ = [];
function timerPush(name) {
    perfTimers_.push({ name, startTime: Date.now() });
}
function timerPop() {
    const t = perfTimers_.pop();
    // eslint-disable-next-line no-console
    console.info(`Time: ${t.name}: ${Date.now() - t.startTime}`);
}
const formatMsToRelative = (ms) => {
    if (Date.now() - ms > 2 * exports.Day)
        return (0, exports.formatMsToLocal)(ms);
    const d = dayjs(ms);
    // The expected pattern for invalid date formatting in JS is to return the string "Invalid
    // Date", so we do that here. If we don't, dayjs will process the invalid date and return "a
    // month ago", somehow...
    if (!d.isValid())
        return 'Invalid date';
    return d.fromNow(false);
};
exports.formatMsToRelative = formatMsToRelative;
const joplinLocaleToDayJsLocale = (locale) => {
    locale = locale.toLowerCase().replace(/_/, '-');
    if (supportedLocales[locale])
        return locale;
    const lang = locale.split('-')[0];
    if (supportedLocales[lang])
        return lang;
    return 'en-gb';
};
const setTimeLocale = (locale) => {
    const dayJsLocale = joplinLocaleToDayJsLocale(locale);
    dayjs.locale(dayJsLocale);
};
exports.setTimeLocale = setTimeLocale;
const setDateFormat = (format) => {
    dateFormat_ = format;
};
exports.setDateFormat = setDateFormat;
const setTimeFormat = (format) => {
    timeFormat_ = format;
};
exports.setTimeFormat = setTimeFormat;
const dateFormat = () => {
    return dateFormat_;
};
const timeFormat = () => {
    return timeFormat_;
};
const dateTimeFormat = () => {
    return `${dateFormat()} ${timeFormat()}`;
};
const formatMsToLocal = (ms, format = null) => {
    if (format === null)
        format = dateTimeFormat();
    return dayjs(ms).format(format);
};
exports.formatMsToLocal = formatMsToLocal;
const formatMsToDateTimeLocal = (ms) => {
    return (0, exports.formatMsToLocal)(ms, 'YYYY-MM-DDTHH:mm');
};
exports.formatMsToDateTimeLocal = formatMsToDateTimeLocal;
const isValidDate = (anything) => {
    return dayjs(anything).isValid();
};
exports.isValidDate = isValidDate;
const formatDateTimeLocalToMs = (anything) => {
    return dayjs(anything).unix() * 1000;
};
exports.formatDateTimeLocalToMs = formatDateTimeLocalToMs;
const formatMsToDurationCompat = (ms) => {
    // Avoid using dayjs (and @joplin/utils/time) for formatting here.
    // See https://github.com/laurent22/joplin/issues/11864
    const seconds = Math.floor(ms / exports.Second) % 60;
    const minutes = Math.floor(ms / exports.Minute);
    const paddedSeconds = `${seconds}`.padStart(2, '0');
    return `${minutes}:${paddedSeconds}`;
};
exports.formatMsToDurationCompat = formatMsToDurationCompat;
const goBackInTime = (startDateMs, n, period) => {
    return dayjs(startDateMs).subtract(n, period);
};
exports.goBackInTime = goBackInTime;
const formatMsToUTC = (ms, format = null) => {
    if (format === null)
        format = dateTimeFormat();
    return dayjs(ms).utc().format(format);
};
exports.formatMsToUTC = formatMsToUTC;
//# sourceMappingURL=time.js.map