"use strict";
/* eslint-disable import/prefer-default-export */
Object.defineProperty(exports, "__esModule", { value: true });
exports.versionPatch = void 0;
const fs_extra_1 = require("fs-extra");
const promises_1 = require("fs/promises");
const versionPatch = async () => {
    if (!(await (0, fs_extra_1.pathExists)('package.json')))
        throw new Error('Run this from the root of the package (./package.json not found)');
    const content = JSON.parse(await (0, fs_extra_1.readFile)('package.json', 'utf-8'));
    const version = content.version;
    if (!version)
        throw new Error('Version field could not be updated');
    const s = version.split('.');
    s[2] = (Number(s[2]) + 1).toString();
    const newVersion = s.join('.');
    content.version = newVersion;
    await (0, promises_1.writeFile)('package.json', `${JSON.stringify(content, null, '  ')}\n`, 'utf-8');
    return `v${newVersion}`;
};
exports.versionPatch = versionPatch;
//# sourceMappingURL=version.js.map