/**
 * @author Titus Wormer
 * @copyright 2016 Titus Wormer
 * @license MIT
 * @module emphasize
 * @fileoverview Syntax highlighting in ANSI.
 */

'use strict';

/* Expose. */
var emphasize = module.exports = require('./lib/core.js');

emphasize.registerLanguage('1c', require('highlight.js/lib/languages/1c'));
emphasize.registerLanguage('abnf', require('highlight.js/lib/languages/abnf'));
emphasize.registerLanguage('accesslog', require('highlight.js/lib/languages/accesslog'));
emphasize.registerLanguage('actionscript', require('highlight.js/lib/languages/actionscript'));
emphasize.registerLanguage('ada', require('highlight.js/lib/languages/ada'));
emphasize.registerLanguage('apache', require('highlight.js/lib/languages/apache'));
emphasize.registerLanguage('applescript', require('highlight.js/lib/languages/applescript'));
emphasize.registerLanguage('cpp', require('highlight.js/lib/languages/cpp'));
emphasize.registerLanguage('arduino', require('highlight.js/lib/languages/arduino'));
emphasize.registerLanguage('armasm', require('highlight.js/lib/languages/armasm'));
emphasize.registerLanguage('xml', require('highlight.js/lib/languages/xml'));
emphasize.registerLanguage('asciidoc', require('highlight.js/lib/languages/asciidoc'));
emphasize.registerLanguage('aspectj', require('highlight.js/lib/languages/aspectj'));
emphasize.registerLanguage('autohotkey', require('highlight.js/lib/languages/autohotkey'));
emphasize.registerLanguage('autoit', require('highlight.js/lib/languages/autoit'));
emphasize.registerLanguage('avrasm', require('highlight.js/lib/languages/avrasm'));
emphasize.registerLanguage('awk', require('highlight.js/lib/languages/awk'));
emphasize.registerLanguage('axapta', require('highlight.js/lib/languages/axapta'));
emphasize.registerLanguage('bash', require('highlight.js/lib/languages/bash'));
emphasize.registerLanguage('basic', require('highlight.js/lib/languages/basic'));
emphasize.registerLanguage('bnf', require('highlight.js/lib/languages/bnf'));
emphasize.registerLanguage('brainfuck', require('highlight.js/lib/languages/brainfuck'));
emphasize.registerLanguage('cal', require('highlight.js/lib/languages/cal'));
emphasize.registerLanguage('capnproto', require('highlight.js/lib/languages/capnproto'));
emphasize.registerLanguage('ceylon', require('highlight.js/lib/languages/ceylon'));
emphasize.registerLanguage('clean', require('highlight.js/lib/languages/clean'));
emphasize.registerLanguage('clojure', require('highlight.js/lib/languages/clojure'));
emphasize.registerLanguage('clojure-repl', require('highlight.js/lib/languages/clojure-repl'));
emphasize.registerLanguage('cmake', require('highlight.js/lib/languages/cmake'));
emphasize.registerLanguage('coffeescript', require('highlight.js/lib/languages/coffeescript'));
emphasize.registerLanguage('coq', require('highlight.js/lib/languages/coq'));
emphasize.registerLanguage('cos', require('highlight.js/lib/languages/cos'));
emphasize.registerLanguage('crmsh', require('highlight.js/lib/languages/crmsh'));
emphasize.registerLanguage('crystal', require('highlight.js/lib/languages/crystal'));
emphasize.registerLanguage('cs', require('highlight.js/lib/languages/cs'));
emphasize.registerLanguage('csp', require('highlight.js/lib/languages/csp'));
emphasize.registerLanguage('css', require('highlight.js/lib/languages/css'));
emphasize.registerLanguage('d', require('highlight.js/lib/languages/d'));
emphasize.registerLanguage('markdown', require('highlight.js/lib/languages/markdown'));
emphasize.registerLanguage('dart', require('highlight.js/lib/languages/dart'));
emphasize.registerLanguage('delphi', require('highlight.js/lib/languages/delphi'));
emphasize.registerLanguage('diff', require('highlight.js/lib/languages/diff'));
emphasize.registerLanguage('django', require('highlight.js/lib/languages/django'));
emphasize.registerLanguage('dns', require('highlight.js/lib/languages/dns'));
emphasize.registerLanguage('dockerfile', require('highlight.js/lib/languages/dockerfile'));
emphasize.registerLanguage('dos', require('highlight.js/lib/languages/dos'));
emphasize.registerLanguage('dsconfig', require('highlight.js/lib/languages/dsconfig'));
emphasize.registerLanguage('dts', require('highlight.js/lib/languages/dts'));
emphasize.registerLanguage('dust', require('highlight.js/lib/languages/dust'));
emphasize.registerLanguage('ebnf', require('highlight.js/lib/languages/ebnf'));
emphasize.registerLanguage('elixir', require('highlight.js/lib/languages/elixir'));
emphasize.registerLanguage('elm', require('highlight.js/lib/languages/elm'));
emphasize.registerLanguage('ruby', require('highlight.js/lib/languages/ruby'));
emphasize.registerLanguage('erb', require('highlight.js/lib/languages/erb'));
emphasize.registerLanguage('erlang-repl', require('highlight.js/lib/languages/erlang-repl'));
emphasize.registerLanguage('erlang', require('highlight.js/lib/languages/erlang'));
emphasize.registerLanguage('excel', require('highlight.js/lib/languages/excel'));
emphasize.registerLanguage('fix', require('highlight.js/lib/languages/fix'));
emphasize.registerLanguage('flix', require('highlight.js/lib/languages/flix'));
emphasize.registerLanguage('fortran', require('highlight.js/lib/languages/fortran'));
emphasize.registerLanguage('fsharp', require('highlight.js/lib/languages/fsharp'));
emphasize.registerLanguage('gams', require('highlight.js/lib/languages/gams'));
emphasize.registerLanguage('gauss', require('highlight.js/lib/languages/gauss'));
emphasize.registerLanguage('gcode', require('highlight.js/lib/languages/gcode'));
emphasize.registerLanguage('gherkin', require('highlight.js/lib/languages/gherkin'));
emphasize.registerLanguage('glsl', require('highlight.js/lib/languages/glsl'));
emphasize.registerLanguage('go', require('highlight.js/lib/languages/go'));
emphasize.registerLanguage('golo', require('highlight.js/lib/languages/golo'));
emphasize.registerLanguage('gradle', require('highlight.js/lib/languages/gradle'));
emphasize.registerLanguage('groovy', require('highlight.js/lib/languages/groovy'));
emphasize.registerLanguage('haml', require('highlight.js/lib/languages/haml'));
emphasize.registerLanguage('handlebars', require('highlight.js/lib/languages/handlebars'));
emphasize.registerLanguage('haskell', require('highlight.js/lib/languages/haskell'));
emphasize.registerLanguage('haxe', require('highlight.js/lib/languages/haxe'));
emphasize.registerLanguage('hsp', require('highlight.js/lib/languages/hsp'));
emphasize.registerLanguage('htmlbars', require('highlight.js/lib/languages/htmlbars'));
emphasize.registerLanguage('http', require('highlight.js/lib/languages/http'));
emphasize.registerLanguage('hy', require('highlight.js/lib/languages/hy'));
emphasize.registerLanguage('inform7', require('highlight.js/lib/languages/inform7'));
emphasize.registerLanguage('ini', require('highlight.js/lib/languages/ini'));
emphasize.registerLanguage('irpf90', require('highlight.js/lib/languages/irpf90'));
emphasize.registerLanguage('java', require('highlight.js/lib/languages/java'));
emphasize.registerLanguage('javascript', require('highlight.js/lib/languages/javascript'));
emphasize.registerLanguage('jboss-cli', require('highlight.js/lib/languages/jboss-cli'));
emphasize.registerLanguage('json', require('highlight.js/lib/languages/json'));
emphasize.registerLanguage('julia', require('highlight.js/lib/languages/julia'));
emphasize.registerLanguage('julia-repl', require('highlight.js/lib/languages/julia-repl'));
emphasize.registerLanguage('kotlin', require('highlight.js/lib/languages/kotlin'));
emphasize.registerLanguage('lasso', require('highlight.js/lib/languages/lasso'));
emphasize.registerLanguage('ldif', require('highlight.js/lib/languages/ldif'));
emphasize.registerLanguage('leaf', require('highlight.js/lib/languages/leaf'));
emphasize.registerLanguage('less', require('highlight.js/lib/languages/less'));
emphasize.registerLanguage('lisp', require('highlight.js/lib/languages/lisp'));
emphasize.registerLanguage('livecodeserver', require('highlight.js/lib/languages/livecodeserver'));
emphasize.registerLanguage('livescript', require('highlight.js/lib/languages/livescript'));
emphasize.registerLanguage('llvm', require('highlight.js/lib/languages/llvm'));
emphasize.registerLanguage('lsl', require('highlight.js/lib/languages/lsl'));
emphasize.registerLanguage('lua', require('highlight.js/lib/languages/lua'));
emphasize.registerLanguage('makefile', require('highlight.js/lib/languages/makefile'));
emphasize.registerLanguage('mathematica', require('highlight.js/lib/languages/mathematica'));
emphasize.registerLanguage('matlab', require('highlight.js/lib/languages/matlab'));
emphasize.registerLanguage('maxima', require('highlight.js/lib/languages/maxima'));
emphasize.registerLanguage('mel', require('highlight.js/lib/languages/mel'));
emphasize.registerLanguage('mercury', require('highlight.js/lib/languages/mercury'));
emphasize.registerLanguage('mipsasm', require('highlight.js/lib/languages/mipsasm'));
emphasize.registerLanguage('mizar', require('highlight.js/lib/languages/mizar'));
emphasize.registerLanguage('perl', require('highlight.js/lib/languages/perl'));
emphasize.registerLanguage('mojolicious', require('highlight.js/lib/languages/mojolicious'));
emphasize.registerLanguage('monkey', require('highlight.js/lib/languages/monkey'));
emphasize.registerLanguage('moonscript', require('highlight.js/lib/languages/moonscript'));
emphasize.registerLanguage('n1ql', require('highlight.js/lib/languages/n1ql'));
emphasize.registerLanguage('nginx', require('highlight.js/lib/languages/nginx'));
emphasize.registerLanguage('nimrod', require('highlight.js/lib/languages/nimrod'));
emphasize.registerLanguage('nix', require('highlight.js/lib/languages/nix'));
emphasize.registerLanguage('nsis', require('highlight.js/lib/languages/nsis'));
emphasize.registerLanguage('objectivec', require('highlight.js/lib/languages/objectivec'));
emphasize.registerLanguage('ocaml', require('highlight.js/lib/languages/ocaml'));
emphasize.registerLanguage('openscad', require('highlight.js/lib/languages/openscad'));
emphasize.registerLanguage('oxygene', require('highlight.js/lib/languages/oxygene'));
emphasize.registerLanguage('parser3', require('highlight.js/lib/languages/parser3'));
emphasize.registerLanguage('pf', require('highlight.js/lib/languages/pf'));
emphasize.registerLanguage('php', require('highlight.js/lib/languages/php'));
emphasize.registerLanguage('pony', require('highlight.js/lib/languages/pony'));
emphasize.registerLanguage('powershell', require('highlight.js/lib/languages/powershell'));
emphasize.registerLanguage('processing', require('highlight.js/lib/languages/processing'));
emphasize.registerLanguage('profile', require('highlight.js/lib/languages/profile'));
emphasize.registerLanguage('prolog', require('highlight.js/lib/languages/prolog'));
emphasize.registerLanguage('protobuf', require('highlight.js/lib/languages/protobuf'));
emphasize.registerLanguage('puppet', require('highlight.js/lib/languages/puppet'));
emphasize.registerLanguage('purebasic', require('highlight.js/lib/languages/purebasic'));
emphasize.registerLanguage('python', require('highlight.js/lib/languages/python'));
emphasize.registerLanguage('q', require('highlight.js/lib/languages/q'));
emphasize.registerLanguage('qml', require('highlight.js/lib/languages/qml'));
emphasize.registerLanguage('r', require('highlight.js/lib/languages/r'));
emphasize.registerLanguage('rib', require('highlight.js/lib/languages/rib'));
emphasize.registerLanguage('roboconf', require('highlight.js/lib/languages/roboconf'));
emphasize.registerLanguage('routeros', require('highlight.js/lib/languages/routeros'));
emphasize.registerLanguage('rsl', require('highlight.js/lib/languages/rsl'));
emphasize.registerLanguage('ruleslanguage', require('highlight.js/lib/languages/ruleslanguage'));
emphasize.registerLanguage('rust', require('highlight.js/lib/languages/rust'));
emphasize.registerLanguage('scala', require('highlight.js/lib/languages/scala'));
emphasize.registerLanguage('scheme', require('highlight.js/lib/languages/scheme'));
emphasize.registerLanguage('scilab', require('highlight.js/lib/languages/scilab'));
emphasize.registerLanguage('scss', require('highlight.js/lib/languages/scss'));
emphasize.registerLanguage('shell', require('highlight.js/lib/languages/shell'));
emphasize.registerLanguage('smali', require('highlight.js/lib/languages/smali'));
emphasize.registerLanguage('smalltalk', require('highlight.js/lib/languages/smalltalk'));
emphasize.registerLanguage('sml', require('highlight.js/lib/languages/sml'));
emphasize.registerLanguage('sqf', require('highlight.js/lib/languages/sqf'));
emphasize.registerLanguage('sql', require('highlight.js/lib/languages/sql'));
emphasize.registerLanguage('stan', require('highlight.js/lib/languages/stan'));
emphasize.registerLanguage('stata', require('highlight.js/lib/languages/stata'));
emphasize.registerLanguage('step21', require('highlight.js/lib/languages/step21'));
emphasize.registerLanguage('stylus', require('highlight.js/lib/languages/stylus'));
emphasize.registerLanguage('subunit', require('highlight.js/lib/languages/subunit'));
emphasize.registerLanguage('swift', require('highlight.js/lib/languages/swift'));
emphasize.registerLanguage('taggerscript', require('highlight.js/lib/languages/taggerscript'));
emphasize.registerLanguage('yaml', require('highlight.js/lib/languages/yaml'));
emphasize.registerLanguage('tap', require('highlight.js/lib/languages/tap'));
emphasize.registerLanguage('tcl', require('highlight.js/lib/languages/tcl'));
emphasize.registerLanguage('tex', require('highlight.js/lib/languages/tex'));
emphasize.registerLanguage('thrift', require('highlight.js/lib/languages/thrift'));
emphasize.registerLanguage('tp', require('highlight.js/lib/languages/tp'));
emphasize.registerLanguage('twig', require('highlight.js/lib/languages/twig'));
emphasize.registerLanguage('typescript', require('highlight.js/lib/languages/typescript'));
emphasize.registerLanguage('vala', require('highlight.js/lib/languages/vala'));
emphasize.registerLanguage('vbnet', require('highlight.js/lib/languages/vbnet'));
emphasize.registerLanguage('vbscript', require('highlight.js/lib/languages/vbscript'));
emphasize.registerLanguage('vbscript-html', require('highlight.js/lib/languages/vbscript-html'));
emphasize.registerLanguage('verilog', require('highlight.js/lib/languages/verilog'));
emphasize.registerLanguage('vhdl', require('highlight.js/lib/languages/vhdl'));
emphasize.registerLanguage('vim', require('highlight.js/lib/languages/vim'));
emphasize.registerLanguage('x86asm', require('highlight.js/lib/languages/x86asm'));
emphasize.registerLanguage('xl', require('highlight.js/lib/languages/xl'));
emphasize.registerLanguage('xquery', require('highlight.js/lib/languages/xquery'));
emphasize.registerLanguage('zephir', require('highlight.js/lib/languages/zephir'));
