"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shim_1 = require("@joplin/lib/shim");
const app_1 = require("../app");
const locale_1 = require("@joplin/lib/locale");
const { shimInit } = require('@joplin/lib/shim-init-node.js');
const shimInitCli = (options) => {
    shimInit(options);
    shim_1.default.showMessageBox = async (message, options) => {
        var _a, _b, _c;
        const gui = (_a = (0, app_1.default)()) === null || _a === void 0 ? void 0 : _a.gui();
        let answers = (_b = options.buttons) !== null && _b !== void 0 ? _b : [(0, locale_1._)('OK'), (0, locale_1._)('Cancel')];
        if (options.type === 'error' || options.type === 'info') {
            answers = [];
        }
        message += answers.length ? `(${answers.join(', ')})` : '';
        const answer = await gui.prompt((_c = options.title) !== null && _c !== void 0 ? _c : '', `${message} `, { answers });
        if (answers.includes(answer)) {
            return answers.indexOf(answer);
        }
        else if (answer) {
            return answers.findIndex(a => a.startsWith(answer));
        }
        return -1;
    };
};
exports.default = shimInitCli;
//# sourceMappingURL=shimInitCli.js.map