"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkerProcessMongoshBus = void 0;
const rpc_1 = require("./rpc");
class WorkerProcessMongoshBus {
    constructor(eventEmitter, worker) {
        const exposedEmitter = (0, rpc_1.exposeAll)({
            emit(...args) {
                eventEmitter.emit(...args);
            },
            on() {
                throw new Error("Can't use `on` method on WorkerProcessMongoshBus");
            },
            once() {
                throw new Error("Can't use `once` method on WorkerProcessMongoshBus");
            },
        }, worker);
        this.exposedEmitter = exposedEmitter;
    }
    terminate() {
        this.exposedEmitter[rpc_1.close]();
    }
}
exports.WorkerProcessMongoshBus = WorkerProcessMongoshBus;
//# sourceMappingURL=worker-process-mongosh-bus.js.map