import type { Runtime, RuntimeEvaluationListener } from '@mongosh/browser-runtime-core';
import { CompassServiceProvider } from '@mongosh/service-provider-node-driver';
import type { InterruptHandle } from 'interruptor';
type DevtoolsConnectOptions = Parameters<(typeof CompassServiceProvider)['connect']>[1];
export type WorkerRuntimeEvaluationListener = RuntimeEvaluationListener & {
    onRunInterruptible(handle: InterruptHandle | null): void;
};
export type WorkerRuntime = Runtime & {
    init(uri: string, driverOptions?: DevtoolsConnectOptions, cliOptions?: {
        nodb?: boolean;
    }): Promise<void>;
    interrupt(): boolean;
};
export {};
