import { IMongoCrypt, IMongoCryptContext, MongoCryptKMSRequest, MongoCryptOptions, MongoCryptStatus } from './bindings';
import { cryptoCallbacks } from './crypto_callbacks';
export { cryptoCallbacks };
export declare class MongoCryptContext implements IMongoCryptContext {
    private context;
    private errorWrapper;
    constructor(context: IMongoCryptContext, errorWrapper: MongoCryptOptions['errorWrapper']);
    nextMongoOperation(): Buffer;
    addMongoOperationResponse(response: Uint8Array): void;
    finishMongoOperation(): void;
    nextKMSRequest(): MongoCryptKMSRequest | null;
    provideKMSProviders(providers: Uint8Array): void;
    finishKMSRequests(): void;
    finalize(): Buffer;
    get status(): MongoCryptStatus;
    get state(): number;
}
export declare class MongoCrypt implements IMongoCrypt {
    private errorWrapper;
    private mc;
    readonly cryptSharedLibVersionInfo: {
        version: bigint;
        versionStr: string;
    } | null;
    readonly cryptoHooksProvider: 'js' | 'native_openssl' | null;
    static readonly libmongocryptVersion: string;
    constructor(options: MongoCryptOptions);
    makeEncryptionContext(ns: string, command: Uint8Array): MongoCryptContext;
    makeExplicitEncryptionContext(value: Uint8Array, options?: {
        keyId?: Uint8Array;
        keyAltName?: Uint8Array;
        algorithm?: string;
        rangeOptions?: Uint8Array;
        textOptions?: Uint8Array;
        contentionFactor?: bigint | number;
        queryType?: string;
        /**
         * node-binding specific option
         *
         * When true, creates a `mongocrypt_ctx_explicit_encrypt_expression` context.
         * When false, creates a `mongocrypt_ctx_explicit_encrypt`
         */
        expressionMode: boolean;
    }): MongoCryptContext;
    makeDecryptionContext(buffer: Uint8Array): MongoCryptContext;
    makeExplicitDecryptionContext(buffer: Uint8Array): MongoCryptContext;
    makeDataKeyContext(optionsBuffer: Uint8Array, options: {
        keyAltNames?: Uint8Array[];
        keyMaterial?: Uint8Array;
    }): MongoCryptContext;
    makeRewrapManyDataKeyContext(filter: Uint8Array, encryptionKey?: Uint8Array): MongoCryptContext;
    get status(): MongoCryptStatus;
}
export type { MongoCryptOptions, ExplicitEncryptionContextOptions, MongoCryptKMSRequest } from './bindings';
//# sourceMappingURL=index.d.ts.map