"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MongoCrypt = exports.MongoCryptContext = exports.cryptoCallbacks = void 0;
const bindings_1 = require("./bindings");
const crypto_callbacks_1 = require("./crypto_callbacks");
Object.defineProperty(exports, "cryptoCallbacks", { enumerable: true, get: function () { return crypto_callbacks_1.cryptoCallbacks; } });
class MongoCryptContext {
    context;
    errorWrapper;
    constructor(context, errorWrapper) {
        this.context = context;
        this.errorWrapper = errorWrapper;
    }
    nextMongoOperation() {
        try {
            return this.context.nextMongoOperation();
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    addMongoOperationResponse(response) {
        try {
            return this.context.addMongoOperationResponse(response);
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    finishMongoOperation() {
        try {
            return this.context.finishMongoOperation();
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    nextKMSRequest() {
        try {
            return this.context.nextKMSRequest();
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    provideKMSProviders(providers) {
        try {
            return this.context.provideKMSProviders(providers);
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    finishKMSRequests() {
        try {
            return this.context.finishKMSRequests();
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    finalize() {
        try {
            return this.context.finalize();
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    get status() {
        try {
            return this.context.status;
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    get state() {
        try {
            return this.context.state;
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
}
exports.MongoCryptContext = MongoCryptContext;
class MongoCrypt {
    errorWrapper;
    mc;
    cryptSharedLibVersionInfo;
    cryptoHooksProvider;
    static libmongocryptVersion = bindings_1.mc.MongoCrypt.libmongocryptVersion;
    constructor(options) {
        // Pass in JS cryptoCallbacks implementation by default.
        // If the Node.js openssl version is supported this will be ignored.
        this.mc = new bindings_1.mc.MongoCrypt({ cryptoCallbacks: crypto_callbacks_1.cryptoCallbacks, ...options });
        this.errorWrapper = options.errorWrapper;
        this.cryptSharedLibVersionInfo = this.mc.cryptSharedLibVersionInfo;
        this.cryptoHooksProvider = this.mc.cryptoHooksProvider;
    }
    makeEncryptionContext(ns, command) {
        try {
            return new MongoCryptContext(this.mc.makeEncryptionContext(ns, command), this.errorWrapper);
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    makeExplicitEncryptionContext(value, options) {
        try {
            return new MongoCryptContext(this.mc.makeExplicitEncryptionContext(value, options), this.errorWrapper);
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    makeDecryptionContext(buffer) {
        try {
            return new MongoCryptContext(this.mc.makeDecryptionContext(buffer), this.errorWrapper);
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    makeExplicitDecryptionContext(buffer) {
        try {
            return new MongoCryptContext(this.mc.makeExplicitDecryptionContext(buffer), this.errorWrapper);
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    makeDataKeyContext(optionsBuffer, options) {
        try {
            return new MongoCryptContext(this.mc.makeDataKeyContext(optionsBuffer, options), this.errorWrapper);
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    makeRewrapManyDataKeyContext(filter, encryptionKey) {
        try {
            return new MongoCryptContext(this.mc.makeRewrapManyDataKeyContext(filter, encryptionKey), this.errorWrapper);
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
    get status() {
        try {
            return this.mc.status;
        }
        catch (error) {
            throw this.errorWrapper(error);
        }
    }
}
exports.MongoCrypt = MongoCrypt;
//# sourceMappingURL=index.js.map