/*
 * Decompiled with CFR 0.152.
 */
package com.unciv;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.UndoHandler;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0007J\b\u0010\u000f\u001a\u00020\rH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u0018H\u0007J\u0006\u0010\u001a\u001a\u00020\u0005J\u0010\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001dR\u0012\u0010\u001e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0011\u0010 \u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/unciv/GUI;", "", "<init>", "()V", "setUpdateWorldOnNextRender", "", "pushScreen", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "resetToWorldScreen", "getSettings", "Lcom/unciv/models/metadata/GameSettings;", "isWorldLoaded", "", "isMyTurn", "isAllowedChangeState", "getWorldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getWorldScreenIfActive", "getMap", "Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "getUnitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "getViewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "getSelectedPlayer", "clearUndoCheckpoints", "openCivilopedia", "link", "", "keyboardAvailableCache", "Ljava/lang/Boolean;", "keyboardAvailable", "getKeyboardAvailable", "()Z", "core"})
public final class GUI {
    @NotNull
    public static final GUI INSTANCE = new GUI();
    @Nullable
    private static Boolean keyboardAvailableCache;

    private GUI() {
    }

    public final void setUpdateWorldOnNextRender() {
        block0: {
            WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
            if (worldScreen == null) break block0;
            worldScreen.setShouldUpdate(true);
        }
    }

    public final void pushScreen(@NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        UncivGame.Companion.getCurrent().pushScreen(screen);
    }

    public final void resetToWorldScreen() {
        UncivGame.Companion.getCurrent().resetToWorldScreen();
    }

    @Readonly
    @NotNull
    public final GameSettings getSettings() {
        return UncivGame.Companion.getCurrent().getSettings();
    }

    @Readonly
    public final boolean isWorldLoaded() {
        return UncivGame.Companion.getCurrent().getWorldScreen() != null;
    }

    @Readonly
    public final boolean isMyTurn() {
        if (!UncivGame.Companion.isCurrentInitialized() || !this.isWorldLoaded()) {
            return false;
        }
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.isPlayersTurn();
    }

    @Readonly
    public final boolean isAllowedChangeState() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getCanChangeState();
    }

    @Readonly
    @NotNull
    public final WorldScreen getWorldScreen() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen;
    }

    @Readonly
    @Nullable
    public final WorldScreen getWorldScreenIfActive() {
        return UncivGame.Companion.getCurrent().getWorldScreenIfActive();
    }

    @Readonly
    @NotNull
    public final WorldMapHolder getMap() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getMapHolder();
    }

    @Readonly
    @NotNull
    public final UnitTable getUnitTable() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getBottomUnitTable$core();
    }

    @Readonly
    @NotNull
    public final Civilization getViewingPlayer() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getViewingCiv();
    }

    @Readonly
    @NotNull
    public final Civilization getSelectedPlayer() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getSelectedCiv();
    }

    public final void clearUndoCheckpoints() {
        block0: {
            WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
            if (worldScreen == null) break block0;
            UndoHandler.Companion.clearUndoCheckpoints(worldScreen);
        }
    }

    public final void openCivilopedia(@NotNull String link) {
        block0: {
            Intrinsics.checkNotNullParameter(link, "link");
            BaseScreen baseScreen = UncivGame.Companion.getCurrent().getScreen();
            if (baseScreen == null) break block0;
            baseScreen.openCivilopedia(link);
        }
    }

    public static /* synthetic */ void openCivilopedia$default(GUI gUI, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        gUI.openCivilopedia(string);
    }

    public final boolean getKeyboardAvailable() {
        if (keyboardAvailableCache == null && Gdx.input != null) {
            keyboardAvailableCache = Gdx.input.isPeripheralAvailable(Input.Peripheral.HardwareKeyboard);
        }
        Boolean bl = keyboardAvailableCache;
        return bl != null ? bl : false;
    }
}

