/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.ReligionAction;
import com.unciv.logic.civilization.managers.ReligionState;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionModifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010(\u001a\u00020'J\u000e\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u000bJ\u0010\u0010+\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001cH\u0007J\b\u0010.\u001a\u00020$H\u0007J\b\u0010/\u001a\u00020$H\u0007J\u0012\u00100\u001a\u00020\u000b2\b\b\u0002\u00101\u001a\u00020\u000bH\u0007J\b\u00102\u001a\u00020$H\u0007J\u0018\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020$H\u0002J\b\u00106\u001a\u00020\u000bH\u0007J\b\u00107\u001a\u00020\u000bH\u0007J\u0012\u00108\u001a\u00020$2\b\b\u0002\u00109\u001a\u00020$H\u0007J\n\u0010:\u001a\u0004\u0018\u00010;H\u0007J\b\u0010<\u001a\u00020'H\u0002J\b\u0010=\u001a\u00020\u000bH\u0003J\b\u0010>\u001a\u00020\u000bH\u0003J\b\u0010?\u001a\u00020\u000bH\u0007J\u001a\u0010@\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000b0B0AH\u0007J\u0010\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020-H\u0007J\u0012\u0010E\u001a\u0004\u0018\u00010\u00112\u0006\u0010F\u001a\u00020GH\u0007J\b\u0010H\u001a\u00020$H\u0007J\u0010\u0010I\u001a\u00020$2\u0006\u0010J\u001a\u00020KH\u0007J\u000e\u0010L\u001a\u00020'2\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020$H\u0007J\u0010\u0010P\u001a\u00020$2\u0006\u0010J\u001a\u00020KH\u0007J\u000e\u0010Q\u001a\u00020'2\u0006\u0010M\u001a\u00020NJ\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020-0\u001c2\u0006\u0010S\u001a\u00020$H\u0003J\u000e\u0010T\u001a\b\u0012\u0004\u0012\u00020-0\u001cH\u0007J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020-0\u001cH\u0007J\u001e\u0010V\u001a\u00020'2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020G0X2\b\b\u0002\u0010Y\u001a\u00020$J\u001d\u0010L\u001a\u00020'2\u0006\u0010Z\u001a\u00020\u001d2\u0006\u0010[\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\\J\u0010\u0010]\u001a\u00020$2\u0006\u0010^\u001a\u00020NH\u0007J\u0010\u0010_\u001a\u00020$2\u0006\u0010^\u001a\u00020NH\u0007J\b\u0010`\u001a\u00020\u000bH\u0007J\u0010\u0010a\u001a\u00020\u000b2\u0006\u0010b\u001a\u00020\u001dH\u0007J\n\u0010c\u001a\u0004\u0018\u00010dH\u0007J\n\u0010e\u001a\u0004\u0018\u00010\u0011H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/unciv/logic/civilization/managers/ReligionManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "storedFaith", "", "getStoredFaith", "()I", "setStoredFaith", "(I)V", "religion", "Lcom/unciv/models/Religion;", "getReligion", "()Lcom/unciv/models/Religion;", "setReligion", "(Lcom/unciv/models/Religion;)V", "value", "Lcom/unciv/logic/civilization/managers/ReligionState;", "religionState", "getReligionState", "()Lcom/unciv/logic/civilization/managers/ReligionState;", "freeBeliefs", "Lcom/unciv/models/Counter;", "", "getFreeBeliefs", "()Lcom/unciv/models/Counter;", "setFreeBeliefs", "(Lcom/unciv/models/Counter;)V", "foundingCityId", "shouldChoosePantheonBelief", "", "clone", "setTransients", "", "startTurn", "endTurn", "faithFromNewTurn", "isMajorityReligionForCiv", "freeBeliefsAsEnums", "Lcom/unciv/models/ruleset/BeliefType;", "hasFreeBeliefs", "usingFreeBeliefs", "faithForPantheon", "additionalCivs", "canFoundOrExpandPantheon", "foundPantheon", "beliefName", "useFreeBelief", "greatProphetsEarned", "faithForNextGreatProphet", "canGenerateProphet", "ignoreFaithAmount", "getGreatProphetEquivalent", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "generateProphet", "maxNumberOfReligions", "foundedReligionsCount", "remainingFoundableReligions", "remainingFoundableReligionsBreakdown", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "numberOfBeliefsAvailable", "type", "getReligionWithBelief", "belief", "Lcom/unciv/models/ruleset/Belief;", "mayFoundReligionAtAll", "mayFoundReligionHere", "tile", "Lcom/unciv/logic/map/tile/Tile;", "foundReligion", "prophet", "Lcom/unciv/logic/map/mapunit/MapUnit;", "mayEnhanceReligionAtAll", "mayEnhanceReligionHere", "useProphetForEnhancingReligion", "getBeliefsToChooseAtProphetUse", "enhancingReligion", "getBeliefsToChooseAtFounding", "getBeliefsToChooseAtEnhancing", "chooseBeliefs", "beliefs", "", "useFreeBeliefs", "displayName", "name", "foundReligion$core", "maySpreadReligionAtAll", "missionary", "maySpreadReligionNow", "numberOfCitiesFollowingThisReligion", "numberOfFollowersFollowingThisReligion", "cityFilter", "getHolyCity", "Lcom/unciv/logic/city/City;", "getMajorityReligion", "core"})
@SourceDebugExtension(value={"SMAP\nReligionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReligionManager.kt\ncom/unciv/logic/civilization/managers/ReligionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,584:1\n296#2,2:585\n296#2,2:587\n1834#2,4:589\n1834#2,4:593\n1807#2,3:597\n1834#2,4:600\n777#2:604\n873#2,2:605\n296#2,2:607\n1834#2,4:609\n1834#2,4:613\n1834#2,4:617\n296#2,2:627\n777#2:629\n873#2,2:630\n1807#2,3:632\n231#2,2:636\n777#2:638\n873#2,2:639\n91#3:621\n115#3,5:622\n1#4:635\n1297#5,3:641\n184#5,2:644\n*S KotlinDebug\n*F\n+ 1 ReligionManager.kt\ncom/unciv/logic/civilization/managers/ReligionManager\n*L\n73#1:585,2\n78#1:587,2\n93#1:589,4\n119#1:593,4\n133#1:597,3\n134#1:600,4\n152#1:604\n152#1:605,2\n196#1:607,2\n226#1:609,4\n232#1:613,4\n283#1:617,4\n290#1:627,2\n350#1:629\n350#1:630,2\n452#1:632,3\n477#1:636,2\n488#1:638\n488#1:639,2\n284#1:621\n284#1:622,5\n528#1:641,3\n542#1:644,2\n*E\n"})
public final class ReligionManager
implements IsPartOfGameInfoSerialization {
    public transient Civilization civInfo;
    private int storedFaith;
    @Nullable
    private transient Religion religion;
    @NotNull
    private ReligionState religionState = ReligionState.None;
    @NotNull
    private Counter<String> freeBeliefs = new Counter(null, 1, null);
    @Nullable
    private String foundingCityId;
    private boolean shouldChoosePantheonBelief;

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    public final int getStoredFaith() {
        return this.storedFaith;
    }

    public final void setStoredFaith(int n) {
        this.storedFaith = n;
    }

    @Nullable
    public final Religion getReligion() {
        return this.religion;
    }

    public final void setReligion(@Nullable Religion religion) {
        this.religion = religion;
    }

    @NotNull
    public final ReligionState getReligionState() {
        return this.religionState;
    }

    @NotNull
    public final Counter<String> getFreeBeliefs() {
        return this.freeBeliefs;
    }

    public final void setFreeBeliefs(@NotNull Counter<String> counter) {
        Intrinsics.checkNotNullParameter(counter, "<set-?>");
        this.freeBeliefs = counter;
    }

    @NotNull
    public final ReligionManager clone() {
        ReligionManager clone = new ReligionManager();
        clone.foundingCityId = this.foundingCityId;
        clone.shouldChoosePantheonBelief = this.shouldChoosePantheonBelief;
        clone.storedFaith = this.storedFaith;
        clone.religionState = this.religionState;
        clone.freeBeliefs.putAll((Map)this.freeBeliefs);
        return clone;
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Object v3;
        block4: {
            Object v1;
            Religion it;
            Iterable $this$firstOrNull$iv;
            boolean $i$f$firstOrNull;
            ReligionManager religionManager;
            block3: {
                Intrinsics.checkNotNullParameter(civInfo, "civInfo");
                this.setCivInfo(civInfo);
                Collection<Religion> collection = civInfo.getGameInfo().getReligions().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                Iterable iterable = collection;
                religionManager = this;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (Religion)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getFoundingCiv(), civInfo) && it.isMajorReligion())) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            religionManager.religion = v1;
            if (this.religion != null) {
                return;
            }
            Collection<Religion> collection = civInfo.getGameInfo().getReligions().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            $this$firstOrNull$iv = collection;
            religionManager = this;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Religion)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getFoundingCiv(), civInfo)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        religionManager.religion = v3;
    }

    public final void startTurn() {
        if (ReligionManager.canGenerateProphet$default(this, false, 1, null)) {
            this.generateProphet();
        }
    }

    public final void endTurn(int faithFromNewTurn) {
        this.storedFaith += faithFromNewTurn;
    }

    @Readonly
    public final boolean isMajorityReligionForCiv(@NotNull Religion religion) {
        int n;
        Intrinsics.checkNotNullParameter(religion, "religion");
        Iterable $this$count$iv = this.getCivInfo().getCities();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                City it = (City)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getReligion().getMajorityReligion(), religion) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > this.getCivInfo().getCities().size() / 2;
    }

    @Readonly
    @NotNull
    public final Counter<BeliefType> freeBeliefsAsEnums() {
        Counter<BeliefType> toReturn = new Counter<BeliefType>(null, 1, null);
        for (Map.Entry<String, Integer> entry : this.freeBeliefs.entrySet()) {
            String string = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(string, "<get-key>(...)");
            BeliefType beliefType = BeliefType.valueOf(string);
            Integer n = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(n, "<get-value>(...)");
            toReturn.add(beliefType, ((Number)n).intValue());
        }
        return toReturn;
    }

    @Readonly
    public final boolean hasFreeBeliefs() {
        return this.freeBeliefs.sumValues() > 0;
    }

    @Readonly
    public final boolean usingFreeBeliefs() {
        return this.religionState == ReligionState.None && this.storedFaith < ReligionManager.faithForPantheon$default(this, 0, 1, null) || this.religionState == ReligionState.Pantheon || this.religionState == ReligionState.Religion || this.religionState == ReligionState.EnhancedReligion;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int faithForPantheon(int additionalCivs) {
        int n;
        void $this$count$iv;
        GameInfo gameInfo = this.getCivInfo().getGameInfo();
        Iterable iterable = gameInfo.getCivilizations();
        int n2 = additionalCivs;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!(it.isMajorCiv() && it.getReligionManager().religion != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        int numCivs = n2 + n3;
        int cost = gameInfo.getRuleset().getModOptions().getConstants().getPantheonBase() + numCivs * gameInfo.getRuleset().getModOptions().getConstants().getPantheonGrowth();
        return MathKt.roundToInt((float)cost * gameInfo.getSpeed().getFaithCostModifier());
    }

    public static /* synthetic */ int faithForPantheon$default(ReligionManager religionManager, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return religionManager.faithForPantheon(n);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final boolean canFoundOrExpandPantheon() {
        boolean bl;
        block12: {
            if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
                return false;
            }
            if (this.religionState.compareTo((Enum)ReligionState.Pantheon) > 0) {
                return false;
            }
            if (!this.getCivInfo().isMajorCiv()) {
                return false;
            }
            if (this.numberOfBeliefsAvailable(BeliefType.Pantheon) == 0) {
                return false;
            }
            Iterable $this$any$iv = this.getCivInfo().getGameInfo().getCivilizations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl2 = false;
                    if (!(it.getReligionManager().religionState == ReligionState.EnhancedReligion)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            int n;
            Iterable $this$count$iv = this.getCivInfo().getGameInfo().getCivilizations();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var3_4;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl3 = false;
                    if (!(it.getReligionManager().religionState.compareTo((Enum)ReligionState.Pantheon) >= 0) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var3_4;
            }
            if (n >= this.maxNumberOfReligions()) {
                return false;
            }
        }
        return this.religionState == ReligionState.None && this.storedFaith >= ReligionManager.faithForPantheon$default(this, 0, 1, null) || ((Number)this.freeBeliefs.get("Pantheon")).intValue() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final void foundPantheon(String beliefName, boolean useFreeBelief) {
        void $this$filterTo$iv$iv;
        if (!useFreeBelief) {
            this.storedFaith -= ReligionManager.faithForPantheon$default(this, 0, 1, null);
        }
        this.religion = new Religion(beliefName, this.getCivInfo().getGameInfo(), this.getCivInfo());
        Map map2 = this.getCivInfo().getGameInfo().getReligions();
        Religion religion = this.religion;
        Intrinsics.checkNotNull(religion);
        map2.put(beliefName, religion);
        for (City city : this.getCivInfo().getCities()) {
            CityReligionManager.addPressure$default(city.getReligion(), beliefName, 200 * city.getPopulation().getPopulation(), false, 4, null);
        }
        Iterable $this$filter$iv = this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isHuman() && !Intrinsics.areEqual(it, this.getCivInfo()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List humanPlayers = (List)destination$iv$iv;
        for (Civilization civ : humanPlayers) {
            String text2 = SequencesKt.contains(civ.getKnownCivs(), this.getCivInfo()) ? '[' + this.getCivInfo().getCivName() + ']' : "[An unknown civilization]";
            String[] stringArray = new String[]{"StatIcons/Faith"};
            civ.addNotification(text2 + " has founded pantheon [" + beliefName + "]!", new ReligionAction(beliefName), Notification.NotificationCategory.Religion, stringArray);
        }
    }

    @Readonly
    public final int greatProphetsEarned() {
        Counter<String> counter = this.getCivInfo().getCivConstructions().getBoughtItemsWithIncreasingPrice();
        Object object = this.getGreatProphetEquivalent();
        if (object == null || (object = ((RulesetObject)object).getName()) == null) {
            object = "";
        }
        return ((Number)counter.get(object)).intValue();
    }

    @Readonly
    public final int faithForNextGreatProphet() {
        int greatProphetsEarned = this.greatProphetsEarned();
        float faithCost = ((float)200 + (float)(100 * greatProphetsEarned * (greatProphetsEarned + 1)) / 2.0f) * this.getCivInfo().getGameInfo().getSpeed().getFaithCostModifier();
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.FaithCostOfGreatProphetChange, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            faithCost *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return (int)faithCost;
    }

    @Readonly
    public final boolean canGenerateProphet(boolean ignoreFaithAmount) {
        if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
            return false;
        }
        if (this.religion == null || this.religionState == ReligionState.None) {
            return false;
        }
        if (this.getGreatProphetEquivalent() == null) {
            return false;
        }
        if (!ignoreFaithAmount && this.storedFaith < this.faithForNextGreatProphet()) {
            return false;
        }
        if (!this.getCivInfo().isMajorCiv()) {
            return false;
        }
        if (Civilization.hasUnique$default(this.getCivInfo(), UniqueType.MayNotGenerateGreatProphet, null, 2, null)) {
            return false;
        }
        return this.religionState != ReligionState.Pantheon || this.remainingFoundableReligions() != 0;
    }

    public static /* synthetic */ boolean canGenerateProphet$default(ReligionManager religionManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return religionManager.canGenerateProphet(bl);
    }

    @Readonly
    @Nullable
    public final BaseUnit getGreatProphetEquivalent() {
        Object v1;
        block1: {
            Collection<BaseUnit> collection = this.getCivInfo().getGameInfo().getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BaseUnit it = (BaseUnit)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.hasUnique$default(it, UniqueType.MayFoundReligion, null, 2, null)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        BaseUnit baseUnit = v1;
        return baseUnit == null ? null : this.getCivInfo().getEquivalentUnit(baseUnit);
    }

    private final void generateProphet() {
        BaseUnit baseUnit = this.getGreatProphetEquivalent();
        if (baseUnit == null) {
            return;
        }
        BaseUnit prophetUnit = baseUnit;
        float prophetSpawnChange = (5.0f + (float)this.storedFaith - (float)this.faithForNextGreatProphet()) / 100.0f;
        if (RandomKt.Random(this.getCivInfo().getGameInfo().getTurns()).nextFloat() < prophetSpawnChange) {
            City holyCity;
            City birthCity = this.religionState.compareTo((Enum)ReligionState.Pantheon) <= 0 ? Civilization.getCapital$default(this.getCivInfo(), false, 1, null) : ((holyCity = this.getCivInfo().getReligionManager().getHolyCity()) != null && Intrinsics.areEqual(holyCity.getCiv(), this.getCivInfo()) ? holyCity : Civilization.getCapital$default(this.getCivInfo(), false, 1, null));
            MapUnit mapUnit = this.getCivInfo().getUnits().addUnit(prophetUnit, birthCity);
            if (mapUnit == null) {
                return;
            }
            MapUnit prophet = mapUnit;
            Religion religion = this.religion;
            Intrinsics.checkNotNull(religion);
            prophet.setReligion(religion.getName());
            this.storedFaith -= this.faithForNextGreatProphet();
            this.getCivInfo().getCivConstructions().getBoughtItemsWithIncreasingPrice().add(prophetUnit.getName(), 1);
        }
    }

    @Readonly
    private final int maxNumberOfReligions() {
        int n;
        GameInfo gameInfo = this.getCivInfo().getGameInfo();
        Ruleset ruleset = gameInfo.getRuleset();
        float multiplier = ruleset.getModOptions().getConstants().getReligionLimitMultiplier();
        int base = ruleset.getModOptions().getConstants().getReligionLimitBase();
        Iterable $this$count$iv = gameInfo.getCivilizations();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int civCount = n;
        return Integer.min(ruleset.getReligions().size(), base + (int)((float)civCount * multiplier));
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final int foundedReligionsCount() {
        int n;
        Iterable $this$count$iv = this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!(it.getReligionManager().religion != null && it.getReligionManager().religionState.compareTo((Enum)ReligionState.Religion) >= 0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    @Readonly
    public final int remainingFoundableReligions() {
        int maxNumberOfAdditionalReligions = this.maxNumberOfReligions() - this.foundedReligionsCount();
        int availableBeliefsToFound = Integer.min(this.numberOfBeliefsAvailable(BeliefType.Follower), this.numberOfBeliefsAvailable(BeliefType.Founder));
        return Integer.min(maxNumberOfAdditionalReligions, availableBeliefsToFound);
    }

    @Readonly
    @NotNull
    public final Sequence<Pair<String, Integer>> remainingFoundableReligionsBreakdown() {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Pair<? extends String, ? extends Integer>>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            float F$0;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            boolean Z$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ReligionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var19_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        gameInfo = this.this$0.getCivInfo().getGameInfo();
                        ruleset = gameInfo.getRuleset();
                        this.L$0 = $this$sequence;
                        this.L$1 = gameInfo;
                        this.L$2 = ruleset;
                        this.label = 1;
                        v0 = $this$sequence.yield(TuplesKt.to("Available religion symbols", Boxing.boxInt(ruleset.getReligions().size())), this);
                        if (v0 == var19_3) {
                            return var19_3;
                        }
                        ** GOTO lbl21
                    }
                    case 1: {
                        ruleset = (Ruleset)this.L$2;
                        gameInfo = (GameInfo)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl21:
                        // 2 sources

                        multiplier = ruleset.getModOptions().getConstants().getReligionLimitMultiplier();
                        base = ruleset.getModOptions().getConstants().getReligionLimitBase();
                        $this$count$iv = gameInfo.getCivilizations();
                        $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            v1 = 0;
                        } else {
                            count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                it = (Civilization)element$iv;
                                $i$a$-count-ReligionManager$remainingFoundableReligionsBreakdown$1$civCount$1 = false;
                                if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            v1 = count$iv;
                        }
                        civCount = v1;
                        hideCivCount = this.this$0.getCivInfo().shouldHideCivCount();
                        if (!hideCivCount) break;
                        count$iv = this.this$0.getCivInfo().getKnownCivs();
                        var17_32 = 1;
                        $i$f$count = false;
                        count$iv = 0;
                        for (T element$iv : $this$count$iv) {
                            it = (Civilization)element$iv;
                            $i$a$-count-ReligionManager$remainingFoundableReligionsBreakdown$1$knownCivs$1 = false;
                            if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        var18_35 = count$iv;
                        knownCivs = var17_32 + var18_35;
                        estimatedCivCount = (RangesKt.coerceAtLeast(gameInfo.getGameParameters().getMinNumberOfPlayers(), knownCivs) + gameInfo.getGameParameters().getMaxNumberOfPlayers() - 1) / 2 + 1;
                        civsAndBase = base + (int)((float)estimatedCivCount * multiplier);
                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable(gameInfo);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(ruleset);
                        this.F$0 = multiplier;
                        this.I$0 = base;
                        this.I$1 = civCount;
                        this.Z$0 = hideCivCount;
                        this.I$2 = knownCivs;
                        this.I$3 = estimatedCivCount;
                        this.I$4 = civsAndBase;
                        this.label = 2;
                        v2 = $this$sequence.yield(TuplesKt.to("Estimated number of civilizations * [" + multiplier + "] + [" + base + ']', Boxing.boxInt(civsAndBase)), this);
                        if (v2 == var19_3) {
                            return var19_3;
                        }
                        ** GOTO lbl105
                    }
                    case 2: {
                        civsAndBase = this.I$4;
                        estimatedCivCount = this.I$3;
                        knownCivs = this.I$2;
                        hideCivCount = this.Z$0;
                        civCount = this.I$1;
                        base = this.I$0;
                        multiplier = this.F$0;
                        ruleset = (Ruleset)this.L$2;
                        gameInfo = (GameInfo)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
                        ** GOTO lbl105
                    }
                }
                civsAndBase = base + (int)((float)civCount * multiplier);
                this.L$0 = $this$sequence;
                this.L$1 = SpillingKt.nullOutSpilledVariable(gameInfo);
                this.L$2 = SpillingKt.nullOutSpilledVariable(ruleset);
                this.F$0 = multiplier;
                this.I$0 = base;
                this.I$1 = civCount;
                this.Z$0 = hideCivCount;
                this.I$2 = civsAndBase;
                this.label = 3;
                v3 = $this$sequence.yield(TuplesKt.to("Number of civilizations * [" + multiplier + "] + [" + base + ']', Boxing.boxInt(civsAndBase)), this);
                if (v3 == var19_3) {
                    return var19_3;
                }
                ** GOTO lbl105
                {
                    case 3: {
                        civsAndBase = this.I$2;
                        hideCivCount = this.Z$0;
                        civCount = this.I$1;
                        base = this.I$0;
                        multiplier = this.F$0;
                        ruleset = (Ruleset)this.L$2;
                        gameInfo = (GameInfo)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl105:
                        // 4 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable(gameInfo);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(ruleset);
                        this.F$0 = multiplier;
                        this.I$0 = base;
                        this.I$1 = civCount;
                        this.Z$0 = hideCivCount;
                        this.label = 4;
                        v4 = $this$sequence.yield(TuplesKt.to("Religions already founded", Boxing.boxInt(ReligionManager.access$foundedReligionsCount(this.this$0))), this);
                        if (v4 == var19_3) {
                            return var19_3;
                        }
                        ** GOTO lbl126
                    }
                    case 4: {
                        hideCivCount = this.Z$0;
                        civCount = this.I$1;
                        base = this.I$0;
                        multiplier = this.F$0;
                        ruleset = (Ruleset)this.L$2;
                        gameInfo = (GameInfo)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl126:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable(gameInfo);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(ruleset);
                        this.F$0 = multiplier;
                        this.I$0 = base;
                        this.I$1 = civCount;
                        this.Z$0 = hideCivCount;
                        this.label = 5;
                        v5 = $this$sequence.yield(TuplesKt.to("Available founder beliefs", Boxing.boxInt(this.this$0.numberOfBeliefsAvailable(BeliefType.Founder))), this);
                        if (v5 == var19_3) {
                            return var19_3;
                        }
                        ** GOTO lbl147
                    }
                    case 5: {
                        hideCivCount = this.Z$0;
                        civCount = this.I$1;
                        base = this.I$0;
                        multiplier = this.F$0;
                        ruleset = (Ruleset)this.L$2;
                        gameInfo = (GameInfo)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl147:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(gameInfo);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(ruleset);
                        this.F$0 = multiplier;
                        this.I$0 = base;
                        this.I$1 = civCount;
                        this.Z$0 = hideCivCount;
                        this.label = 6;
                        v6 = $this$sequence.yield(TuplesKt.to("Available follower beliefs", Boxing.boxInt(this.this$0.numberOfBeliefsAvailable(BeliefType.Follower))), this);
                        if (v6 == var19_3) {
                            return var19_3;
                        }
                        ** GOTO lbl168
                    }
                    case 6: {
                        hideCivCount = this.Z$0;
                        civCount = this.I$1;
                        base = this.I$0;
                        multiplier = this.F$0;
                        ruleset = (Ruleset)this.L$2;
                        gameInfo = (GameInfo)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
lbl168:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Pair<? extends String, ? extends Integer>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Pair<String, Integer>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int numberOfBeliefsAvailable(@NotNull BeliefType type) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object $this$count$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)type, "type");
        GameInfo gameInfo = this.getCivInfo().getGameInfo();
        if (type == BeliefType.Any) {
            Collection<Belief> collection = gameInfo.getRuleset().getBeliefs().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            n = collection.size();
        } else {
            Collection<Belief> collection = gameInfo.getRuleset().getBeliefs().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            $this$count$iv = collection;
            boolean $i$f$count = false;
            if (((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    Belief it = (Belief)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == type) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        }
        int numberOfBeliefs = n;
        $this$count$iv = gameInfo.getReligions();
        int n2 = numberOfBeliefs;
        boolean $i$f$flatMapSequence = false;
        void count$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        Iterator iterator3 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl = false;
            Sequence<Belief> list$iv$iv = ((Religion)it.getValue()).getBeliefs(type);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return n2 - ((Collection)CollectionsKt.distinct(list2)).size();
    }

    @Readonly
    @Nullable
    public final Religion getReligionWithBelief(@NotNull Belief belief) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter(belief, "belief");
            Collection<Religion> collection = this.getCivInfo().getGameInfo().getReligions().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Religion it = (Religion)element$iv;
                boolean bl = false;
                if (!it.hasBelief(belief.getName())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Readonly
    public final boolean mayFoundReligionAtAll() {
        if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
            return false;
        }
        if (this.religionState.compareTo((Enum)ReligionState.Religion) >= 0) {
            return false;
        }
        if (!this.getCivInfo().isMajorCiv()) {
            return false;
        }
        return this.remainingFoundableReligions() != 0;
    }

    @Readonly
    public final boolean mayFoundReligionHere(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!this.mayFoundReligionAtAll()) {
            return false;
        }
        if (!tile.isCityCenter()) {
            return false;
        }
        City city = tile.getCity();
        Intrinsics.checkNotNull(city);
        return !city.isHolyCity();
    }

    public final void foundReligion(@NotNull MapUnit prophet) {
        Intrinsics.checkNotNullParameter(prophet, "prophet");
        if (!this.mayFoundReligionHere(prophet.getTile())) {
            return;
        }
        if (this.religionState == ReligionState.None) {
            this.shouldChoosePantheonBelief = true;
        }
        this.religionState = ReligionState.FoundingReligion;
        ReligionManager religionManager = this.getCivInfo().getReligionManager();
        City city = prophet.getTile().getCity();
        Intrinsics.checkNotNull(city);
        religionManager.foundingCityId = city.getId();
    }

    @Readonly
    public final boolean mayEnhanceReligionAtAll() {
        if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
            return false;
        }
        if (this.religion == null) {
            return false;
        }
        if (this.religionState != ReligionState.Religion) {
            return false;
        }
        if (!this.getCivInfo().isMajorCiv()) {
            return false;
        }
        if (this.numberOfBeliefsAvailable(BeliefType.Follower) == 0) {
            return false;
        }
        return this.numberOfBeliefsAvailable(BeliefType.Enhancer) != 0;
    }

    @Readonly
    public final boolean mayEnhanceReligionHere(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!this.mayEnhanceReligionAtAll()) {
            return false;
        }
        return tile.isCityCenter();
    }

    /*
     * WARNING - void declaration
     */
    public final void useProphetForEnhancingReligion(@NotNull MapUnit prophet) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(prophet, "prophet");
        Tile currentTile = prophet.getTile();
        if (!this.mayEnhanceReligionHere(currentTile)) {
            return;
        }
        this.religionState = ReligionState.EnhancingReligion;
        Iterable $this$filter$iv = this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isHuman() && !Intrinsics.areEqual(it, this.getCivInfo()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List humanPlayers = (List)destination$iv$iv;
        Religion religion = this.getCivInfo().getReligionManager().religion;
        Intrinsics.checkNotNull(religion);
        Religion religion2 = religion;
        for (Civilization civ : humanPlayers) {
            String text2 = SequencesKt.contains(civ.getKnownCivs(), this.getCivInfo()) ? '[' + this.getCivInfo().getCivName() + ']' : "[An unknown civilization]";
            String[] stringArray = new String[]{"StatIcons/Faith"};
            civ.addNotification(text2 + " has enhanced [" + religion2.getDisplayName() + "]!", new ReligionAction(religion2.getDisplayName()), Notification.NotificationCategory.Religion, stringArray);
        }
    }

    @Readonly
    private final Counter<BeliefType> getBeliefsToChooseAtProphetUse(boolean enhancingReligion) {
        String action2 = enhancingReligion ? "enhancing" : "founding";
        Counter<BeliefType> beliefsToChoose = new Counter<BeliefType>(null, 1, null);
        Counter<BeliefType> availableBeliefs = new Counter<BeliefType>(null, 1, null);
        for (BeliefType beliefType : BeliefType.getEntries()) {
            if (beliefType == BeliefType.None) continue;
            ((Map)availableBeliefs).put(beliefType, this.numberOfBeliefsAvailable(beliefType));
        }
        if (enhancingReligion) {
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Enhancer, 1);
        } else {
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Founder, 1);
            if (this.shouldChoosePantheonBelief) {
                ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Pantheon, 1);
            }
        }
        ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Follower, 1);
        Iterator<Object> iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.FreeExtraBeliefs, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!Intrinsics.areEqual(unique.getParams().get(2), action2)) continue;
            BeliefType type = BeliefType.valueOf(unique.getParams().get(1));
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, type, Integer.parseInt(unique.getParams().get(0)));
        }
        iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.FreeExtraAnyBeliefs, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!Intrinsics.areEqual(unique.getParams().get(1), action2)) continue;
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Any, Integer.parseInt(unique.getParams().get(0)));
        }
        for (Map.Entry entry : ((Map)this.freeBeliefsAsEnums()).entrySet()) {
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, (BeliefType)((Object)entry.getKey()), ((Number)entry.getValue()).intValue());
        }
        return beliefsToChoose;
    }

    @Readonly
    @NotNull
    public final Counter<BeliefType> getBeliefsToChooseAtFounding() {
        return this.getBeliefsToChooseAtProphetUse(false);
    }

    @Readonly
    @NotNull
    public final Counter<BeliefType> getBeliefsToChooseAtEnhancing() {
        return this.getBeliefsToChooseAtProphetUse(true);
    }

    public final void chooseBeliefs(@NotNull List<Belief> beliefs, boolean useFreeBeliefs) {
        Intrinsics.checkNotNullParameter(beliefs, "beliefs");
        this.freeBeliefs.clear();
        if (this.religionState == ReligionState.None) {
            this.foundPantheon(beliefs.get(0).getName(), useFreeBeliefs);
        }
        Religion religion = this.religion;
        Intrinsics.checkNotNull(religion);
        religion.addBeliefs((Iterable<Belief>)beliefs);
        switch (WhenMappings.$EnumSwitchMapping$0[this.religionState.ordinal()]) {
            case 1: {
                Unique unique;
                this.religionState = ReligionState.Pantheon;
                Iterator<Object> iterator2 = Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponFoundingPantheon, null, null, 6, null).iterator();
                while (iterator2.hasNext()) {
                    unique = (Unique)iterator2.next();
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
                }
                break;
            }
            case 2: {
                Unique unique;
                this.religionState = ReligionState.Religion;
                Iterator<Object> iterator2 = Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponFoundingReligion, null, null, 6, null).iterator();
                while (iterator2.hasNext()) {
                    unique = (Unique)iterator2.next();
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
                }
                break;
            }
            case 3: {
                Unique unique;
                this.religionState = ReligionState.EnhancedReligion;
                Iterator<Object> iterator2 = Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponEnhancingReligion, null, null, 6, null).iterator();
                while (iterator2.hasNext()) {
                    unique = (Unique)iterator2.next();
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
                }
                break;
            }
        }
        Iterator<Object> iterator3 = Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponAdoptingPolicyOrBelief, null, null, 6, null).iterator();
        while (iterator3.hasNext()) {
            Unique unique = (Unique)iterator3.next();
            for (Object object : beliefs) {
                boolean bl;
                Belief belief;
                block17: {
                    Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                    belief = (Belief)object;
                    Iterable $this$any$iv = unique.getModifiers(UniqueType.TriggerUponAdoptingPolicyOrBelief);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Unique it = (Unique)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getParams().get(0), belief.getName())) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, "due to adopting [" + belief.getName() + ']', 60, null);
            }
        }
        for (Object object : beliefs) {
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Belief belief = (Belief)object;
            for (Unique unique : belief.getUniqueObjects()) {
                if (unique.hasTriggerConditional() || !unique.conditionalsApply(this.getCivInfo().getState())) continue;
                int n = unique.getUniqueMultiplier(this.getCivInfo().getState());
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
                }
            }
        }
        this.getCivInfo().updateStatsForNextTurn();
    }

    public static /* synthetic */ void chooseBeliefs$default(ReligionManager religionManager, List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        religionManager.chooseBeliefs(list2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void foundReligion$core(@NotNull String displayName, @NotNull String name) {
        void $this$filterTo$iv$iv;
        Object element$iv;
        Object $this$first$iv;
        Religion newReligion;
        block7: {
            Intrinsics.checkNotNullParameter(displayName, "displayName");
            Intrinsics.checkNotNullParameter(name, "name");
            newReligion = new Religion(name, this.getCivInfo().getGameInfo(), this.getCivInfo());
            newReligion.setDisplayName(displayName);
            if (this.religion != null) {
                Religion religion = this.religion;
                Intrinsics.checkNotNull(religion);
                newReligion.addBeliefs(SequencesKt.asIterable(religion.getAllBeliefsOrdered()));
            }
            this.religion = newReligion;
            ((Map)this.getCivInfo().getGameInfo().getReligions()).put(name, newReligion);
            $this$first$iv = this.getCivInfo().getCities();
            boolean $i$f$first = false;
            Iterator iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                City it = (City)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), this.foundingCityId)) continue;
                break block7;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        City holyCity = (City)element$iv;
        holyCity.getReligion().setReligionThisIsTheHolyCityOf(newReligion.getName());
        CityReligionManager.addPressure$default(holyCity.getReligion(), name, holyCity.getPopulation().getPopulation() * 500, false, 4, null);
        this.foundingCityId = null;
        this.shouldChoosePantheonBelief = false;
        $this$first$iv = this.getCivInfo().getUnits().getCivUnits().iterator();
        while ($this$first$iv.hasNext()) {
            MapUnit unit = (MapUnit)$this$first$iv.next();
            if (!MapUnit.hasUnique$default(unit, UniqueType.ReligiousUnit, null, false, 6, null) || !MapUnit.hasUnique$default(unit, UniqueType.TakeReligionOverBirthCity, null, false, 6, null)) continue;
            unit.setReligion(newReligion.getName());
        }
        Iterable $this$filter$iv = this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isHuman() && !Intrinsics.areEqual(it, this.getCivInfo()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List humanPlayers = (List)destination$iv$iv;
        for (Civilization civ : humanPlayers) {
            String[] stringArray;
            if (SequencesKt.contains(civ.getKnownCivs(), this.getCivInfo())) {
                if (civ.hasExplored(holyCity.getCenterTile())) {
                    stringArray = new String[]{"StatIcons/Faith"};
                    civ.addNotification('[' + this.getCivInfo().getCivName() + "] has founded [" + displayName + "] in [" + holyCity.getName() + "]!", ReligionAction.Companion.withLocation(holyCity.getLocation().toHexCoord(), name), Notification.NotificationCategory.Religion, stringArray);
                    continue;
                }
                stringArray = new String[]{"StatIcons/Faith"};
                civ.addNotification('[' + this.getCivInfo().getCivName() + "] has founded [" + displayName + "]!", new ReligionAction(name), Notification.NotificationCategory.Religion, stringArray);
                continue;
            }
            stringArray = new String[]{"StatIcons/Faith"};
            civ.addNotification("[An unknown civilization] has founded [" + displayName + "]!", new ReligionAction(name), Notification.NotificationCategory.Religion, stringArray);
        }
    }

    @Readonly
    public final boolean maySpreadReligionAtAll(@NotNull MapUnit missionary) {
        Intrinsics.checkNotNullParameter(missionary, "missionary");
        if (!this.getCivInfo().isMajorCiv()) {
            return false;
        }
        if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
            return false;
        }
        Religion religion = (Religion)((Map)missionary.getCiv().getGameInfo().getReligions()).get(missionary.getReligion());
        if (religion == null) {
            return false;
        }
        Religion religion2 = religion;
        if (religion2.isPantheon()) {
            return false;
        }
        return !SequencesKt.none(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(missionary, UniqueType.CanSpreadReligion));
    }

    @Readonly
    public final boolean maySpreadReligionNow(@NotNull MapUnit missionary) {
        Intrinsics.checkNotNullParameter(missionary, "missionary");
        if (!this.maySpreadReligionAtAll(missionary)) {
            return false;
        }
        if (missionary.getTile().getOwner() == null) {
            return false;
        }
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = missionary.getCurrentTile().getOwningCity();
        if (Intrinsics.areEqual(isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((City)isPartOfGameInfoSerialization).getReligion()) != null && (isPartOfGameInfoSerialization = ((CityReligionManager)isPartOfGameInfoSerialization).getMajorityReligion()) != null ? ((Religion)isPartOfGameInfoSerialization).getName() : null, missionary.getReligion())) {
            return false;
        }
        City city = missionary.getTile().getCity();
        Intrinsics.checkNotNull(city);
        return !city.getReligion().isProtectedByInquisitor(missionary.getReligion());
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int numberOfCitiesFollowingThisReligion() {
        void var3_3;
        if (this.religion == null) {
            return 0;
        }
        Sequence<City> $this$count$iv = this.getCivInfo().getGameInfo().getCities();
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<City> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            City element$iv;
            City it = element$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getReligion().getMajorityReligion(), this.religion) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int numberOfFollowersFollowingThisReligion(@NotNull String cityFilter) {
        Intrinsics.checkNotNullParameter(cityFilter, "cityFilter");
        if (this.religion == null) {
            return 0;
        }
        Sequence<City> sequence = SequencesKt.filter(this.getCivInfo().getGameInfo().getCities(), arg_0 -> ReligionManager.numberOfFollowersFollowingThisReligion$lambda$0(cityFilter, this, arg_0));
        int n = 0;
        Iterator<City> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            City city;
            City city2 = city = iterator2.next();
            int n2 = n;
            boolean bl = false;
            CityReligionManager cityReligionManager = it.getReligion();
            Religion religion = this.religion;
            Intrinsics.checkNotNull(religion);
            int n3 = cityReligionManager.getFollowersOf(religion.getName());
            n = n2 + n3;
        }
        return n;
    }

    @Readonly
    @Nullable
    public final City getHolyCity() {
        City city;
        block2: {
            if (this.religion == null) {
                return null;
            }
            Sequence<City> $this$firstOrNull$iv = this.getCivInfo().getGameInfo().getCities();
            boolean $i$f$firstOrNull = false;
            Iterator<City> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                City element$iv;
                City it = element$iv = iterator2.next();
                boolean bl = false;
                Religion religion = this.religion;
                Intrinsics.checkNotNull(religion);
                if (!it.isHolyCityOf(religion.getName())) continue;
                city = element$iv;
                break block2;
            }
            city = null;
        }
        return city;
    }

    @Readonly
    @Nullable
    public final Religion getMajorityReligion() {
        Object v0;
        Counter<Religion> religionCounter = new Counter<Religion>(null, 1, null);
        for (City city : this.getCivInfo().getCities()) {
            Religion cityMajorityReligion;
            if (city.getReligion().getMajorityReligion() == null) continue;
            religionCounter.add(cityMajorityReligion, 1);
        }
        Iterable iterable = ((Map)religionCounter).entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-ReligionManager$getMajorityReligion$maxReligionCounterEntry$1 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator2.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        if (entry == null) {
            return null;
        }
        Map.Entry maxReligionCounterEntry = entry;
        return ((Number)maxReligionCounterEntry.getValue()).intValue() > this.getCivInfo().getCities().size() / 2 ? (Religion)maxReligionCounterEntry.getKey() : null;
    }

    private static final void getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(Counter<BeliefType> availableBeliefs, Counter<BeliefType> beliefsToChoose, BeliefType type, int number) {
        int numberToAdd = Integer.min(number, ((Number)availableBeliefs.get((Object)type)).intValue());
        beliefsToChoose.add(type, numberToAdd);
        ((Map)availableBeliefs).put(type, ((Number)availableBeliefs.get((Object)type)).intValue() - numberToAdd);
        if (type != BeliefType.Any) {
            ((Map)availableBeliefs).put(BeliefType.Any, ((Number)availableBeliefs.get((Object)BeliefType.Any)).intValue() - numberToAdd);
        }
    }

    private static final boolean numberOfFollowersFollowingThisReligion$lambda$0(String $cityFilter, ReligionManager this$0, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return City.matchesFilter$default(it, $cityFilter, this$0.getCivInfo(), false, 4, null);
    }

    public static final /* synthetic */ int access$foundedReligionsCount(ReligionManager $this) {
        return $this.foundedReligionsCount();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReligionState.values().length];
            try {
                nArray[ReligionState.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReligionState.FoundingReligion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReligionState.EnhancingReligion.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

