/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.AStarPathfinder;
import com.unciv.logic.map.FixedPointMovement;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.MapPathing;
import com.unciv.logic.map.PathingMap;
import com.unciv.logic.map.PathingMapCache;
import com.unciv.logic.map.PathingMapCacheKey;
import com.unciv.logic.map.PathingMapCacheKt;
import com.unciv.logic.map.RouteNode;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.MovementCost;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.InternalState;
import yairm210.purity.annotations.Readonly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalState
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 72\u00020\u0001:\u00017Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001aH\u0002J\"\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00142\b\b\u0002\u0010#\u001a\u00020$H\u0007J%\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b*\u0010+J\b\u0010,\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001aH\u0002J\u0017\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b1\u00102J\"\u00103\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u00142\u0006\u00104\u001a\u00020$H\u0002J\n\u00105\u001a\u00020\u0006H\u0096\u0080\u0004J\u0012\u00106\u001a\u00020\u00062\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00198\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lcom/unciv/logic/map/PathingMap;", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "debugId", "debugMapType", "", "getCurrentCacheKey", "Lkotlin/Function0;", "Lcom/unciv/logic/map/PathingMapCacheKey;", "moveThroughPredicate", "Lcom/unciv/logic/map/PathingMap$Companion$MoveThroughPredicate;", "endTurnDamage", "Lcom/unciv/logic/map/PathingMap$Companion$EndTurnDamageLookup;", "cost", "Lcom/unciv/logic/map/PathingMap$Companion$TileMovementCost;", "tileRoadCost", "Lcom/unciv/logic/map/PathingMap$Companion$TileRoadCost;", "relationshipLevel", "Lkotlin/Function1;", "Lcom/unciv/logic/map/tile/Tile;", "Lcom/unciv/logic/civilization/diplomacy/RelationshipLevel;", "<init>", "(Lcom/unciv/logic/map/TileMap;Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lcom/unciv/logic/map/PathingMap$Companion$MoveThroughPredicate;Lcom/unciv/logic/map/PathingMap$Companion$EndTurnDamageLookup;Lcom/unciv/logic/map/PathingMap$Companion$TileMovementCost;Lcom/unciv/logic/map/PathingMap$Companion$TileRoadCost;Lkotlin/jvm/functions/Function1;)V", "cacheRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/unciv/logic/map/PathingMapCache;", "getCacheRef$annotations", "()V", "clear", "", "fetchCache", "getShortestPath", "", "destination", "maxTurns", "", "pathAsList", "", "targetNode", "Lcom/unciv/logic/map/RouteNode;", "cache", "pathAsList-7uXK2zo", "(JLcom/unciv/logic/map/PathingMapCache;)Ljava/util/List;", "getMovementToTilesAtPosition", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "getTilesSameTurn", "getCachedNode", "tile", "getCachedNode-ZqF76PM", "(Lcom/unciv/logic/map/tile/Tile;)J", "stepUntilDestination", "timeLimitTurns", "toString", "toDebugString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPathingMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathingMap.kt\ncom/unciv/logic/map/PathingMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionExtensions.kt\ncom/unciv/utils/CollectionExtensionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,407:1\n1586#2:408\n1661#2,3:409\n137#3,6:412\n137#3,6:418\n129#4:424\n158#4,3:425\n*S KotlinDebug\n*F\n+ 1 PathingMap.kt\ncom/unciv/logic/map/PathingMap\n*L\n165#1:408\n165#1:409,3\n223#1:412,6\n233#1:418,6\n243#1:424\n243#1:425,3\n*E\n"})
public final class PathingMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TileMap tileMap;
    @NotNull
    private final Object debugId;
    @NotNull
    private final String debugMapType;
    @NotNull
    private final Function0<PathingMapCacheKey> getCurrentCacheKey;
    @NotNull
    private final Companion.MoveThroughPredicate moveThroughPredicate;
    @NotNull
    private final Companion.EndTurnDamageLookup endTurnDamage;
    @NotNull
    private final Companion.TileMovementCost cost;
    @NotNull
    private final Companion.TileRoadCost tileRoadCost;
    @NotNull
    private final Function1<Tile, RelationshipLevel> relationshipLevel;
    @NotNull
    private final AtomicReference<PathingMapCache> cacheRef;
    public static final int MAX_VALID_TURNS = 62;
    @NotNull
    private static final HexCoord ALWAYS_LOG = new HexCoord(65535, 65534);
    @VisibleForTesting
    @NotNull
    private static final HexCoord NEVER_LOG;
    @VisibleForTesting
    @NotNull
    private static final HexCoord VERBOSE_PATHFINDING_LOGS;

    public PathingMap(@NotNull TileMap tileMap, @NotNull Object debugId, @NotNull String debugMapType, @NotNull Function0<PathingMapCacheKey> getCurrentCacheKey, @NotNull Companion.MoveThroughPredicate moveThroughPredicate, @NotNull Companion.EndTurnDamageLookup endTurnDamage, @NotNull Companion.TileMovementCost cost, @NotNull Companion.TileRoadCost tileRoadCost, @NotNull Function1<? super Tile, ? extends RelationshipLevel> relationshipLevel) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(debugId, "debugId");
        Intrinsics.checkNotNullParameter(debugMapType, "debugMapType");
        Intrinsics.checkNotNullParameter(getCurrentCacheKey, "getCurrentCacheKey");
        Intrinsics.checkNotNullParameter(moveThroughPredicate, "moveThroughPredicate");
        Intrinsics.checkNotNullParameter(endTurnDamage, "endTurnDamage");
        Intrinsics.checkNotNullParameter(cost, "cost");
        Intrinsics.checkNotNullParameter(tileRoadCost, "tileRoadCost");
        Intrinsics.checkNotNullParameter(relationshipLevel, "relationshipLevel");
        this.tileMap = tileMap;
        this.debugId = debugId;
        this.debugMapType = debugMapType;
        this.getCurrentCacheKey = getCurrentCacheKey;
        this.moveThroughPredicate = moveThroughPredicate;
        this.endTurnDamage = endTurnDamage;
        this.cost = cost;
        this.tileRoadCost = tileRoadCost;
        this.relationshipLevel = relationshipLevel;
        this.cacheRef = new AtomicReference<Object>(null);
    }

    @Cache
    private static /* synthetic */ void getCacheRef$annotations() {
    }

    public final void clear() {
        PathingMapCache cache2 = this.cacheRef.get();
        if (cache2 != null && Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
            Log.INSTANCE.debug("#clear explicitly dumping caches for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
        }
        this.cacheRef.set(null);
    }

    private final PathingMapCache fetchCache() {
        PathingMapCache pathingMapCache;
        long root;
        PathingMapCache oldCache;
        PathingMapCacheKey latestKey = this.getCurrentCacheKey.invoke();
        PathingMapCache pathingMapCache2 = oldCache = this.cacheRef.get();
        boolean bl = pathingMapCache2 != null ? pathingMapCache2.isCacheValid(latestKey) : false;
        if (bl) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, oldCache.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#fetchCache() reusing existing " + this.debugMapType + ' ' + this.debugId + " cache " + oldCache + " because keys are unchanged", new Object[0]);
            }
            return oldCache;
        }
        if (oldCache != null) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, oldCache.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#fetchCache() dumping cache " + this.debugMapType + ' ' + this.debugId + ' ' + oldCache + " because " + latestKey + " does not match", new Object[0]);
            }
            this.cacheRef.set(null);
        }
        PathingMapCache newCache = new PathingMapCache(latestKey, this.tileMap);
        int movementUsedThisTurn = FixedPointMovement.coerceIn-gvt-iPg(PathingMapCacheKt.minus-xpTseZw(latestKey.getFullMove(), latestKey.getMoveRemaining-uTAV3tY()), FixedPointMovement.Companion.getFPM_ZERO-uTAV3tY(), RouteNode.Companion.getMAX_MOVE_THIS_TURN-uTAV3tY());
        Tile tile = this.tileMap.get(latestKey.getStartingPoint());
        newCache.getRouteNodes$core()[tile.getZeroBasedIndex()] = root = RouteNode.Companion.rootNode-yTmVt7U(tile, movementUsedThisTurn);
        newCache.getNodesNeedingNeighbors$core().set(tile.getZeroBasedIndex(), true);
        if (this.cacheRef.compareAndSet(null, newCache)) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, latestKey.getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#fetchCache() initialized new cache " + this.debugMapType + ' ' + this.debugId + ' ' + newCache, new Object[0]);
            }
            pathingMapCache = newCache;
        } else {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, latestKey.getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#fetchCache() retrying cache fetch due to data race initializing cache " + newCache, new Object[0]);
            }
            pathingMapCache = this.fetchCache();
        }
        return pathingMapCache;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @Nullable
    public final List<Tile> getShortestPath(@NotNull Tile destination, int maxTurns) {
        long bestTarget;
        Intrinsics.checkNotNullParameter(destination, "destination");
        PathingMapCache cache2 = this.fetchCache();
        if (Intrinsics.areEqual(destination.getPosition(), cache2.getKey$core().getStartingPoint())) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#getShortestPath returning startingPoint cache.key.startingPoint for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return CollectionsKt.listOf(destination);
        }
        if (FixedPointMovement.compareTo-impl(cache2.getKey$core().getMoveRemaining-uTAV3tY(), 0) <= 0) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#getShortestPath emulating no-movement-pathing bug to " + destination + " for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return CollectionsKt.emptyList();
        }
        long targetNode = RouteNode.constructor-impl(cache2.getRouteNodes$core()[destination.getZeroBasedIndex()]);
        if (!RouteNode.getInitialized-impl(targetNode) && !cache2.getNodesNeedingNeighbors$core().isEmpty()) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#getShortestPath(" + destination.getPosition() + ") calculcating for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            this.stepUntilDestination(cache2, destination, maxTurns);
        }
        if (!RouteNode.getInitialized-impl(bestTarget = RouteNode.constructor-impl(cache2.getRouteNodes$core()[destination.getZeroBasedIndex()])) || RouteNode.isNoPathingNode-impl(bestTarget)) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#getShortestPath returning no path to " + destination + " for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return null;
        }
        List<Tile> result2 = this.pathAsList-7uXK2zo(bestTarget, cache2);
        if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
            Collection<HexCoord> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = result2;
            StringBuilder stringBuilder = new StringBuilder().append("#getShortestPath returning ");
            Log log = Log.INSTANCE;
            boolean $i$f$map = false;
            void var11_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tile tile = (Tile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPosition());
            }
            collection = (List)destination$iv$iv;
            log.debug(stringBuilder.append(collection).append(" to ").append(destination).append(" for ").append(this.debugMapType).append(' ').append(this.debugId).toString(), new Object[0]);
        }
        return result2;
    }

    public static /* synthetic */ List getShortestPath$default(PathingMap pathingMap, Tile tile, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 62;
        }
        return pathingMap.getShortestPath(tile, n);
    }

    private final List<Tile> pathAsList-7uXK2zo(long targetNode, PathingMapCache cache2) {
        long currentNode = targetNode;
        Tile[] tileArray = new Tile[]{RouteNode.tile-impl(currentNode, this.tileMap)};
        List<Tile> result2 = CollectionsKt.mutableListOf(tileArray);
        int turns = RouteNode.getTurns-impl(currentNode);
        while (true) {
            Tile parentTile = RouteNode.parentTile-impl(currentNode, this.tileMap);
            long parentNode = RouteNode.constructor-impl(cache2.getRouteNodes$core()[parentTile.getZeroBasedIndex()]);
            if (Intrinsics.areEqual(parentTile.getPosition(), cache2.getKey$core().getStartingPoint())) break;
            if (RouteNode.getTurns-impl(parentNode) < turns && RouteNode.getEndTurnWithoutMoreDamage-impl(parentNode)) {
                result2.add(parentTile);
                turns = RouteNode.getTurns-impl(parentNode);
            }
            currentNode = parentNode;
        }
        return CollectionsKt.asReversedMutable(result2);
    }

    @Readonly
    @NotNull
    public final PathsToTilesWithinTurn getMovementToTilesAtPosition() {
        PathingMapCache cache2 = this.fetchCache();
        PathsToTilesWithinTurn tilesSameTurn = cache2.getTilesSameTurn$core();
        if (!((Map)tilesSameTurn).isEmpty()) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#getMovementToTilesAtPosition returning cached tilesSameTurn[len=" + tilesSameTurn.size() + "] for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return tilesSameTurn;
        }
        if (!cache2.getNodesNeedingNeighbors$core().isEmpty()) {
            if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                Log.INSTANCE.debug("#getMovementToTilesAtPosition calculcating for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            this.stepUntilDestination(cache2, null, 1);
        }
        this.getTilesSameTurn(cache2);
        return tilesSameTurn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void getTilesSameTurn(PathingMapCache cache2) {
        BitSet $this$forEachSetBit$iv;
        PathsToTilesWithinTurn tilesSameTurn;
        Map<Tile, UnitMovement.ParentTileAndTotalMovement> map2 = tilesSameTurn = cache2.getTilesSameTurn$core();
        synchronized (map2) {
            Tile tile;
            long node;
            int it;
            boolean bl = false;
            if (!((Map)tilesSameTurn).isEmpty()) {
                if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
                    Log.INSTANCE.debug("#getMovementToTilesAtPosition returning cached tilesSameTurn[len=" + tilesSameTurn.size() + "] which was calculated by another thread for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
                }
                return;
            }
            $this$forEachSetBit$iv = cache2.getAddedNeighborNodes$core();
            boolean $i$f$forEachSetBit = false;
            int bit$iv = $this$forEachSetBit$iv.nextSetBit(0);
            while (bit$iv >= 0) {
                it = bit$iv;
                boolean bl2 = false;
                node = RouteNode.constructor-impl(cache2.getRouteNodes$core()[it]);
                if (RouteNode.getInitialized-impl(node) && RouteNode.getTurns-impl(node) == 0) {
                    tile = RouteNode.tile-impl(node, this.tileMap);
                    ((Map)tilesSameTurn).put(tile, new UnitMovement.ParentTileAndTotalMovement(tile, RouteNode.parentTile-impl(node, this.tileMap), FixedPointMovement.toFloat-impl(RouteNode.getMoveUsedThisTurn-uTAV3tY(node))));
                }
                bit$iv = $this$forEachSetBit$iv.nextSetBit(bit$iv + 1);
            }
            $this$forEachSetBit$iv = cache2.getNodesNeedingNeighbors$core();
            $i$f$forEachSetBit = false;
            bit$iv = $this$forEachSetBit$iv.nextSetBit(0);
            while (bit$iv >= 0) {
                it = bit$iv;
                boolean bl3 = false;
                node = RouteNode.constructor-impl(cache2.getRouteNodes$core()[it]);
                if (RouteNode.getInitialized-impl(node) && RouteNode.getTurns-impl(node) == 0) {
                    tile = RouteNode.tile-impl(node, this.tileMap);
                    ((Map)tilesSameTurn).put(tile, new UnitMovement.ParentTileAndTotalMovement(tile, RouteNode.parentTile-impl(node, this.tileMap), FixedPointMovement.toFloat-impl(RouteNode.getMoveUsedThisTurn-uTAV3tY(node))));
                }
                bit$iv = $this$forEachSetBit$iv.nextSetBit(bit$iv + 1);
            }
            Unit $i$a$-synchronized-PathingMap$getTilesSameTurn$2 = Unit.INSTANCE;
        }
        if (Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, cache2.getKey$core().getStartingPoint()) || Intrinsics.areEqual(VERBOSE_PATHFINDING_LOGS, ALWAYS_LOG)) {
            Collection<HexCoord> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            map2 = tilesSameTurn;
            StringBuilder stringBuilder = new StringBuilder().append("#getMovementToTilesAtPosition calculcated tilesSameTurn=");
            Log log = Log.INSTANCE;
            boolean $i$f$map = false;
            $this$forEachSetBit$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry node = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Tile)it.getKey()).getPosition());
            }
            collection = (List)destination$iv$iv;
            log.debug(stringBuilder.append(collection).append(" for ").append(this.debugMapType).append(' ').append(this.debugId).toString(), new Object[0]);
        }
    }

    @Readonly
    @VisibleForTesting
    public final long getCachedNode-ZqF76PM(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        PathingMapCache pathingMapCache = this.cacheRef.get();
        return RouteNode.constructor-impl(pathingMapCache != null ? pathingMapCache.getRouteNodes$core()[tile.getZeroBasedIndex()] : 0L);
    }

    private final void stepUntilDestination(PathingMapCache cache2, Tile destination, int timeLimitTurns) {
        AStarPathfinder finder = new AStarPathfinder(this.debugId, this.debugMapType, destination, this.moveThroughPredicate, this.endTurnDamage, this.cost, this.tileRoadCost, this.relationshipLevel, cache2.forkForPathfinding(), RangesKt.coerceAtMost(timeLimitTurns, 62), this.tileMap);
        finder.stepUntilDestination$core();
        cache2.mergePathfindingFork(finder.getCache$core());
    }

    @NotNull
    public String toString() {
        PathingMapCache cache2 = this.cacheRef.get();
        PathingMapCache pathingMapCache = cache2;
        return this.getClass().getSimpleName() + "[debugMapType=" + this.debugMapType + " debugId=" + this.debugId + " key=" + (pathingMapCache != null ? pathingMapCache.getKey$core() : null) + ']';
    }

    @NotNull
    public final String toDebugString(@Nullable Tile destination) {
        return this.fetchCache().toDebugString(this.tileMap, destination);
    }

    public static /* synthetic */ String toDebugString$default(PathingMap pathingMap, Tile tile, int n, Object object) {
        if ((n & 1) != 0) {
            tile = null;
        }
        return pathingMap.toDebugString(tile);
    }

    static {
        VERBOSE_PATHFINDING_LOGS = NEVER_LOG = new HexCoord(65535, 65535);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004%&'(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u0007J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0007J \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0007J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0007H\u0003J \u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0003J \u0010$\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\nR\u0016\u0010\u000e\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006)"}, d2={"Lcom/unciv/logic/map/PathingMap$Companion;", "", "<init>", "()V", "MAX_VALID_TURNS", "", "ALWAYS_LOG", "Lcom/unciv/logic/map/HexCoord;", "getALWAYS_LOG$core$annotations", "getALWAYS_LOG$core", "()Lcom/unciv/logic/map/HexCoord;", "NEVER_LOG", "getNEVER_LOG$annotations", "getNEVER_LOG", "VERBOSE_PATHFINDING_LOGS", "getVERBOSE_PATHFINDING_LOGS", "createUnitPathingMap", "Lcom/unciv/logic/map/PathingMap;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "considerZoneOfControl", "", "includeEscortUnit", "createLandAttackPathingMap", "civ", "Lcom/unciv/logic/civilization/Civilization;", "startingPoint", "Lcom/unciv/logic/map/tile/Tile;", "targetCiv", "createAmphibiousAttackPathingMap", "createRoadPathingMap", "civPathingCacheKey", "Lcom/unciv/logic/map/PathingMapCacheKey;", "isTileCanAttackThrough", "civInfo", "tile", "isLandTileCanAttackThrough", "MoveThroughPredicate", "EndTurnDamageLookup", "TileMovementCost", "TileRoadCost", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HexCoord getALWAYS_LOG$core() {
            return ALWAYS_LOG;
        }

        public static /* synthetic */ void getALWAYS_LOG$core$annotations() {
        }

        @NotNull
        public final HexCoord getNEVER_LOG() {
            return NEVER_LOG;
        }

        public static /* synthetic */ void getNEVER_LOG$annotations() {
        }

        @NotNull
        public final HexCoord getVERBOSE_PATHFINDING_LOGS() {
            return VERBOSE_PATHFINDING_LOGS;
        }

        @Readonly
        @NotNull
        public final PathingMap createUnitPathingMap(@NotNull MapUnit unit, boolean considerZoneOfControl, boolean includeEscortUnit) {
            int n;
            Intrinsics.checkNotNullParameter(unit, "unit");
            String name = !considerZoneOfControl ? "createUnitPathingMapNoZoc" : (!includeEscortUnit ? "createUnitPathingMapNoEscort" : "createUnitPathingMap");
            int selfFullMove = MapUnit.getMaxMovement$default(unit, false, 1, null);
            if (includeEscortUnit) {
                MapUnit mapUnit = unit.getOtherEscortUnit();
                n = mapUnit != null ? MapUnit.getMaxMovement$default(mapUnit, false, 1, null) : 63;
            } else {
                n = 63;
            }
            int otherUntilFullMove = n;
            Function0<PathingMapCacheKey> getCurrentCacheKey = () -> Companion.createUnitPathingMap$lambda$0(includeEscortUnit, unit, selfFullMove, otherUntilFullMove);
            return new PathingMap(unit.getCurrentTile().getTileMap(), unit, name, getCurrentCacheKey, arg_0 -> Companion.createUnitPathingMap$lambda$1(unit, arg_0), arg_0 -> Companion.createUnitPathingMap$lambda$2(unit, arg_0), new TileMovementCost(unit, considerZoneOfControl, includeEscortUnit){
                final /* synthetic */ MapUnit $unit;
                final /* synthetic */ boolean $considerZoneOfControl;
                final /* synthetic */ boolean $includeEscortUnit;
                {
                    this.$unit = $unit;
                    this.$considerZoneOfControl = $considerZoneOfControl;
                    this.$includeEscortUnit = $includeEscortUnit;
                }

                public final int invoke-_zTpDcI(Tile from, Tile to) {
                    Intrinsics.checkNotNullParameter(from, "from");
                    Intrinsics.checkNotNullParameter(to, "to");
                    return FixedPointMovement.Companion.fpmFromMovement-o4tN_Zo(MovementCost.INSTANCE.getMovementCostBetweenAdjacentTilesEscort(this.$unit, from, to, this.$considerZoneOfControl, this.$includeEscortUnit));
                }
            }, new TileRoadCost(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                }

                public final int invoke-o4tN_Zo(Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return FixedPointMovement.Companion.fpmFromMovement-o4tN_Zo(it.getConnectionStatus(this.$unit.getCiv()).getMovement());
                }
            }, arg_0 -> Companion.createUnitPathingMap$lambda$3(unit, arg_0));
        }

        public static /* synthetic */ PathingMap createUnitPathingMap$default(Companion companion, MapUnit mapUnit, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.createUnitPathingMap(mapUnit, bl, bl2);
        }

        @Readonly
        @NotNull
        public final PathingMap createLandAttackPathingMap(@NotNull Civilization civ, @NotNull Tile startingPoint, @NotNull Civilization targetCiv) {
            Intrinsics.checkNotNullParameter(civ, "civ");
            Intrinsics.checkNotNullParameter(startingPoint, "startingPoint");
            Intrinsics.checkNotNullParameter(targetCiv, "targetCiv");
            return new PathingMap(civ.getGameInfo().getTileMap(), civ, "createLandAttackPathingMap", () -> Companion.createLandAttackPathingMap$lambda$0(startingPoint), arg_0 -> Companion.createLandAttackPathingMap$lambda$1(civ, targetCiv, arg_0), Companion::createLandAttackPathingMap$lambda$2, new TileMovementCost(civ){
                final /* synthetic */ Civilization $civ;
                {
                    this.$civ = $civ;
                }

                public final int invoke-_zTpDcI(Tile from, Tile to) {
                    Intrinsics.checkNotNullParameter(from, "from");
                    Intrinsics.checkNotNullParameter(to, "to");
                    return FixedPointMovement.Companion.fpmFromMovement-o4tN_Zo(MapPathing.INSTANCE.roadPreferredMovementCost$core(this.$civ, from, to));
                }
            }, new TileRoadCost(civ){
                final /* synthetic */ Civilization $civ;
                {
                    this.$civ = $civ;
                }

                public final int invoke-o4tN_Zo(Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return FixedPointMovement.Companion.fpmFromMovement-o4tN_Zo(it.getConnectionStatus(this.$civ).getMovement());
                }
            }, arg_0 -> Companion.createLandAttackPathingMap$lambda$3(civ, arg_0));
        }

        @Readonly
        @NotNull
        public final PathingMap createAmphibiousAttackPathingMap(@NotNull Civilization civ, @NotNull Tile startingPoint, @NotNull Civilization targetCiv) {
            Intrinsics.checkNotNullParameter(civ, "civ");
            Intrinsics.checkNotNullParameter(startingPoint, "startingPoint");
            Intrinsics.checkNotNullParameter(targetCiv, "targetCiv");
            return new PathingMap(civ.getGameInfo().getTileMap(), civ, "createAmphibiousAttackPathingMap", () -> Companion.createAmphibiousAttackPathingMap$lambda$0(startingPoint), arg_0 -> Companion.createAmphibiousAttackPathingMap$lambda$1(civ, targetCiv, arg_0), Companion::createAmphibiousAttackPathingMap$lambda$2, new TileMovementCost(civ){
                final /* synthetic */ Civilization $civ;
                {
                    this.$civ = $civ;
                }

                public final int invoke-_zTpDcI(Tile from, Tile to) {
                    Intrinsics.checkNotNullParameter(from, "from");
                    Intrinsics.checkNotNullParameter(to, "to");
                    return FixedPointMovement.Companion.fpmFromMovement-o4tN_Zo(MapPathing.INSTANCE.roadPreferredMovementCost$core(this.$civ, from, to));
                }
            }, new TileRoadCost(civ){
                final /* synthetic */ Civilization $civ;
                {
                    this.$civ = $civ;
                }

                public final int invoke-o4tN_Zo(Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return FixedPointMovement.Companion.fpmFromMovement-o4tN_Zo(it.getConnectionStatus(this.$civ).getMovement());
                }
            }, arg_0 -> Companion.createAmphibiousAttackPathingMap$lambda$3(civ, arg_0));
        }

        @Readonly
        @NotNull
        public final PathingMap createRoadPathingMap(@NotNull Civilization civ, @NotNull Tile startingPoint) {
            Intrinsics.checkNotNullParameter(civ, "civ");
            Intrinsics.checkNotNullParameter(startingPoint, "startingPoint");
            return new PathingMap(civ.getGameInfo().getTileMap(), civ, "createRoadPathingMap", () -> Companion.createRoadPathingMap$lambda$0(startingPoint), arg_0 -> Companion.createRoadPathingMap$lambda$1(civ, arg_0), Companion::createRoadPathingMap$lambda$2, new TileMovementCost(civ){
                final /* synthetic */ Civilization $civ;
                {
                    this.$civ = $civ;
                }

                public final int invoke-_zTpDcI(Tile tile, Tile to) {
                    Intrinsics.checkNotNullParameter(tile, "<unused var>");
                    Intrinsics.checkNotNullParameter(to, "to");
                    return to.hasRoadConnection(this.$civ, false) || to.hasRailroadConnection(false) ? FixedPointMovement.Companion.getFPM_POINT_FIVE-uTAV3tY() : FixedPointMovement.Companion.getFPM_ONE-uTAV3tY();
                }
            }, createRoadPathingMap.5.INSTANCE, arg_0 -> Companion.createRoadPathingMap$lambda$3(civ, arg_0));
        }

        @Readonly
        private final PathingMapCacheKey civPathingCacheKey(HexCoord startingPoint) {
            return new PathingMapCacheKey(startingPoint, RouteNode.Companion.getMAX_MOVE_THIS_TURN-uTAV3tY(), 62, null);
        }

        @Readonly
        private final boolean isTileCanAttackThrough(Civilization civInfo, Tile tile, Civilization targetCiv) {
            Civilization owner = tile.getOwner();
            return !tile.isImpassible() && (Intrinsics.areEqual(owner, targetCiv) || owner == null || civInfo.getDiplomacyFunctions().canPassThroughTiles(owner));
        }

        @Readonly
        private final boolean isLandTileCanAttackThrough(Civilization civInfo, Tile tile, Civilization targetCiv) {
            return tile.isLand() && this.isTileCanAttackThrough(civInfo, tile, targetCiv);
        }

        private static final PathingMapCacheKey createUnitPathingMap$lambda$0(boolean $includeEscortUnit, MapUnit $unit, int $selfFullMove, int $otherUntilFullMove) {
            MapUnit escort = $includeEscortUnit && $unit.isEscorting() ? $unit.getOtherEscortUnit() : null;
            MapUnit mapUnit = escort;
            return new PathingMapCacheKey($unit.getCurrentTile().getPosition(), FixedPointMovement.coerceAtMost-qwRIMkA(FixedPointMovement.Companion.fpmFromMovement-o4tN_Zo($unit.getCurrentMovement()), mapUnit != null ? PathingMapCacheKt.toFixedPointMove(mapUnit.getCurrentMovement()) : RouteNode.Companion.getMAX_MOVE_THIS_TURN-uTAV3tY()), RangesKt.coerceAtMost($selfFullMove, escort != null ? $otherUntilFullMove : 62), null);
        }

        private static final boolean createUnitPathingMap$lambda$1(MapUnit $unit, Tile it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return UnitMovement.canPassThrough$default($unit.getMovement(), it, false, 2, null);
        }

        private static final int createUnitPathingMap$lambda$2(MapUnit $unit, Tile it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return $unit.getDamageFromTerrain(it);
        }

        private static final RelationshipLevel createUnitPathingMap$lambda$3(MapUnit $unit, Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Object object = tile.getOwner();
            if (object == null || (object = object.getDiplomacyManager($unit.getCiv())) == null || (object = ((DiplomacyManager)object).relationshipIgnoreAfraid()) == null) {
                object = RelationshipLevel.Favorable;
            }
            return object;
        }

        private static final PathingMapCacheKey createLandAttackPathingMap$lambda$0(Tile $startingPoint) {
            return Companion.civPathingCacheKey($startingPoint.getPosition());
        }

        private static final boolean createLandAttackPathingMap$lambda$1(Civilization $civ, Civilization $targetCiv, Tile it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return Companion.isLandTileCanAttackThrough($civ, it, $targetCiv);
        }

        private static final int createLandAttackPathingMap$lambda$2(Tile it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return 0;
        }

        private static final RelationshipLevel createLandAttackPathingMap$lambda$3(Civilization $civ, Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Object object = tile.getOwner();
            if (object == null || (object = object.getDiplomacyManager($civ)) == null || (object = ((DiplomacyManager)object).relationshipIgnoreAfraid()) == null) {
                object = RelationshipLevel.Favorable;
            }
            return object;
        }

        private static final PathingMapCacheKey createAmphibiousAttackPathingMap$lambda$0(Tile $startingPoint) {
            return Companion.civPathingCacheKey($startingPoint.getPosition());
        }

        private static final boolean createAmphibiousAttackPathingMap$lambda$1(Civilization $civ, Civilization $targetCiv, Tile it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return Companion.isTileCanAttackThrough($civ, it, $targetCiv);
        }

        private static final int createAmphibiousAttackPathingMap$lambda$2(Tile it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return 0;
        }

        private static final RelationshipLevel createAmphibiousAttackPathingMap$lambda$3(Civilization $civ, Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Object object = tile.getOwner();
            if (object == null || (object = object.getDiplomacyManager($civ)) == null || (object = ((DiplomacyManager)object).relationshipIgnoreAfraid()) == null) {
                object = RelationshipLevel.Favorable;
            }
            return object;
        }

        private static final PathingMapCacheKey createRoadPathingMap$lambda$0(Tile $startingPoint) {
            return Companion.civPathingCacheKey($startingPoint.getPosition());
        }

        private static final boolean createRoadPathingMap$lambda$1(Civilization $civ, Tile it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return MapPathing.INSTANCE.isValidRoadPathTile($civ, it);
        }

        private static final int createRoadPathingMap$lambda$2(Tile it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return 0;
        }

        private static final RelationshipLevel createRoadPathingMap$lambda$3(Civilization $civ, Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Object object = tile.getOwner();
            if (object == null || (object = object.getDiplomacyManager($civ)) == null || (object = ((DiplomacyManager)object).relationshipIgnoreAfraid()) == null) {
                object = RelationshipLevel.Favorable;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @FunctionalInterface
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7\u0002\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/unciv/logic/map/PathingMap$Companion$EndTurnDamageLookup;", "", "invoke", "", "it", "Lcom/unciv/logic/map/tile/Tile;", "core"})
        public static interface EndTurnDamageLookup {
            @Readonly
            public int invoke(@NotNull Tile var1);
        }

        @FunctionalInterface
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7\u0002\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/unciv/logic/map/PathingMap$Companion$MoveThroughPredicate;", "", "invoke", "", "it", "Lcom/unciv/logic/map/tile/Tile;", "core"})
        public static interface MoveThroughPredicate {
            @Readonly
            public boolean invoke(@NotNull Tile var1);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @FunctionalInterface
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u00a7\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lcom/unciv/logic/map/PathingMap$Companion$TileMovementCost;", "", "invoke", "Lcom/unciv/logic/map/FixedPointMovement;", "from", "Lcom/unciv/logic/map/tile/Tile;", "to", "invoke-_zTpDcI", "(Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/map/tile/Tile;)I", "core"})
        public static interface TileMovementCost {
            @Readonly
            public int invoke-_zTpDcI(@NotNull Tile var1, @NotNull Tile var2);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @FunctionalInterface
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/unciv/logic/map/PathingMap$Companion$TileRoadCost;", "", "invoke", "Lcom/unciv/logic/map/FixedPointMovement;", "it", "Lcom/unciv/logic/map/tile/Tile;", "invoke-o4tN_Zo", "(Lcom/unciv/logic/map/tile/Tile;)I", "core"})
        public static interface TileRoadCost {
            @Readonly
            public int invoke-o4tN_Zo(@NotNull Tile var1);
        }
    }
}

