/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.map.FixedPointMovement;
import com.unciv.logic.map.PathingMapCacheKey;
import com.unciv.logic.map.RouteNode;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.tile.Tile;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.InternalState;

@InternalState
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000J\u0006\u0010 \u001a\u00020\u001eJ\u001a\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$J \u0010%\u001a\u00020\u001e*\u00020&2\b\u0010'\u001a\u0004\u0018\u00010$2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\n\u0010(\u001a\u00020\"H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lcom/unciv/logic/map/PathingMapCache;", "", "key", "Lcom/unciv/logic/map/PathingMapCacheKey;", "nodesNeedingNeighbors", "Ljava/util/BitSet;", "addedNeighborNodes", "routeNodes", "", "<init>", "(Lcom/unciv/logic/map/PathingMapCacheKey;Ljava/util/BitSet;Ljava/util/BitSet;[J)V", "tileMap", "Lcom/unciv/logic/map/TileMap;", "(Lcom/unciv/logic/map/PathingMapCacheKey;Lcom/unciv/logic/map/TileMap;)V", "getKey$core", "()Lcom/unciv/logic/map/PathingMapCacheKey;", "getNodesNeedingNeighbors$core", "()Ljava/util/BitSet;", "getAddedNeighborNodes$core", "getRouteNodes$core", "()[J", "tilesSameTurn", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "getTilesSameTurn$core", "()Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "isCacheValid", "", "latestKey", "forkForPathfinding", "mergePathfindingFork", "", "update", "clear", "toDebugString", "", "destination", "Lcom/unciv/logic/map/tile/Tile;", "toDebugStringFormatNode", "Ljava/util/Formatter;", "tile", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nPathingMapCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathingMapCache.kt\ncom/unciv/logic/map/PathingMapCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionExtensions.kt\ncom/unciv/utils/CollectionExtensionsKt\n*L\n1#1,446:1\n788#2:447\n800#2:448\n1924#2,2:449\n801#2,2:451\n1926#2:453\n803#2:454\n1915#2,2:455\n137#3,6:457\n137#3,3:463\n137#3,6:466\n140#3,3:472\n*S KotlinDebug\n*F\n+ 1 PathingMapCache.kt\ncom/unciv/logic/map/PathingMapCache\n*L\n385#1:447\n385#1:448\n385#1:449,2\n385#1:451,2\n385#1:453\n385#1:454\n392#1:455,2\n400#1:457,6\n406#1:463,3\n412#1:466,6\n406#1:472,3\n*E\n"})
public final class PathingMapCache {
    @NotNull
    private final PathingMapCacheKey key;
    @NotNull
    private final BitSet nodesNeedingNeighbors;
    @NotNull
    private final BitSet addedNeighborNodes;
    @NotNull
    private final long[] routeNodes;
    @NotNull
    private final PathsToTilesWithinTurn tilesSameTurn;

    private PathingMapCache(PathingMapCacheKey key, BitSet nodesNeedingNeighbors, BitSet addedNeighborNodes, long[] routeNodes) {
        this.key = key;
        this.nodesNeedingNeighbors = nodesNeedingNeighbors;
        this.addedNeighborNodes = addedNeighborNodes;
        this.routeNodes = routeNodes;
        this.tilesSameTurn = new PathsToTilesWithinTurn();
    }

    @NotNull
    public final PathingMapCacheKey getKey$core() {
        return this.key;
    }

    @NotNull
    public final BitSet getNodesNeedingNeighbors$core() {
        return this.nodesNeedingNeighbors;
    }

    @NotNull
    public final BitSet getAddedNeighborNodes$core() {
        return this.addedNeighborNodes;
    }

    @NotNull
    public final long[] getRouteNodes$core() {
        return this.routeNodes;
    }

    @NotNull
    public final PathsToTilesWithinTurn getTilesSameTurn$core() {
        return this.tilesSameTurn;
    }

    public PathingMapCache(@NotNull PathingMapCacheKey key, @NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        this(key, new BitSet(tileMap.getTileList().size()), new BitSet(tileMap.getTileList().size()), new long[tileMap.getTileList().size()]);
    }

    public final boolean isCacheValid(@NotNull PathingMapCacheKey latestKey) {
        Intrinsics.checkNotNullParameter(latestKey, "latestKey");
        return Intrinsics.areEqual(this.key, latestKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PathingMapCache forkForPathfinding() {
        BitSet bitSet = this.addedNeighborNodes;
        synchronized (bitSet) {
            boolean bl = false;
            Object object = this.nodesNeedingNeighbors.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.util.BitSet");
            BitSet codesNeedingNeighborsCopy = (BitSet)object;
            Object object2 = this.addedNeighborNodes.clone();
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type java.util.BitSet");
            BitSet addedNeighborNodesCopy = (BitSet)object2;
            PathingMapCache pathingMapCache = new PathingMapCache(this.key, codesNeedingNeighborsCopy, addedNeighborNodesCopy, this.routeNodes);
            return pathingMapCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mergePathfindingFork(@NotNull PathingMapCache update2) {
        Intrinsics.checkNotNullParameter(update2, "update");
        if (!(Intrinsics.areEqual(this.key, update2.key) && this.routeNodes == this.routeNodes)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        BitSet bitSet = this.addedNeighborNodes;
        synchronized (bitSet) {
            boolean bl = false;
            this.addedNeighborNodes.or(update2.addedNeighborNodes);
            this.nodesNeedingNeighbors.andNot(update2.addedNeighborNodes);
            update2.nodesNeedingNeighbors.andNot(update2.addedNeighborNodes);
            this.nodesNeedingNeighbors.or(update2.nodesNeedingNeighbors);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void clear() {
        this.nodesNeedingNeighbors.clear();
        this.addedNeighborNodes.clear();
        ArraysKt.fill$default(this.routeNodes, 0L, 0, 0, 6, null);
        this.tilesSameTurn.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String toDebugString(@NotNull TileMap tileMap, @Nullable Tile destination) {
        void $this$filterIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Iterable $this$filterIndexed$iv = tileMap.getTileList();
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            Tile cfr_ignored_0 = (Tile)element$iv$iv;
            int idx = index$iv$iv;
            boolean bl2 = false;
            if (!RouteNode.getInitialized-impl(RouteNode.constructor-impl(this.routeNodes[idx]))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List routeTiles = (List)destination$iv$iv;
        if (routeTiles.isEmpty()) {
            return "{}";
        }
        int height = -tileMap.getBottomY() * 2;
        int width = tileMap.getTileMatrix().size();
        BitSet xs = new BitSet(width);
        BitSet ys = new BitSet(height);
        Iterable $this$forEach$iv = routeTiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tile it = (Tile)element$iv;
            boolean bl = false;
            xs.set(it.getPosition().getX() - tileMap.getLeftX());
            ys.set(height - it.getPosition().getY() + tileMap.getBottomY());
        }
        StringBuilder stringBuilder = new StringBuilder("\n");
        Closeable closeable = new Formatter(stringBuilder, Locale.US);
        Object object = null;
        try {
            Formatter it = (Formatter)closeable;
            boolean bl = false;
            it.format("       ", new Object[0]);
            BitSet $this$forEachSetBit$iv = xs;
            boolean $i$f$forEachSetBit = false;
            int bit$iv = $this$forEachSetBit$iv.nextSetBit(0);
            while (bit$iv >= 0) {
                int xIndex = bit$iv;
                boolean bl3 = false;
                int x = xIndex + tileMap.getLeftX();
                Object[] idx = new Object[]{x};
                it.format(" %+-4d  ", idx);
                bit$iv = $this$forEachSetBit$iv.nextSetBit(bit$iv + 1);
            }
            it.format("\n", new Object[0]);
            $this$forEachSetBit$iv = ys;
            $i$f$forEachSetBit = false;
            bit$iv = $this$forEachSetBit$iv.nextSetBit(0);
            while (bit$iv >= 0) {
                int yIndex = bit$iv;
                boolean bl4 = false;
                int y = -yIndex + height + tileMap.getBottomY();
                Object[] idx = new Object[]{y};
                it.format("  %+-4d ", idx);
                BitSet $this$forEachSetBit$iv2 = xs;
                boolean $i$f$forEachSetBit2 = false;
                int bit$iv2 = $this$forEachSetBit$iv2.nextSetBit(0);
                while (bit$iv2 >= 0) {
                    int xIndex = bit$iv2;
                    boolean bl5 = false;
                    int x = xIndex + tileMap.getLeftX();
                    Tile tile = tileMap.getOrNull(x, y);
                    this.toDebugStringFormatNode(it, tile, destination);
                    bit$iv2 = $this$forEachSetBit$iv2.nextSetBit(bit$iv2 + 1);
                }
                it.format("\n", new Object[0]);
                bit$iv = $this$forEachSetBit$iv.nextSetBit(bit$iv + 1);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally(closeable, object);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally(closeable, (Throwable)object);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static /* synthetic */ String toDebugString$default(PathingMapCache pathingMapCache, TileMap tileMap, Tile tile, int n, Object object) {
        if ((n & 2) != 0) {
            tile = null;
        }
        return pathingMapCache.toDebugString(tileMap, tile);
    }

    private final void toDebugStringFormatNode(Formatter $this$toDebugStringFormatNode, Tile tile, Tile destination) {
        Formatter formatter;
        if (tile == null) {
            $this$toDebugStringFormatNode.format("       ", new Object[0]);
            return;
        }
        long node = RouteNode.constructor-impl(this.routeNodes[tile.getZeroBasedIndex()]);
        if (!RouteNode.getInitialized-impl(node)) {
            formatter = $this$toDebugStringFormatNode.format("  /    ", new Object[0]);
        } else {
            char tag;
            char c = RouteNode.getTurns-impl(node) == 0 && FixedPointMovement.equals-impl0(RouteNode.getMoveUsedThisTurn-uTAV3tY(node), FixedPointMovement.Companion.getFPM_ZERO-uTAV3tY()) ? (char)'S' : (Intrinsics.areEqual(tile, destination) ? (char)'D' : (tag = !RouteNode.getEndTurnWithoutMoreDamage-impl(node) ? (char)'*' : ' '));
            if (RouteNode.getTurns-impl(node) == Integer.MAX_VALUE) {
                Object[] objectArray = new Object[]{Character.valueOf(tag)};
                formatter = $this$toDebugStringFormatNode.format(" -/---%s", objectArray);
            } else {
                Object[] objectArray = new Object[]{RouteNode.getTurns-impl(node), Float.valueOf(FixedPointMovement.toFloat-impl(RouteNode.getMoveUsedThisTurn-uTAV3tY(node))), Character.valueOf(tag)};
                formatter = $this$toDebugStringFormatNode.format("%2d/%1.1f%s", objectArray);
            }
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "[key=" + this.key.getStartingPoint() + '/' + FixedPointMovement.toString-impl(this.key.getMoveRemaining-uTAV3tY()) + '/' + this.key.getFullMove() + " nodesNeedingNeighbors=" + this.nodesNeedingNeighbors.cardinality() + " addedNeighborNodes=" + this.addedNeighborNodes.cardinality() + " routeNodes=" + this.routeNodes.length + " tilesSameTurn=" + this.tilesSameTurn.size();
    }
}

