/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.badlogic.gdx.math.Vector2;
import com.unciv.Constants;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapElevationGenerator;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.mapgenerator.MapLandmassGenerator;
import com.unciv.logic.map.mapgenerator.NaturalWonderGenerator;
import com.unciv.logic.map.mapgenerator.RiverGenerator;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegions;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileImprovementFunctions;
import com.unciv.logic.map.tile.TileNormalizer;
import com.unciv.models.Counter;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.screens.mapeditorscreen.MapGeneratorSteps;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0017\u0018\u0000 S2\u00020\u0001:\u0003STUB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012*\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\rJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0016\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&J\u001e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0+H\u0002J\u0014\u0010,\u001a\u00020\"2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.J\u0010\u00100\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u00101\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u00102\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0018\u00105\u001a\u00020\"2\u0006\u00104\u001a\u00020\u00152\u0006\u00106\u001a\u000207H\u0002J \u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\u00152\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\"2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020/2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020<H\u0002J0\u0010A\u001a\u00020?2\u0006\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020?2\u0006\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020?2\u0006\u0010F\u001a\u00020<H\u0002J\u0010\u0010G\u001a\u00020\"2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u0010H\u001a\u00020\"2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u0010I\u001a\u00020\"2\u0006\u00104\u001a\u00020\u0015H\u0002J\u001e\u0010J\u001a\u00020\"2\u0006\u00104\u001a\u00020\u00152\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J,\u0010L\u001a\u00020\"2\u0006\u0010=\u001a\u00020/2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J,\u0010N\u001a\u00020\"2\u0006\u0010=\u001a\u00020/2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J&\u0010O\u001a\u00020\"2\u0006\u0010=\u001a\u00020/2\u0006\u0010P\u001a\u00020\u000e2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J,\u0010Q\u001a\u00020\"2\u0006\u0010=\u001a\u00020/2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;Lkotlinx/coroutines/CoroutineScope;)V", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "terrainConditions", "", "Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange;", "baseTerrainPicker", "terrainFeaturePicker", "getGenerationConditions", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/tile/Terrain;", "generateMap", "Lcom/unciv/logic/map/TileMap;", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "civilizations", "Lcom/unciv/logic/civilization/Civilization;", "flipTopBottom", "Lcom/badlogic/gdx/math/Vector2;", "vector", "Lcom/unciv/logic/map/HexCoord;", "flipLeftRight", "mirror", "", "map", "generateSingleStep", "step", "Lcom/unciv/ui/screens/mapeditorscreen/MapGeneratorSteps;", "runAndMeasure", "text", "", "action", "Lkotlin/Function0;", "convertTerrains", "tiles", "", "Lcom/unciv/logic/map/tile/Tile;", "spreadCoast", "spawnLakesAndCoasts", "spreadAncientRuins", "spreadResources", "tileMap", "spreadStrategicResources", "mapRadius", "", "resourceType", "Lcom/unciv/models/ruleset/tile/ResourceType;", "applyHumidityAndTemperature", "getTileRadius", "", "tile", "getTemperatureAtRadius", "", "radius", "scaleToRange", "x1", "x2", "y1", "y2", "value", "spawnVegetation", "spawnRareFeatures", "spawnIce", "spawnFlatEarthIceWalls", "iceTerrains", "spawnBestIce", "mountainTerrains", "spawnFlatEarthCenterIceWall", "spawnRandomIce", "arcticTerrain", "spawnFlatEarthEdgeIceWall", "arcticTerrains", "Companion", "TerrainOccursRange", "Helpers", "core"})
@SourceDebugExtension(value={"SMAP\nMapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,792:1\n1068#2:793\n777#2:794\n873#2,2:795\n777#2:797\n873#2,2:798\n777#2:800\n873#2,2:801\n777#2:803\n873#2,2:804\n777#2:806\n873#2,2:807\n777#2:809\n873#2,2:810\n777#2:820\n873#2:821\n1807#2,3:822\n874#2:825\n777#2:826\n873#2,2:827\n777#2:829\n873#2,2:830\n777#2:832\n873#2:833\n874#2:836\n1834#2,4:837\n832#2:841\n862#2,2:842\n777#2:844\n873#2,2:845\n777#2:847\n873#2,2:848\n832#2:850\n862#2,2:851\n777#2:853\n873#2:854\n1807#2,3:857\n874#2:860\n1834#2,4:861\n777#2:865\n873#2,2:866\n2469#2,14:868\n777#2:882\n873#2,2:883\n2792#2,3:885\n777#2:888\n873#2,2:889\n1661#2,3:891\n777#2:894\n873#2,2:895\n777#2:897\n873#2,2:898\n777#2:900\n873#2,2:901\n1391#2:903\n1480#2,5:904\n777#2:909\n873#2,2:910\n777#2:912\n873#2,2:913\n777#2:915\n873#2,2:916\n777#2:918\n873#2,2:919\n777#2:921\n873#2,2:922\n1586#2:924\n1661#2,3:925\n231#2,2:928\n777#2:930\n873#2,2:931\n777#2:933\n873#2,2:934\n777#2:936\n873#2,2:937\n777#2:939\n873#2,2:940\n1834#2,4:942\n777#2:946\n873#2,2:947\n777#2:949\n873#2,2:950\n1#3:812\n540#4:813\n525#4,6:814\n2296#5,2:834\n2296#5,2:855\n*S KotlinDebug\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator\n*L\n52#1:793\n54#1:794\n54#1:795,2\n56#1:797\n56#1:798,2\n324#1:800\n324#1:801,2\n348#1:803\n348#1:804,2\n350#1:806\n350#1:807,2\n374#1:809\n374#1:810,2\n402#1:820\n402#1:821\n403#1:822,3\n402#1:825\n409#1:826\n409#1:827,2\n424#1:829\n424#1:830,2\n427#1:832\n427#1:833\n427#1:836\n429#1:837,4\n434#1:841\n434#1:842,2\n435#1:844\n435#1:845,2\n449#1:847\n449#1:848,2\n452#1:850\n452#1:851,2\n453#1:853\n453#1:854\n455#1:857,3\n453#1:860\n457#1:861,4\n464#1:865\n464#1:866,2\n466#1:868,14\n490#1:882\n490#1:883,2\n491#1:885,3\n492#1:888\n492#1:889,2\n492#1:891,3\n537#1:894\n537#1:895,2\n613#1:897\n613#1:898,2\n614#1:900\n614#1:901,2\n615#1:903\n615#1:904,5\n623#1:909\n623#1:910,2\n638#1:912\n638#1:913,2\n641#1:915\n641#1:916,2\n659#1:918\n659#1:919,2\n681#1:921\n681#1:922,2\n683#1:924\n683#1:925,3\n691#1:928,2\n692#1:930\n692#1:931,2\n719#1:933\n719#1:934,2\n730#1:936\n730#1:937,2\n777#1:939\n777#1:940,2\n186#1:942,4\n189#1:946\n189#1:947,2\n196#1:949\n196#1:950,2\n394#1:813\n394#1:814,6\n428#1:834,2\n454#1:855,2\n*E\n"})
public final class MapGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @Nullable
    private final CoroutineScope coroutineScope;
    @NotNull
    private MapGenerationRandomness randomness;
    @NotNull
    private final List<TerrainOccursRange> terrainConditions;
    @NotNull
    private final List<TerrainOccursRange> baseTerrainPicker;
    @NotNull
    private final List<TerrainOccursRange> terrainFeaturePicker;
    private static final boolean consoleTimings = false;

    public MapGenerator(@NotNull Ruleset ruleset, @Nullable CoroutineScope coroutineScope) {
        TerrainOccursRange it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.ruleset = ruleset;
        this.coroutineScope = coroutineScope;
        this.randomness = new MapGenerationRandomness();
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$sortedBy$iv = SequencesKt.toList(SequencesKt.flatMap(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), MapGenerator::terrainConditions$lambda$0), arg_0 -> MapGenerator.terrainConditions$lambda$1(this, arg_0)));
        boolean $i$f$sortedBy = false;
        this.terrainConditions = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                TerrainOccursRange it = (TerrainOccursRange)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.isConstrained());
                it = (TerrainOccursRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.isConstrained());
            }
        });
        $this$sortedBy$iv = this.terrainConditions;
        MapGenerator mapGenerator = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getTerrain().getType() == TerrainType.Land || it.getTerrain().getType() == TerrainType.Water)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mapGenerator.baseTerrainPicker = (List)destination$iv$iv;
        $this$filter$iv = this.terrainConditions;
        mapGenerator = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getTerrain().getType() == TerrainType.TerrainFeature)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mapGenerator.terrainFeaturePicker = (List)destination$iv$iv;
    }

    public /* synthetic */ MapGenerator(Ruleset ruleset, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineScope = null;
        }
        this(ruleset, coroutineScope);
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    private final Sequence<TerrainOccursRange> getGenerationConditions(Terrain $this$getGenerationConditions) {
        return SequencesKt.ifEmpty(SequencesKt.map(IHasUniques.getMatchingUniques$default($this$getGenerationConditions, UniqueType.TileGenerationConditions, null, 2, null), arg_0 -> MapGenerator.getGenerationConditions$lambda$0($this$getGenerationConditions, arg_0)), () -> MapGenerator.getGenerationConditions$lambda$1($this$getGenerationConditions));
    }

    @NotNull
    public final TileMap generateMap(@NotNull MapParameters mapParameters, @NotNull GameParameters gameParameters, @NotNull List<Civilization> civilizations) {
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
        Intrinsics.checkNotNullParameter(civilizations, "civilizations");
        MapSize mapSize = mapParameters.getMapSize();
        String mapType = mapParameters.getType();
        if (mapParameters.getSeed() == 0L) {
            mapParameters.setSeed(System.currentTimeMillis());
        }
        this.randomness.seedRNG(mapParameters.getSeed());
        TileMap map2 = Intrinsics.areEqual(mapParameters.getShape(), "Rectangular") ? new TileMap(mapSize.getWidth(), mapSize.getHeight(), this.ruleset, mapParameters.getWorldWrap()) : new TileMap(mapSize.getRadius(), this.ruleset, mapParameters.getWorldWrap());
        mapParameters.setCreatedWithVersion(UncivGame.Companion.getVERSION().toSerializeString());
        map2.setMapParameters(mapParameters);
        if (Intrinsics.areEqual(mapType, "Empty")) {
            for (Tile tile : map2.getValues()) {
                tile.setBaseTerrain("Ocean");
                tile.setTerrainTransients();
            }
            return map2;
        }
        this.runAndMeasure("MapLandmassGenerator", () -> MapGenerator.generateMap$lambda$0(map2, this));
        this.runAndMeasure("applyHumidityAndTemperature", () -> MapGenerator.generateMap$lambda$1(this, map2));
        this.runAndMeasure("raiseMountainsAndHills", () -> MapGenerator.generateMap$lambda$2(map2, this));
        this.runAndMeasure("spawnLakesAndCoasts", () -> MapGenerator.generateMap$lambda$3(this, map2));
        this.runAndMeasure("spawnVegetation", () -> MapGenerator.generateMap$lambda$4(this, map2));
        this.runAndMeasure("spawnRareFeatures", () -> MapGenerator.generateMap$lambda$5(this, map2));
        this.runAndMeasure("spawnIce", () -> MapGenerator.generateMap$lambda$6(this, map2));
        this.runAndMeasure("assignContinents", () -> MapGenerator.generateMap$lambda$7(map2));
        this.runAndMeasure("RiverGenerator", () -> MapGenerator.generateMap$lambda$8(map2, this));
        this.convertTerrains((Iterable<Tile>)map2.getValues());
        if (!((Collection)civilizations).isEmpty()) {
            MapRegions regions = new MapRegions(this.ruleset);
            this.runAndMeasure("generateRegions", () -> MapGenerator.generateMap$lambda$9(regions, map2, civilizations, this));
            this.runAndMeasure("assignRegions", () -> MapGenerator.generateMap$lambda$10(regions, map2, civilizations, gameParameters, this));
            this.runAndMeasure("NaturalWonderGenerator", () -> MapGenerator.generateMap$lambda$11(this, map2));
            this.runAndMeasure("placeResourcesAndMinorCivs", () -> MapGenerator.generateMap$lambda$12(regions, map2, civilizations, this));
        } else {
            this.runAndMeasure("NaturalWonderGenerator", () -> MapGenerator.generateMap$lambda$13(this, map2));
            this.runAndMeasure("spreadResources", () -> MapGenerator.generateMap$lambda$14(this, map2));
        }
        this.runAndMeasure("spreadAncientRuins", () -> MapGenerator.generateMap$lambda$15(this, map2));
        this.mirror(map2);
        for (Tile tile : map2.getValues()) {
            TileNormalizer.INSTANCE.normalizeToRuleset(tile, this.ruleset);
        }
        return map2;
    }

    public static /* synthetic */ TileMap generateMap$default(MapGenerator mapGenerator, MapParameters mapParameters, GameParameters gameParameters, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            gameParameters = new GameParameters();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return mapGenerator.generateMap(mapParameters, gameParameters, list2);
    }

    private final Vector2 flipTopBottom(Vector2 vector) {
        return new Vector2(-vector.y, -vector.x);
    }

    private final HexCoord flipTopBottom(HexCoord vector) {
        return HexCoord.Companion.of(-vector.getY(), -vector.getX());
    }

    private final Vector2 flipLeftRight(Vector2 vector) {
        return new Vector2(vector.y, vector.x);
    }

    private final HexCoord flipLeftRight(HexCoord vector) {
        return HexCoord.Companion.of(vector.getY(), vector.getX());
    }

    private final void mirror(TileMap map2) {
        if (Intrinsics.areEqual(map2.getMapParameters().getMirroring(), "None")) {
            return;
        }
        for (Tile tile : map2.getValues()) {
            MapGenerator.mirror$copyTile(this, map2, tile, map2.getMapParameters().getMirroring());
        }
    }

    public final void generateSingleStep(@NotNull TileMap map2, @NotNull MapGeneratorSteps step) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter((Object)step, "step");
        if (map2.getMapParameters().getSeed() == 0L) {
            map2.getMapParameters().setSeed(System.currentTimeMillis());
        }
        this.randomness.seedRNG(map2.getMapParameters().getSeed());
        this.runAndMeasure("SingleStep " + (Object)((Object)step), () -> MapGenerator.generateSingleStep$lambda$0(step, map2, this));
    }

    private final void runAndMeasure(String text2, Function0<Unit> action2) {
        CoroutineScope coroutineScope = this.coroutineScope;
        boolean bl = coroutineScope != null ? !CoroutineScopeKt.isActive(coroutineScope) : false;
        if (bl) {
            return;
        }
        action2.invoke();
    }

    public final void convertTerrains(@NotNull Iterable<Tile> tiles) {
        Intrinsics.checkNotNullParameter(tiles, "tiles");
        Helpers.INSTANCE.convertTerrains(this.ruleset, tiles);
    }

    /*
     * WARNING - void declaration
     */
    private final void spreadCoast(TileMap map2) {
        int i = 1;
        int n = map2.getMapParameters().getMaxCoastExtension();
        if (i <= n) {
            while (true) {
                void $this$filterTo$iv$iv;
                List toCoast = new ArrayList();
                Iterable $this$filter$iv = map2.getValues();
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Tile it = (Tile)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getBaseTerrain(), "Ocean")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                block2: for (Tile tile : (List)destination$iv$iv) {
                    Sequence<Tile> tilesInDistance = tile.getTilesInDistance(1);
                    object = tilesInDistance.iterator();
                    while (object.hasNext()) {
                        Tile neighborTile = (Tile)object.next();
                        if (neighborTile.isLand()) {
                            toCoast.add(tile);
                            continue block2;
                        }
                        if (!Intrinsics.areEqual(neighborTile.getBaseTerrain(), "Coast")) continue;
                        boolean randbool = this.randomness.getRNG().nextBoolean();
                        if (!randbool) continue block2;
                        toCoast.add(tile);
                        continue block2;
                    }
                }
                for (Object e : toCoast) {
                    Tile tile;
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    tile = (Tile)e;
                    tile.setBaseTerrain("Coast");
                    tile.setTransients();
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnLakesAndCoasts(TileMap map2) {
        if (this.ruleset.getTerrains().containsKey("Lakes")) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = this.terrainConditions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!(it.getFreshWater() && !it.getRareFeature() && it.getTerrain().getType() == TerrainType.Water)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List lakeTerrains = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = map2.getValues();
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Tile it = (Tile)element$iv$iv;
                boolean bl = false;
                if (!it.isWater()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List waterTiles = CollectionsKt.toMutableList((List)destination$iv$iv2);
            ArrayList tilesInArea = new ArrayList();
            ArrayList tilesToCheck = new ArrayList();
            int maxLakeSize = this.ruleset.getModOptions().getConstants().getMaxLakeSize();
            while (!((Collection)waterTiles).isEmpty()) {
                Collection collection;
                void $this$filterTo$iv$iv3;
                Tile initialWaterTile = (Tile)waterTiles.remove(0);
                ((Collection)tilesInArea).add(initialWaterTile);
                ((Collection)tilesToCheck).add(initialWaterTile);
                while (!((Collection)tilesToCheck).isEmpty()) {
                    Object element$iv$iv;
                    Object e = tilesToCheck.remove(0);
                    Intrinsics.checkNotNullExpressionValue(e, "removeAt(...)");
                    Tile tileWeAreChecking = (Tile)e;
                    element$iv$iv = tileWeAreChecking.getNeighbors().iterator();
                    while (element$iv$iv.hasNext()) {
                        Tile vector = (Tile)element$iv$iv.next();
                        if (tilesInArea.contains(vector) || !waterTiles.contains(vector)) continue;
                        ((Collection)tilesInArea).add(vector);
                        ((Collection)tilesToCheck).add(vector);
                        ((Collection)waterTiles).remove(vector);
                    }
                }
                Iterable $this$filter$iv3 = lakeTerrains;
                boolean $i$f$filter3 = false;
                Iterable it = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    TerrainOccursRange it2 = (TerrainOccursRange)element$iv$iv;
                    boolean bl = false;
                    if (!it2.matches(initialWaterTile)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                Object object = (List)destination$iv$iv3;
                if (object.isEmpty()) {
                    boolean bl = false;
                    collection = lakeTerrains;
                } else {
                    collection = object;
                }
                TerrainOccursRange lakeTerrain = (TerrainOccursRange)CollectionsKt.random(collection, this.randomness.getRNG());
                if (tilesInArea.size() <= maxLakeSize) {
                    Iterator iterator2 = tilesInArea.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                    object = iterator2;
                    while (object.hasNext()) {
                        Object e = object.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        Tile tile = (Tile)e;
                        tile.setBaseTerrain(lakeTerrain.getName());
                        tile.setTransients();
                    }
                }
                tilesInArea.clear();
            }
        }
        if (this.ruleset.getTerrains().containsKey("Coast")) {
            this.spreadCoast(map2);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void spreadAncientRuins(TileMap map) {
        $this$filter$iv = this.ruleset.getTileImprovements();
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            it = element$iv$iv;
            $i$a$-filter-MapGenerator$spreadAncientRuins$ruinsEquivalents$1 = false;
            if (!TileImprovement.isAncientRuinsEquivalent$default((TileImprovement)it.getValue(), null, 1, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        ruinsEquivalents = destination$iv$iv;
        if (map.getMapParameters().getNoRuins() || ruinsEquivalents.isEmpty()) {
            return;
        }
        $this$filter$iv = map.getValues();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block10: {
                it = (Tile)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadAncientRuins$suitableTiles$1 = false;
                if (!it.isLand() || it.isImpassible()) ** GOTO lbl-1000
                $this$any$iv = ruinsEquivalents.values();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        improvement = (TileImprovement)element$iv;
                        $i$a$-any-MapGenerator$spreadAncientRuins$suitableTiles$1$1 = false;
                        if (!MapGenerator.spreadAncientRuins$isPlaceable(improvement, it)) continue;
                        v0 = true;
                        break block10;
                    }
                    v0 = false;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv /* !! */ .add(element$iv$iv);
        }
        suitableTiles = (List)destination$iv$iv /* !! */ ;
        locations = this.randomness.chooseSpreadOutLocations(MathKt.roundToInt((float)suitableTiles.size() * this.ruleset.getModOptions().getConstants().getAncientRuinCountMultiplier()), suitableTiles, map.getMapParameters().getMapSize().getRadius());
        v2 = locations.iterator();
        Intrinsics.checkNotNullExpressionValue(v2, "iterator(...)");
        var5_7 = v2;
        while (var5_7.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(var5_7.next(), "next(...)");
            destination$iv$iv /* !! */  = ruinsEquivalents.values();
            var19_29 = tile;
            $i$f$filter = false;
            element$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileImprovement)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadAncientRuins$1 = false;
                if (!MapGenerator.spreadAncientRuins$isPlaceable(it, tile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var19_29.setImprovement(((TileImprovement)CollectionsKt.random((List)destination$iv$iv, Random.Default)).getName());
        }
    }

    private final void spreadResources(TileMap tileMap) {
        int mapRadius = tileMap.getMapParameters().getMapSize().getRadius();
        for (Tile tile : tileMap.getValues()) {
            tile.setTileResource(null);
        }
        this.spreadStrategicResources(tileMap, mapRadius);
        this.spreadResources(tileMap, mapRadius, ResourceType.Luxury);
        this.spreadResources(tileMap, mapRadius, ResourceType.Bonus);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void spreadStrategicResources(TileMap tileMap, int mapRadius) {
        v0 = this.ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var6_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-MapGenerator$spreadStrategicResources$strategicResources$1 = false;
            if (!(it.getResourceType() == ResourceType.Strategic)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        strategicResources = (List)destination$iv$iv;
        $this$filter$iv = tileMap.getValues();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block12: {
                it = (Tile)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadStrategicResources$candidateTiles$1 = false;
                if (it.getResource() != null || it.isImpassible()) ** GOTO lbl-1000
                $this$none$iv = it.getNeighbors();
                $i$f$none = false;
                var16_36 = $this$none$iv.iterator();
                while (var16_36.hasNext()) {
                    neighbor = element$iv = var16_36.next();
                    $i$a$-none-MapGenerator$spreadStrategicResources$candidateTiles$1$1 = false;
                    if (!neighbor.isNaturalWonder()) continue;
                    v1 = false;
                    break block12;
                }
                v1 = true;
            }
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        candidateTiles = (List)destination$iv$iv;
        $this$count$iv = candidateTiles;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v3 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (Tile)element$iv /* !! */ ;
                $i$a$-count-MapGenerator$spreadStrategicResources$totalNumberOfResources$1 = false;
                if (!it.isLand() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v3 = count$iv;
        }
        totalNumberOfResources = (float)v3 * tileMap.getMapParameters().getResourceRichness();
        resourcesPerType = (int)(totalNumberOfResources / (float)strategicResources.size());
        for (E v4 : strategicResources) {
            Intrinsics.checkNotNullExpressionValue(v4, "next(...)");
            resource = (TileResource)v4;
            element$iv /* !! */  = candidateTiles;
            $i$f$filterNot = false;
            $i$a$-count-MapGenerator$spreadStrategicResources$totalNumberOfResources$1 = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filterNot-MapGenerator$spreadStrategicResources$suitableTiles$1 = false;
                if (Intrinsics.areEqual(it.getBaseTerrain(), "Snow") != false && it.isHill() != false) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterNotTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadStrategicResources$suitableTiles$2 = false;
                if (!(it.getResource() == null && resource.generatesNaturallyOn(it) != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            suitableTiles = (List)destination$iv$iv;
            locations = this.randomness.chooseSpreadOutLocations(resourcesPerType, suitableTiles, mapRadius);
            Intrinsics.checkNotNullExpressionValue(locations.iterator(), "iterator(...)");
            while (var11_23.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(var11_23.next(), "next(...)");
                Tile.setTileResource$default(location, resource, null, this.randomness.getRNG(), 2, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void spreadResources(TileMap tileMap, int mapRadius, ResourceType resourceType) {
        v0 = this.ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var7_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-MapGenerator$spreadResources$resourcesOfType$1 = false;
            if (!(it.getResourceType() == resourceType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        resourcesOfType = (List)destination$iv$iv;
        $i$f$filter = tileMap.getValues();
        $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (E element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filterNot-MapGenerator$spreadResources$suitableTiles$1 = false;
            if (Intrinsics.areEqual(it.getBaseTerrain(), "Snow") != false && it.isHill() != false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block20: {
                block19: {
                    it = (Tile)element$iv$iv;
                    $i$a$-filter-MapGenerator$spreadResources$suitableTiles$2 = false;
                    if (it.getResource() != null) ** GOTO lbl-1000
                    $this$none$iv = it.getNeighbors();
                    $i$f$none = false;
                    var17_39 = $this$none$iv.iterator();
                    while (var17_39.hasNext()) {
                        neighbor = element$iv = var17_39.next();
                        $i$a$-none-MapGenerator$spreadResources$suitableTiles$2$1 = false;
                        if (!neighbor.isNaturalWonder()) continue;
                        v1 = false;
                        break block19;
                    }
                    v1 = true;
                }
                if (!v1) ** GOTO lbl-1000
                $this$any$iv = resourcesOfType;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Tile element$iv : $this$any$iv) {
                        r = (TileResource)element$iv;
                        $i$a$-any-MapGenerator$spreadResources$suitableTiles$2$2 = false;
                        if (!r.generatesNaturallyOn(it)) continue;
                        v2 = true;
                        break block20;
                    }
                    v2 = false;
                }
            }
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        suitableTiles = (List)destination$iv$iv;
        $this$count$iv = tileMap.getValues();
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v4 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (Tile)element$iv;
                $i$a$-count-MapGenerator$spreadResources$numberOfResources$1 = false;
                if (!(it.isLand() != false && it.isImpassible() == false) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v4 = count$iv;
        }
        numberOfResources = (float)v4 * tileMap.getMapParameters().getResourceRichness();
        locations = this.randomness.chooseSpreadOutLocations((int)numberOfResources, suitableTiles, mapRadius);
        resourceToNumber = new Counter<String>(null, 1, null);
        v5 = locations.iterator();
        Intrinsics.checkNotNullExpressionValue(v5, "iterator(...)");
        var9_17 = v5;
        while (var9_17.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(var9_17.next(), "next(...)");
            $this$filter$iv = resourcesOfType;
            $i$f$filter = false;
            $i$a$-filter-MapGenerator$spreadResources$suitableTiles$2 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileResource)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadResources$possibleResources$1 = false;
                if (!it.generatesNaturallyOn(tile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            possibleResources = (List)destination$iv$iv;
            if (possibleResources.isEmpty()) continue;
            $this$minByOrNull$iv = possibleResources;
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v6 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v6 = minElem$iv;
                } else {
                    it = (TileResource)minElem$iv;
                    $i$a$-minByOrNull-MapGenerator$spreadResources$resourceWithLeastAssignments$1 = false;
                    minValue$iv = ((Number)resourceToNumber.get(it.getName())).intValue();
                    do {
                        e$iv = iterator$iv.next();
                        it = (TileResource)e$iv;
                        $i$a$-minByOrNull-MapGenerator$spreadResources$resourceWithLeastAssignments$1 = false;
                        v$iv = ((Number)resourceToNumber.get(it.getName())).intValue();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v6 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v6);
            resourceWithLeastAssignments = v6;
            resourceToNumber.add(resourceWithLeastAssignments.getName(), 1);
            Tile.setTileResource$default(tile, resourceWithLeastAssignments, null, this.randomness.getRNG(), 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyHumidityAndTemperature(TileMap tileMap) {
        void destination$iv;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        boolean bl;
        List landTerrains;
        Object it;
        float humidityShift;
        float temperatureShift;
        float temperatureintensity;
        double scale;
        double temperatureSeed;
        double humiditySeed;
        block18: {
            void $this$filterTo$iv$iv2;
            humiditySeed = this.randomness.getRNG().nextInt();
            temperatureSeed = this.randomness.getRNG().nextInt();
            TileMap.setTransients$default(tileMap, this.ruleset, false, 2, null);
            scale = tileMap.getMapParameters().getTilesPerBiomeArea();
            temperatureintensity = tileMap.getMapParameters().getTemperatureintensity();
            temperatureShift = tileMap.getMapParameters().getTemperatureShift();
            humidityShift = temperatureShift > 0.0f ? -temperatureShift / (float)2 : 0.0f;
            Iterable $this$filter$iv = this.baseTerrainPicker;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (TerrainOccursRange)element$iv$iv;
                boolean bl2 = false;
                if (!(((TerrainOccursRange)it).getTerrain().getType() == TerrainType.Land && !((TerrainOccursRange)it).getRareFeature())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            landTerrains = (List)destination$iv$iv;
            Iterable $this$none$iv = landTerrains;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    TerrainOccursRange it2 = (TerrainOccursRange)element$iv;
                    boolean bl3 = false;
                    if (!it2.isConstrained()) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        boolean noTerrainUniques = bl;
        Iterable $this$filter$iv = this.baseTerrainPicker;
        boolean $i$f$filter22 = false;
        Iterable element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TerrainOccursRange it3 = (TerrainOccursRange)element$iv$iv;
            boolean bl4 = false;
            if (!it3.getOccursInChains()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection $i$f$filter22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (TerrainOccursRange)item$iv;
            void var36_40 = destination$iv;
            boolean bl5 = false;
            var36_40.add(((TerrainOccursRange)it).getName());
        }
        Set elevationTerrains = (Set)destination$iv;
        Iterator iterator2 = CollectionsKt.asSequence((Iterable)tileMap.getValues()).iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv3;
            Object[] objectArray;
            double d;
            Tile tile = (Tile)iterator2.next();
            if (tile.isWater() || elevationTerrains.contains(tile.getBaseTerrain())) continue;
            double humidityRandom = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, humiditySeed, 1, 0.0, 0.0, scale, 24, null);
            double humidity = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf((humidityRandom + 1.0) / 2.0 + (double)humidityShift), RangesKt.rangeTo(0.0, 1.0))).doubleValue();
            tile.setHumidity(humidity);
            if (Intrinsics.areEqual(tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal")) {
                double radiusTemperature;
                float radius = this.getTileRadius(tile, tileMap);
                d = radiusTemperature = this.getTemperatureAtRadius(radius);
            } else {
                double latitudeTemperature;
                d = latitudeTemperature = 1.0 - 2.0 * (double)Math.abs(tile.getLatitude()) / (double)tileMap.getMaxLatitude();
            }
            double expectedTemperature = d;
            double randomTemperature = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, temperatureSeed, 1, 0.0, 0.0, scale, 24, null);
            double temperature = (5.0 * expectedTemperature + randomTemperature) / 6.0;
            temperature = Math.pow(Math.abs(temperature), 1.0 - (double)temperatureintensity) * Math.signum(temperature);
            temperature = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(temperature + (double)temperatureShift), RangesKt.rangeTo(-1.0, 1.0))).doubleValue();
            tile.setTemperature(temperature);
            if (noTerrainUniques) {
                String string;
                if (temperature < -0.4) {
                    string = humidity < 0.5 ? "Snow" : "Tundra";
                } else if (temperature < 0.8) {
                    string = humidity < 0.5 ? "Plains" : "Grassland";
                } else if (temperature <= 1.0) {
                    string = humidity < 0.7 ? "Desert" : "Plains";
                } else {
                    objectArray = new Object[]{temperature};
                    LogKt.debug("applyHumidityAndTemperature: Invalid temperature %s", objectArray);
                    continue;
                }
                String autoTerrain = string;
                if (!this.ruleset.getTerrains().containsKey(autoTerrain)) continue;
                tile.setBaseTerrain(autoTerrain);
                tile.setTerrainTransients();
                continue;
            }
            Iterable $this$filter$iv2 = landTerrains;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                TerrainOccursRange it4 = (TerrainOccursRange)element$iv$iv;
                boolean bl6 = false;
                if (!it4.matches(tile)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            TerrainOccursRange matchingTerrain = (TerrainOccursRange)CollectionsKt.randomOrNull((List)destination$iv$iv2, this.randomness.getRNG());
            if (matchingTerrain != null) {
                tile.setBaseTerrain(matchingTerrain.getName());
                tile.setTerrainTransients();
                continue;
            }
            objectArray = new Object[]{temperature, humidity};
            LogKt.debug("applyHumidityAndTemperature: No terrain found for temperature: %s, humidity: %s", objectArray);
        }
    }

    private final float getTileRadius(Tile tile, TileMap tileMap) {
        float latitudeRatio = (float)Math.abs(tile.getLatitude()) / (float)tileMap.getMaxLatitude();
        float longitudeRatio = (float)Math.abs(tile.getLongitude()) / (float)tileMap.getMaxLongitude();
        return (float)Math.sqrt((float)Math.pow(latitudeRatio, 2) + (float)Math.pow(longitudeRatio, 2));
    }

    private final double getTemperatureAtRadius(float radius) {
        return (double)radius < 0.5 ? this.scaleToRange(0.05, 0.5, -1.0, 1.0, radius) : ((double)radius > 0.5 ? this.scaleToRange(0.5, 0.95, 1.0, -1.0, radius) : 1.0);
    }

    private final double scaleToRange(double x1, double x2, double y1, double y2, float value) {
        double gain = (y2 - y1) / (x2 - x1);
        double offset = y2 - gain * x2;
        return gain * (double)value + offset;
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnVegetation(TileMap tileMap) {
        void $this$flatMapTo$iv$iv;
        Iterable iterable;
        void $this$filterTo$iv$iv;
        double vegetationSeed = this.randomness.getRNG().nextInt();
        Iterable $this$filter$iv = this.terrainFeaturePicker;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getHasVegitation() && !it.getRareFeature())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        if ($this$filter$iv.isEmpty()) {
            void $this$filterTo$iv$iv2;
            boolean bl = false;
            Iterable $this$filter$iv2 = this.terrainFeaturePicker;
            boolean $i$f$filter2 = false;
            Iterable $i$f$filterTo2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
                boolean bl2 = false;
                if (!ArraysKt.contains(Constants.INSTANCE.getVegetation(), it.getName())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            iterable = (List)destination$iv$iv2;
        } else {
            iterable = $this$filter$iv;
        }
        List vegetationTerrains = (List)iterable;
        Iterable $this$flatMap$iv = vegetationTerrains;
        boolean $i$f$flatMap = false;
        Iterable $i$f$filter2 = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTerrain().getOccursOn();
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        List candidateTerrains = (List)destination$iv$iv3;
        Iterator<Tile> iterator2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)tileMap.getValues()), arg_0 -> MapGenerator.spawnVegetation$lambda$3(candidateTerrains, arg_0)).iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv3;
            Tile tile = iterator2.next();
            double vegetation = (MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, vegetationSeed, 1, 0.0, 0.0, 3.0, 24, null) + 1.0) / 2.0;
            if (!(vegetation <= (double)tileMap.getMapParameters().getVegetationRichness())) continue;
            Iterable $this$filter$iv3 = vegetationTerrains;
            boolean $i$f$filter3 = false;
            Iterable list$iv$iv = $this$filter$iv3;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!(it.matches(tile) && NaturalWonderGenerator.Companion.fitsTerrainUniques(it.getTerrain(), tile))) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List possibleVegetation = (List)destination$iv$iv4;
            if (possibleVegetation.isEmpty()) continue;
            TerrainOccursRange randomVegetation = (TerrainOccursRange)CollectionsKt.random(possibleVegetation, this.randomness.getRNG());
            tile.setHasVegetation(true);
            tile.addTerrainFeature(randomVegetation.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnRareFeatures(TileMap tileMap) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.terrainFeaturePicker;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!it.getRareFeature()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rareFeatures = (List)destination$iv$iv;
        Iterator<Tile> iterator2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)tileMap.getValues()), MapGenerator::spawnRareFeatures$lambda$1).iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv2;
            Tile tile = iterator2.next();
            if (!(this.randomness.getRNG().nextDouble() <= (double)tileMap.getMapParameters().getRareFeaturesRichness())) continue;
            Iterable $this$filter$iv2 = rareFeatures;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!(it.matches(tile) && (!tile.isHill() || it.getTerrain().getOccursOn().contains("Hill")) && NaturalWonderGenerator.Companion.fitsTerrainUniques(it.getTerrain(), tile))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List possibleFeatures = (List)destination$iv$iv2;
            if (!CollectionsKt.any(possibleFeatures)) continue;
            tile.addTerrainFeature(((TerrainOccursRange)CollectionsKt.random(possibleFeatures, this.randomness.getRNG())).getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnIce(TileMap tileMap) {
        void $this$filterTo$iv$iv;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Set<String> waterTerrain = SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), MapGenerator::spawnIce$lambda$0), MapGenerator::spawnIce$lambda$1));
        Iterable $this$filter$iv = this.terrainFeaturePicker;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!it.matchesIce()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List iceTerrains = (List)destination$iv$iv;
        if (Intrinsics.areEqual(tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal")) {
            this.spawnFlatEarthIceWalls(tileMap, iceTerrains);
        }
        if (iceTerrains.isEmpty()) {
            return;
        }
        TileMap.setTransients$default(tileMap, this.ruleset, false, 2, null);
        double temperatureSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : tileMap.getValues()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            TerrainOccursRange it;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            if (!waterTerrain.contains(tile.getBaseTerrain()) || !((Collection)tile.getTerrainFeatures()).isEmpty()) continue;
            MapGenerationRandomness element$iv$iv = this.randomness;
            double d = tileMap.getMapParameters().getTilesPerBiomeArea();
            double randomTemperature = MapGenerationRandomness.getPerlinNoise$default(element$iv$iv, tile, temperatureSeed, 1, 0.0, 0.0, d, 24, null);
            double latitudeTemperature = 1.0 - 2.0 * (double)Math.abs(tile.getLatitude()) / (double)tileMap.getMaxLatitude();
            double iceTemperature = 0.0;
            iceTemperature = (latitudeTemperature + randomTemperature) / 2.0;
            iceTemperature = Math.pow(Math.abs(iceTemperature), 1.0 - (double)tileMap.getMapParameters().getTemperatureintensity()) * Math.signum(iceTemperature);
            iceTemperature = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(iceTemperature + (double)tileMap.getMapParameters().getTemperatureShift()), RangesKt.rangeTo(-1.0, 1.0))).doubleValue();
            Iterable iterable2 = iceTerrains;
            boolean $i$f$filter2 = false;
            void var16_21 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                it = (TerrainOccursRange)element$iv$iv2;
                boolean bl = false;
                if (!(it.matches(tile, iceTemperature) && NaturalWonderGenerator.Companion.fitsTerrainUniques(it.getTerrain(), tile))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TerrainOccursRange)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl = false;
                collection2.add(it.getTerrain().getName());
            }
            String iceTerrain = (String)CollectionsKt.randomOrNull((List)destination$iv$iv2, this.randomness.getRNG());
            if (iceTerrain == null) continue;
            tile.addTerrainFeature(iceTerrain);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnFlatEarthIceWalls(TileMap tileMap, List<TerrainOccursRange> iceTerrains) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        block5: {
            Iterable $this$first$iv = this.baseTerrainPicker;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                TerrainOccursRange it = (TerrainOccursRange)element$iv2;
                boolean bl = false;
                if (!(it.getTerrain().getType() == TerrainType.Land && it.getTempFrom() <= -1.0f && it.getHumidTo() >= 1.0f && !it.getRareFeature())) continue;
                break block5;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        List snowTerrains = CollectionsKt.listOf(element$iv2);
        Iterable $this$filter$iv = this.baseTerrainPicker;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getTerrain().getImpassable() && it.getOccursInChains() && !it.getRareFeature())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mountainTerrains = (List)destination$iv$iv;
        List<TerrainOccursRange> allArcticTerrains = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)iceTerrains, (Iterable)snowTerrains), (Iterable)mountainTerrains);
        if (allArcticTerrains.isEmpty()) {
            return;
        }
        for (Tile tile : tileMap.getValues()) {
            boolean isEdgeTile;
            boolean isCenterTile = tile.getLatitude() == 0 && tile.getLongitude() == 0;
            boolean bl = isEdgeTile = SequencesKt.count(tile.getNeighbors()) < 6;
            if (isCenterTile) {
                this.spawnFlatEarthCenterIceWall(tile, iceTerrains, mountainTerrains);
            }
            if (!isEdgeTile) continue;
            this.spawnFlatEarthEdgeIceWall(tile, allArcticTerrains, iceTerrains);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnBestIce(Tile tile, List<TerrainOccursRange> iceTerrains, List<TerrainOccursRange> mountainTerrains) {
        TerrainOccursRange ice;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = iceTerrains;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!it.matches(tile, -1.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        TerrainOccursRange terrainOccursRange = (TerrainOccursRange)CollectionsKt.randomOrNull((List)destination$iv$iv, this.randomness.getRNG());
        if (terrainOccursRange == null) {
            terrainOccursRange = (TerrainOccursRange)CollectionsKt.randomOrNull((Collection)iceTerrains, this.randomness.getRNG());
        }
        if ((ice = terrainOccursRange) != null) {
            if (!ice.matches(tile, -1.0)) {
                tile.setBaseTerrain("Ocean");
            }
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(ice.getTerrain().getName());
            tile.setTerrainTransients();
        } else {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = mountainTerrains;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!it.matches(tile, -1.0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            TerrainOccursRange terrainOccursRange2 = (TerrainOccursRange)CollectionsKt.randomOrNull((List)destination$iv$iv2, this.randomness.getRNG());
            if (terrainOccursRange2 == null) {
                terrainOccursRange2 = (TerrainOccursRange)CollectionsKt.random((Collection)mountainTerrains, this.randomness.getRNG());
            }
            TerrainOccursRange mountain = terrainOccursRange2;
            tile.setBaseTerrain(mountain.getTerrain().getName());
            tile.removeTerrainFeatures();
        }
        tile.setTerrainTransients();
    }

    private final void spawnFlatEarthCenterIceWall(Tile tile, List<TerrainOccursRange> iceTerrains, List<TerrainOccursRange> mountainTerrains) {
        this.spawnBestIce(tile, iceTerrains, mountainTerrains);
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            this.spawnBestIce(neighbor, iceTerrains, mountainTerrains);
            Iterator<Tile> iterator3 = neighbor.getNeighbors().iterator();
            while (iterator3.hasNext()) {
                Tile neighbor2 = iterator3.next();
                if (!(this.randomness.getRNG().nextDouble() > 0.75)) continue;
                this.spawnBestIce(neighbor2, iceTerrains, mountainTerrains);
            }
        }
    }

    private final void spawnRandomIce(Tile tile, TerrainOccursRange arcticTerrain, List<TerrainOccursRange> iceTerrains) {
        tile.removeTerrainFeatures();
        if (arcticTerrain.getTerrain().getType() == TerrainType.Land && arcticTerrain.getTerrain().getImpassable()) {
            tile.setBaseTerrain(arcticTerrain.getTerrain().getName());
        } else if (arcticTerrain.getTerrain().getType() == TerrainType.Land) {
            tile.setBaseTerrain(arcticTerrain.getTerrain().getName());
            tile.addTerrainFeature(((TerrainOccursRange)CollectionsKt.random((Collection)iceTerrains, this.randomness.getRNG())).getTerrain().getName());
        } else if (arcticTerrain.getTerrain().getType() == TerrainType.TerrainFeature && arcticTerrain.matches(tile)) {
            tile.addTerrainFeature(arcticTerrain.getTerrain().getName());
        } else {
            tile.setBaseTerrain("Ocean");
            tile.addTerrainFeature(arcticTerrain.getTerrain().getName());
        }
        tile.setTerrainTransients();
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnFlatEarthEdgeIceWall(Tile tile, List<TerrainOccursRange> arcticTerrains, List<TerrainOccursRange> iceTerrains) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = arcticTerrains;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TerrainOccursRange it = (TerrainOccursRange)element$iv$iv;
            boolean bl = false;
            if (!it.matches(tile, -1.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        TerrainOccursRange terrainOccursRange = (TerrainOccursRange)CollectionsKt.randomOrNull((List)destination$iv$iv, this.randomness.getRNG());
        if (terrainOccursRange == null) {
            terrainOccursRange = (TerrainOccursRange)CollectionsKt.random((Collection)arcticTerrains, this.randomness.getRNG());
        }
        TerrainOccursRange arcticTerrain = terrainOccursRange;
        this.spawnRandomIce(tile, arcticTerrain, iceTerrains);
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            boolean neighborIsEdgeTile = SequencesKt.count(neighbor.getNeighbors()) < 6;
            if (neighborIsEdgeTile || !(this.randomness.getRNG().nextDouble() >= 0.75)) continue;
            this.spawnRandomIce(tile, arcticTerrain, iceTerrains);
        }
    }

    private static final boolean terrainConditions$lambda$0(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !IHasUniques.hasUnique$default(it, UniqueType.NoNaturalGeneration, null, 2, null);
    }

    private static final Sequence terrainConditions$lambda$1(MapGenerator this$0, Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getGenerationConditions(it);
    }

    private static final TerrainOccursRange getGenerationConditions$lambda$0(Terrain $this_getGenerationConditions, Unique unique) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        return new TerrainOccursRange($this_getGenerationConditions, unique);
    }

    private static final Sequence getGenerationConditions$lambda$1(Terrain $this_getGenerationConditions) {
        return SequencesKt.sequenceOf(new TerrainOccursRange($this_getGenerationConditions));
    }

    private static final Unit generateMap$lambda$0(TileMap $map, MapGenerator this$0) {
        new MapLandmassGenerator($map, this$0.ruleset, this$0.randomness).generateLand();
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$1(MapGenerator this$0, TileMap $map) {
        this$0.applyHumidityAndTemperature($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$2(TileMap $map, MapGenerator this$0) {
        new MapElevationGenerator($map, this$0.ruleset, this$0.terrainConditions, this$0.randomness).raiseMountainsAndHills();
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$3(MapGenerator this$0, TileMap $map) {
        this$0.spawnLakesAndCoasts($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$4(MapGenerator this$0, TileMap $map) {
        this$0.spawnVegetation($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$5(MapGenerator this$0, TileMap $map) {
        this$0.spawnRareFeatures($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$6(MapGenerator this$0, TileMap $map) {
        this$0.spawnIce($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$7(TileMap $map) {
        $map.assignContinents(TileMap.AssignContinentsMode.Assign);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$8(TileMap $map, MapGenerator this$0) {
        RiverGenerator.spawnRivers$default(new RiverGenerator($map, this$0.randomness, this$0.ruleset), null, 1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateMap$lambda$9(MapRegions $regions, TileMap $map, List $civilizations, MapGenerator this$0) {
        int n;
        void $this$count$iv;
        Iterable iterable = $civilizations;
        TileMap tileMap = $map;
        MapRegions mapRegions = $regions;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                Nation nation = this$0.ruleset.getNations().get(it.getCivName());
                Intrinsics.checkNotNull(nation);
                if (!nation.isMajorCiv() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = n;
        mapRegions.generateRegions(tileMap, n2);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateMap$lambda$10(MapRegions $regions, TileMap $map, List $civilizations, GameParameters $gameParameters, MapGenerator this$0) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = $civilizations;
        TileMap tileMap = $map;
        MapRegions mapRegions = $regions;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            Nation nation = this$0.ruleset.getNations().get(it.getCivName());
            Intrinsics.checkNotNull(nation);
            if (!nation.isMajorCiv()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        mapRegions.assignRegions(tileMap, list2, $gameParameters);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$11(MapGenerator this$0, TileMap $map) {
        new NaturalWonderGenerator(this$0.ruleset, this$0.randomness).spawnNaturalWonders($map);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateMap$lambda$12(MapRegions $regions, TileMap $map, List $civilizations, MapGenerator this$0) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = $civilizations;
        TileMap tileMap = $map;
        MapRegions mapRegions = $regions;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            Nation nation = this$0.ruleset.getNations().get(it.getCivName());
            Intrinsics.checkNotNull(nation);
            if (!nation.isCityState()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        mapRegions.placeResourcesAndMinorCivs(tileMap, list2);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$13(MapGenerator this$0, TileMap $map) {
        new NaturalWonderGenerator(this$0.ruleset, this$0.randomness).spawnNaturalWonders($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$14(MapGenerator this$0, TileMap $map) {
        this$0.spreadResources($map);
        return Unit.INSTANCE;
    }

    private static final Unit generateMap$lambda$15(MapGenerator this$0, TileMap $map) {
        this$0.spreadAncientRuins($map);
        return Unit.INSTANCE;
    }

    private static final Tile mirror$getMirrorTile(MapGenerator this$0, TileMap $map, Tile tile, String mirroringType) {
        HexCoord hexCoord;
        switch (mirroringType) {
            case "Top-Bottom": {
                if (tile.getRow() <= 0) {
                    return null;
                }
                hexCoord = this$0.flipTopBottom(tile.getPosition());
                break;
            }
            case "Bottom-Top": {
                if (tile.getColumn() <= 0) {
                    return null;
                }
                hexCoord = this$0.flipLeftRight(tile.getPosition());
                break;
            }
            case "Around Center Tile": {
                if (tile.getRow() <= 0) {
                    return null;
                }
                hexCoord = this$0.flipLeftRight(this$0.flipTopBottom(tile.getPosition()));
                break;
            }
            case "4-way": {
                if (tile.getRow() < 0 && tile.getColumn() < 0) {
                    return null;
                }
                if (tile.getRow() < 0 && tile.getColumn() >= 0) {
                    hexCoord = this$0.flipLeftRight(tile.getPosition());
                    break;
                }
                if (tile.getRow() >= 0 && tile.getColumn() < 0) {
                    hexCoord = this$0.flipTopBottom(tile.getPosition());
                    break;
                }
                hexCoord = this$0.flipLeftRight(this$0.flipTopBottom(tile.getPosition()));
                break;
            }
            default: {
                return null;
            }
        }
        HexCoord mirrorTileVector = hexCoord;
        return $map.getIfTileExistsOrNull(mirrorTileVector.getX(), mirrorTileVector.getY());
    }

    private static final void mirror$copyTile(MapGenerator this$0, TileMap $map, Tile tile, String mirroringType) {
        Tile tile2 = MapGenerator.mirror$getMirrorTile(this$0, $map, tile, mirroringType);
        if (tile2 == null) {
            return;
        }
        Tile mirrorTile = tile2;
        tile.setBaseTerrain(mirrorTile.getBaseTerrain());
        tile.setNaturalWonder(mirrorTile.getNaturalWonder());
        tile.setTerrainFeatures(mirrorTile.getTerrainFeatures());
        tile.setTileResource(mirrorTile.getTileResource());
        tile.setImprovement(mirrorTile.getImprovement());
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighborMirror;
            Tile neighbor = iterator2.next();
            if (MapGenerator.mirror$getMirrorTile(this$0, $map, neighbor, mirroringType) == null || !SequencesKt.contains(mirrorTile.getNeighbors(), neighborMirror)) continue;
            Tile.setConnectedByRiver$default(tile, neighbor, mirrorTile.isConnectedByRiver(neighborMirror), false, 4, null);
        }
    }

    private static final Unit generateSingleStep$lambda$0(MapGeneratorSteps $step, TileMap $map, MapGenerator this$0) {
        switch (WhenMappings.$EnumSwitchMapping$0[$step.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalArgumentException("MapGeneratorSteps.All cannot be used in generateSingleStep");
            }
            case 3: {
                new MapLandmassGenerator($map, this$0.ruleset, this$0.randomness).generateLand();
                break;
            }
            case 4: {
                this$0.applyHumidityAndTemperature($map);
                break;
            }
            case 5: {
                new MapElevationGenerator($map, this$0.ruleset, this$0.terrainConditions, this$0.randomness).raiseMountainsAndHills();
                break;
            }
            case 6: {
                this$0.spawnLakesAndCoasts($map);
                break;
            }
            case 7: {
                this$0.spawnVegetation($map);
                break;
            }
            case 8: {
                this$0.spawnRareFeatures($map);
                break;
            }
            case 9: {
                this$0.spawnIce($map);
                break;
            }
            case 10: {
                $map.assignContinents(TileMap.AssignContinentsMode.Reassign);
                break;
            }
            case 11: {
                new NaturalWonderGenerator(this$0.ruleset, this$0.randomness).spawnNaturalWonders($map);
                break;
            }
            case 12: {
                Set resultingTiles = new LinkedHashSet();
                new RiverGenerator($map, this$0.randomness, this$0.ruleset).spawnRivers(resultingTiles);
                this$0.convertTerrains(resultingTiles);
                break;
            }
            case 13: {
                this$0.spreadResources($map);
                break;
            }
            case 14: {
                this$0.spreadAncientRuins($map);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean spreadAncientRuins$isPlaceable(TileImprovement improvement, Tile tile) {
        return TileImprovementFunctions.canImprovementBeBuiltHere$core$default(tile.getImprovementFunctions(), improvement, false, null, GameContext.Companion.getIgnoreConditionals(), false, 22, null);
    }

    private static final boolean spawnVegetation$lambda$3(List $candidateTerrains, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $candidateTerrains.contains(it.getBaseTerrain()) && $candidateTerrains.contains(it.getLastTerrain().getName());
    }

    private static final boolean spawnRareFeatures$lambda$1(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTerrainFeatures().isEmpty();
    }

    private static final boolean spawnIce$lambda$0(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == TerrainType.Water;
    }

    private static final String spawnIce$lambda$1(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$Companion;", "", "<init>", "()V", "consoleTimings", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$Helpers;", "", "<init>", "()V", "convertTerrains", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "tiles", "", "Lcom/unciv/logic/map/tile/Tile;", "core"})
    @SourceDebugExtension(value={"SMAP\nMapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator$Helpers\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,792:1\n184#2,2:793\n*S KotlinDebug\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator$Helpers\n*L\n307#1:793,2\n*E\n"})
    public static final class Helpers {
        @NotNull
        public static final Helpers INSTANCE = new Helpers();

        private Helpers() {
        }

        /*
         * WARNING - void declaration
         */
        public final void convertTerrains(@NotNull Ruleset ruleset, @NotNull Iterable<Tile> tiles) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            Intrinsics.checkNotNullParameter(tiles, "tiles");
            for (Tile tile : tiles) {
                Terrain terrain;
                Unique conversionUnique;
                Object v0;
                block4: {
                    void $this$firstOrNull$iv;
                    Sequence<Unique> sequence = tile.getBaseTerrain().getMatchingUniques(UniqueType.ChangesTerrain, new GameContext(null, null, null, tile, null, null, null, null, null, null, false, 2039, null));
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl = false;
                        if (!Tile.isAdjacentTo$default(tile, it.getParams().get(1), null, 2, null)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                if ((Unique)v0 == null || ruleset.getTerrains().get(conversionUnique.getParams().get(0)) == null) continue;
                if (terrain.getType() != TerrainType.TerrainFeature) {
                    tile.setBaseTerrain(terrain.getName());
                } else {
                    if (!terrain.getOccursOn().contains(tile.getLastTerrain().getName())) continue;
                    tile.addTerrainFeature(terrain.getName());
                }
                tile.setTerrainTransients();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\n2\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\nJ\n\u0010.\u001a\u00020\u001aH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\u001f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0011\u0010!\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0011\u0010#\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0018R\u0011\u0010%\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018\u00a8\u00060"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange;", "", "terrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "tempFrom", "", "tempTo", "humidFrom", "humidTo", "isConstrained", "", "<init>", "(Lcom/unciv/models/ruleset/tile/Terrain;FFFFZ)V", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "(Lcom/unciv/models/ruleset/tile/Terrain;Lcom/unciv/models/ruleset/unique/Unique;)V", "(Lcom/unciv/models/ruleset/tile/Terrain;)V", "getTerrain", "()Lcom/unciv/models/ruleset/tile/Terrain;", "getTempFrom", "()F", "getTempTo", "getHumidFrom", "getHumidTo", "()Z", "name", "", "getName", "()Ljava/lang/String;", "occursInChains", "getOccursInChains", "occursInGroups", "getOccursInGroups", "hasVegitation", "getHasVegitation", "freshWater", "getFreshWater", "rareFeature", "getRareFeature", "matchesBaseTerrain", "tile", "Lcom/unciv/logic/map/tile/Tile;", "matches", "overrideTileTemp", "", "matchesIce", "toString", "Companion", "core"})
    public static final class TerrainOccursRange {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Terrain terrain;
        private final float tempFrom;
        private final float tempTo;
        private final float humidFrom;
        private final float humidTo;
        private final boolean isConstrained;
        private final boolean occursInChains;
        private final boolean occursInGroups;
        private final boolean hasVegitation;
        private final boolean freshWater;
        private final boolean rareFeature;

        public TerrainOccursRange(@NotNull Terrain terrain, float tempFrom, float tempTo, float humidFrom, float humidTo, boolean isConstrained) {
            Intrinsics.checkNotNullParameter(terrain, "terrain");
            this.terrain = terrain;
            this.tempFrom = tempFrom;
            this.tempTo = tempTo;
            this.humidFrom = humidFrom;
            this.humidTo = humidTo;
            this.isConstrained = isConstrained;
            this.occursInChains = IHasUniques.hasUnique$default(this.terrain, UniqueType.OccursInChains, null, 2, null);
            this.occursInGroups = IHasUniques.hasUnique$default(this.terrain, UniqueType.OccursInGroups, null, 2, null);
            this.hasVegitation = IHasUniques.hasUnique$default(this.terrain, UniqueType.Vegetation, null, 2, null);
            this.freshWater = IHasUniques.hasUnique$default(this.terrain, UniqueType.FreshWater, null, 2, null);
            this.rareFeature = IHasUniques.hasUnique$default(this.terrain, UniqueType.RareFeature, null, 2, null);
        }

        @NotNull
        public final Terrain getTerrain() {
            return this.terrain;
        }

        public final float getTempFrom() {
            return this.tempFrom;
        }

        public final float getTempTo() {
            return this.tempTo;
        }

        public final float getHumidFrom() {
            return this.humidFrom;
        }

        public final float getHumidTo() {
            return this.humidTo;
        }

        public final boolean isConstrained() {
            return this.isConstrained;
        }

        @NotNull
        public final String getName() {
            return this.terrain.getName();
        }

        public final boolean getOccursInChains() {
            return this.occursInChains;
        }

        public final boolean getOccursInGroups() {
            return this.occursInGroups;
        }

        public final boolean getHasVegitation() {
            return this.hasVegitation;
        }

        public final boolean getFreshWater() {
            return this.freshWater;
        }

        public final boolean getRareFeature() {
            return this.rareFeature;
        }

        public TerrainOccursRange(@NotNull Terrain terrain, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(terrain, "terrain");
            Intrinsics.checkNotNullParameter(unique, "unique");
            this(terrain, TerrainOccursRange.Companion.toFloatMakeInclusive(unique.getParams().get(0), -1.0f), Float.parseFloat(unique.getParams().get(1)), TerrainOccursRange.Companion.toFloatMakeInclusive(unique.getParams().get(2), 0.0f), Float.parseFloat(unique.getParams().get(3)), true);
        }

        public TerrainOccursRange(@NotNull Terrain terrain) {
            Intrinsics.checkNotNullParameter(terrain, "terrain");
            this(terrain, -3.4028235E38f, Float.MAX_VALUE, -3.4028235E38f, Float.MAX_VALUE, false);
        }

        private final boolean matchesBaseTerrain(Tile tile) {
            return this.terrain.getType() == TerrainType.Water ? tile.getBaseTerrain().getType() == TerrainType.Water && IHasUniques.hasUnique$default(tile.getBaseTerrain(), UniqueType.FreshWater, null, 2, null) == this.freshWater : (this.terrain.getType() == TerrainType.Land ? tile.getBaseTerrain().getType() == TerrainType.Land && IHasUniques.hasUnique$default(tile.getBaseTerrain(), UniqueType.OccursInChains, null, 2, null) == this.occursInChains : this.terrain.getOccursOn().contains(tile.getLastTerrain().getName()));
        }

        public final boolean matches(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Double d = tile.getTemperature();
            return this.matches(tile, d != null ? d : 0.0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean matches(@NotNull Tile tile, double overrideTileTemp) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!((double)this.tempFrom < overrideTileTemp)) return false;
            if (!(overrideTileTemp <= (double)this.tempTo)) return false;
            double d = this.humidFrom;
            Double d2 = tile.getHumidity();
            double d3 = d2 != null ? d2 : 0.0;
            if (!(d < d3)) return false;
            Double d4 = tile.getHumidity();
            double d5 = d4 != null ? d4 : 0.0;
            if (!(d5 <= (double)this.humidTo)) return false;
            if (!this.matchesBaseTerrain(tile)) return false;
            return true;
        }

        public final boolean matchesIce() {
            return this.terrain.getType() == TerrainType.TerrainFeature && this.terrain.getImpassable() && this.terrain.getOccursOn().contains("Ocean") && !this.rareFeature;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange$Companion;", "", "<init>", "()V", "toFloatMakeInclusive", "", "", "limit", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final float toFloatMakeInclusive(String $this$toFloatMakeInclusive, float limit) {
                float result2 = Float.parseFloat($this$toFloatMakeInclusive);
                if (!(result2 == limit)) {
                    return result2;
                }
                return result2 - Math.ulp(result2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MapGeneratorSteps.values().length];
            try {
                nArray[MapGeneratorSteps.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.All.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Landmass.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.HumidityAndTemperature.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Elevation.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.LakesAndCoast.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Vegetation.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.RareFeatures.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Ice.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Continents.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.NaturalWonders.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Rivers.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.Resources.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapGeneratorSteps.AncientRuins.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

