/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileImprovementFunctions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.stats.Stats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\f\u001a\u00020\u0005*\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/unciv/logic/map/tile/TileNormalizer;", "", "<init>", "()V", "normalizeToRuleset", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "normalizeTileImprovement", "normalizeImprovementQueue", "clearImprovement", "core"})
@SourceDebugExtension(value={"SMAP\nTileNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileNormalizer.kt\ncom/unciv/logic/map/tile/TileNormalizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n777#2:79\n873#2,2:80\n231#2,2:82\n2792#2,3:84\n*S KotlinDebug\n*F\n+ 1 TileNormalizer.kt\ncom/unciv/logic/map/tile/TileNormalizer\n*L\n18#1:79\n18#1:80,2\n25#1:82,2\n41#1:84,3\n*E\n"})
public final class TileNormalizer {
    @NotNull
    public static final TileNormalizer INSTANCE = new TileNormalizer();

    private TileNormalizer() {
    }

    /*
     * WARNING - void declaration
     */
    public final void normalizeToRuleset(@NotNull Tile tile, @NotNull Ruleset ruleset) {
        TileResource resourceObject;
        Tile tile2;
        Iterable<Stats.StatValuePair> wonderTerrain;
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        if (tile.getNaturalWonder() != null && !((Map)ruleset.getTerrains()).containsKey(tile.getNaturalWonder())) {
            tile.setNaturalWonder(null);
        }
        if (tile.getNaturalWonder() != null) {
            wonderTerrain = tile.getNaturalWonder$core();
            if (((Terrain)wonderTerrain).getTurnsInto() != null) {
                String string = ((Terrain)wonderTerrain).getTurnsInto();
                Intrinsics.checkNotNull(string);
                tile.setBaseTerrain(string);
                tile.removeTerrainFeatures();
            } else {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = tile.getTerrainFeatures();
                tile2 = tile;
                boolean $i$f$filter = false;
                void var6_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!((Terrain)wonderTerrain).getOccursOn().contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                tile2.setTerrainFeatures((List)destination$iv$iv);
            }
            tile.setTileResource(null);
            this.clearImprovement(tile);
        }
        if (!ruleset.getTerrains().containsKey(tile.getBaseTerrain())) {
            Object element$iv2;
            block18: {
                void $this$first$iv;
                Collection<Terrain> collection = ruleset.getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                wonderTerrain = collection;
                tile2 = tile;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Terrain it = (Terrain)element$iv2;
                    boolean bl = false;
                    if (!(it.getType() == TerrainType.Land && !it.getImpassable())) continue;
                    break block18;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            tile2.setBaseTerrain(((Terrain)element$iv2).getName());
        }
        ArrayList<String> newFeatures = new ArrayList<String>();
        for (String terrainFeature : tile.getTerrainFeatures()) {
            Terrain terrainFeatureObject;
            if (ruleset.getTerrains().get(terrainFeature) == null || !((Collection)terrainFeatureObject.getOccursOn()).isEmpty() && !terrainFeatureObject.getOccursOn().contains(tile.getBaseTerrain())) continue;
            newFeatures.add(terrainFeature);
        }
        if (newFeatures.size() != tile.getTerrainFeatures().size()) {
            tile.setTerrainFeatures((List<String>)newFeatures);
        }
        if (tile.getResource() != null && !((Map)ruleset.getTileResources()).containsKey(tile.getResource())) {
            tile.setTileResource(null);
        }
        if ((resourceObject = tile.getTileResource()) != null) {
            boolean bl;
            block19: {
                Iterable $this$none$iv = resourceObject.getTerrainsCanBeFoundOn();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual(it, tile.getBaseTerrain()) || tile.getTerrainFeatures().contains(it))) continue;
                        bl = false;
                        break block19;
                    }
                    bl = true;
                }
            }
            if (bl) {
                tile.setTileResource(null);
            }
        }
        if (tile.getImprovement() != null) {
            this.normalizeTileImprovement(tile, ruleset);
        }
        if (tile.getImprovementInProgress() != null) {
            this.normalizeImprovementQueue(tile, ruleset);
        }
        if (tile.isWater() || tile.isImpassible()) {
            tile.removeRoad();
        }
    }

    private final void normalizeTileImprovement(Tile tile, Ruleset ruleset) {
        TileImprovement tileImprovement = (TileImprovement)((Map)ruleset.getTileImprovements()).get(tile.getImprovement());
        if (tileImprovement == null) {
            this.clearImprovement(tile);
            return;
        }
        TileImprovement improvementObject = tileImprovement;
        if (TileImprovementFunctions.canImprovementBeBuiltHere$core$default(tile.getImprovementFunctions(), improvementObject, false, null, GameContext.Companion.getIgnoreConditionals(), true, 6, null)) {
            return;
        }
        this.clearImprovement(tile);
    }

    private final void normalizeImprovementQueue(Tile tile, Ruleset ruleset) {
        List<Tile.ImprovementQueueEntry> oldImprovementQueue = CollectionsKt.toList((Iterable)tile.getImprovementQueue$core());
        tile.getImprovementQueue$core().clear();
        for (Tile.ImprovementQueueEntry improvementQueueEntry : oldImprovementQueue) {
            TileImprovement improvementObject;
            if (ruleset.getTileImprovements().get(improvementQueueEntry.getImprovement()) == null || !TileImprovementFunctions.canImprovementBeBuiltHere$core$default(tile.getImprovementFunctions(), improvementObject, false, null, GameContext.Companion.getIgnoreConditionals(), true, 6, null)) continue;
            tile.getImprovementQueue$core().add(improvementQueueEntry);
        }
    }

    private final void clearImprovement(Tile $this$clearImprovement) {
        $this$clearImprovement.setImprovement(null);
        $this$clearImprovement.stopWorkingOnImprovement();
    }
}

