/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.PurchaseReason;
import com.unciv.models.ruleset.RejectionReason;
import com.unciv.models.ruleset.RejectionReasonType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stat;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H'J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH'\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\u0006\u0010\u001f\u001a\u00020 H'J\u001a\u0010!\u001a\u00020\"2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u001a\u0010#\u001a\u00020$2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0017J\u0010\u0010&\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010'\u001a\u00020\u0005H\u0017J\u001a\u0010(\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0017J\u001f\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0017\u00a2\u0006\u0002\u0010,J \u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005H\u0017J\u001e\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00132\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0017J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\r082\u0006\u00109\u001a\u000206H\u0017J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\r0;2\u0006\u00109\u001a\u000206H\u0017R\u0018\u0010\u0004\u001a\u00020\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006<\u00c0\u0006\u0003"}, d2={"Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "Lcom/unciv/models/ruleset/IConstruction;", "Lcom/unciv/models/stats/INamed;", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "cost", "", "getCost", "()I", "setCost", "(I)V", "hurryCostModifier", "getHurryCostModifier", "requiredTech", "", "getRequiredTech", "()Ljava/lang/String;", "setRequiredTech", "(Ljava/lang/String;)V", "legacyRequiredTechs", "Lkotlin/sequences/Sequence;", "getProductionCost", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "city", "Lcom/unciv/logic/city/City;", "getStatBuyCost", "stat", "Lcom/unciv/models/stats/Stat;", "(Lcom/unciv/logic/city/City;Lcom/unciv/models/stats/Stat;)Ljava/lang/Integer;", "getRejectionReasons", "Lcom/unciv/models/ruleset/RejectionReason;", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "canBePurchasedWithStat", "", "canBePurchasedWithStatReasons", "Lcom/unciv/models/ruleset/PurchaseReason;", "isPurchasable", "canBePurchasedWithAnyStat", "getCivilopediaGoldCost", "getBaseGoldCost", "", "getBaseBuyCost", "", "(Lcom/unciv/logic/city/City;Lcom/unciv/models/stats/Stat;)Ljava/lang/Float;", "getCostForConstructionsIncreasingInPrice", "baseCost", "increaseCost", "previouslyBought", "getMatchingUniquesNotConflicting", "Lcom/unciv/models/ruleset/unique/Unique;", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "requiredResources", "", "state", "getStockpiledResourceRequirements", "Lcom/unciv/models/Counter;", "core"})
@SourceDebugExtension(value={"SMAP\nIConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IConstruction.kt\ncom/unciv/models/ruleset/INonPerpetualConstruction\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1276#2,2:340\n1276#2,2:342\n1253#2,2:344\n1944#2,14:349\n1276#2,2:363\n1807#3,3:346\n*S KotlinDebug\n*F\n+ 1 IConstruction.kt\ncom/unciv/models/ruleset/INonPerpetualConstruction\n*L\n58#1:340,2\n65#1:342,2\n78#1:344,2\n105#1:349,14\n112#1:363,2\n83#1:346,3\n*E\n"})
public interface INonPerpetualConstruction
extends IConstruction,
INamed,
IHasUniques {
    public int getCost();

    public void setCost(int var1);

    public int getHurryCostModifier();

    @Nullable
    public String getRequiredTech();

    public void setRequiredTech(@Nullable String var1);

    @Override
    @NotNull
    default public Sequence<String> legacyRequiredTechs() {
        Sequence<String> sequence;
        if (this.getRequiredTech() == null) {
            sequence = SequencesKt.emptySequence();
        } else {
            String string = this.getRequiredTech();
            Intrinsics.checkNotNull(string);
            sequence = SequencesKt.sequenceOf(string);
        }
        return sequence;
    }

    @Readonly
    public int getProductionCost(@NotNull Civilization var1, @Nullable City var2);

    @Readonly
    @Nullable
    public Integer getStatBuyCost(@NotNull City var1, @NotNull Stat var2);

    @Readonly
    @NotNull
    public Sequence<RejectionReason> getRejectionReasons(@NotNull CityConstructions var1);

    @Readonly
    default public boolean canBePurchasedWithStat(@Nullable City city, @NotNull Stat stat) {
        Intrinsics.checkNotNullParameter(stat, "stat");
        return this.canBePurchasedWithStatReasons(city, stat).getPurchasable();
    }

    @Readonly
    @NotNull
    default public PurchaseReason canBePurchasedWithStatReasons(@Nullable City city, @NotNull Stat stat) {
        boolean bl;
        Object gameContext;
        block9: {
            boolean bl2;
            Unique it;
            Object element$iv;
            Iterator<Object> iterator2;
            Sequence<Unique> $this$any$iv;
            boolean $i$f$any;
            block8: {
                Intrinsics.checkNotNullParameter(stat, "stat");
                Object object = city;
                if (object == null || (object = ((City)object).getState()) == null) {
                    object = gameContext = GameContext.Companion.getEmptyState();
                }
                if (stat == Stat.Production || stat == Stat.Happiness) {
                    return PurchaseReason.Invalid;
                }
                if (this.hasUnique(UniqueType.CannotBePurchased, (GameContext)gameContext)) {
                    return PurchaseReason.Unpurchasable;
                }
                Sequence<Unique> sequence = this.getMatchingUniques(UniqueType.CanBePurchasedWithStat, GameContext.Companion.getIgnoreConditionals());
                $i$f$any = false;
                iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (Unique)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual(it.getParams().get(0), stat.name()) && (city == null || it.conditionalsApply((GameContext)gameContext) && City.matchesFilter$default(city, it.getParams().get(1), null, false, 6, null)))) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
            if (bl2) {
                return PurchaseReason.UniqueAllowed;
            }
            $this$any$iv = this.getMatchingUniques(UniqueType.CanBePurchasedForAmountStat, GameContext.Companion.getIgnoreConditionals());
            $i$f$any = false;
            iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (Unique)element$iv;
                boolean bl4 = false;
                if (!(Intrinsics.areEqual(it.getParams().get(1), stat.name()) && (city == null || it.conditionalsApply((GameContext)gameContext) && City.matchesFilter$default(city, it.getParams().get(2), null, false, 6, null)))) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            return PurchaseReason.UniqueAllowed;
        }
        if (stat == Stat.Gold && !this.hasUnique(UniqueType.Unbuildable, (GameContext)gameContext)) {
            return PurchaseReason.Allowed;
        }
        return PurchaseReason.NotAllowed;
    }

    @Readonly
    default public boolean isPurchasable(@NotNull CityConstructions cityConstructions) {
        boolean bl;
        block1: {
            Sequence<RejectionReason> rejectionReasons;
            Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
            Sequence<RejectionReason> $this$all$iv = rejectionReasons = this.getRejectionReasons(cityConstructions);
            boolean $i$f$all = false;
            Iterator<RejectionReason> iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                RejectionReason element$iv;
                RejectionReason it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (it.getType() == RejectionReasonType.Unbuildable) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Readonly
    default public boolean canBePurchasedWithAnyStat(@NotNull City city) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(city, "city");
            Iterable $this$any$iv = Stat.Companion.getStatsUsableToBuy();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Stat it = (Stat)element$iv;
                    boolean bl2 = false;
                    if (!this.canBePurchasedWithStat(city, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Readonly
    default public int getCivilopediaGoldCost() {
        return (int)(Math.pow(30.0 * (double)this.getCost(), 0.75) * (double)FormattingExtensionsKt.toPercent(this.getHurryCostModifier()) / (double)10) * 10;
    }

    @Readonly
    default public double getBaseGoldCost(@NotNull Civilization civInfo, @Nullable City city) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        return Math.pow(30.0 * (double)this.getProductionCost(civInfo, city), 0.75) * (double)FormattingExtensionsKt.toPercent(this.getHurryCostModifier());
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @Nullable
    default public Float getBaseBuyCost(@NotNull City city, @NotNull Stat stat) {
        boolean bl;
        block9: {
            void $this$any$iv;
            Unique lowestCostUnique;
            Object v0;
            Sequence<Unique> $this$minByOrNull$iv;
            Intrinsics.checkNotNullParameter(city, "city");
            Intrinsics.checkNotNullParameter(stat, "stat");
            GameContext conditionalState = city.getState();
            Sequence<Unique> sequence = SequencesKt.filter(this.getMatchingUniques(UniqueType.CanBePurchasedForAmountStat, conditionalState), arg_0 -> INonPerpetualConstruction.getBaseBuyCost$lambda$0(stat, city, arg_0));
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    Unique it = (Unique)minElem$iv;
                    boolean bl2 = false;
                    int minValue$iv = Integer.parseInt(it.getParams().get(0));
                    do {
                        Object e$iv = iterator$iv.next();
                        Unique it2 = (Unique)e$iv;
                        $i$a$-minByOrNull-INonPerpetualConstruction$getBaseBuyCost$lowestCostUnique$2 = false;
                        int v$iv = Integer.parseInt(it2.getParams().get(0));
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            Unique unique = lowestCostUnique = (Unique)v0;
            if (unique != null) {
                float f = Integer.parseInt(unique.getParams().get(0));
                Float f2 = city.getCiv().getGameInfo().getSpeed().getStatCostModifiers().get(stat);
                Intrinsics.checkNotNull(f2);
                return Float.valueOf(f * ((Number)f2).floatValue());
            }
            if (stat == Stat.Gold) {
                return Float.valueOf((float)this.getBaseGoldCost(city.getCiv(), city));
            }
            $this$minByOrNull$iv = this.getMatchingUniques(UniqueType.CanBePurchasedWithStat, conditionalState);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Unique it = (Unique)element$iv;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual(it.getParams().get(0), stat.name()) && City.matchesFilter$default(city, it.getParams().get(1), null, false, 6, null))) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            float f = city.getCiv().getEra().getBaseUnitBuyCost();
            Float f3 = city.getCiv().getGameInfo().getSpeed().getStatCostModifiers().get(stat);
            Intrinsics.checkNotNull(f3);
            return Float.valueOf(f * ((Number)f3).floatValue());
        }
        return null;
    }

    @Readonly
    default public int getCostForConstructionsIncreasingInPrice(int baseCost, int increaseCost, int previouslyBought) {
        return (int)((float)baseCost + (float)increaseCost / 2.0f * (float)(previouslyBought * previouslyBought + previouslyBought));
    }

    @Readonly
    @NotNull
    default public Sequence<Unique> getMatchingUniquesNotConflicting(@NotNull UniqueType uniqueType, @NotNull GameContext gameContext) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        return this.getMatchingUniques(uniqueType, gameContext);
    }

    @Override
    @Readonly
    @NotNull
    default public Set<String> requiredResources(@NotNull GameContext state) {
        Intrinsics.checkNotNullParameter(state, "state");
        Set<String> set = this.getResourceRequirementsPerTurn(state).keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return SetsKt.plus(set, SequencesKt.map(this.getMatchingUniques(UniqueType.CostsResources, state), INonPerpetualConstruction::requiredResources$lambda$0));
    }

    @Override
    @Readonly
    @NotNull
    default public Counter<String> getStockpiledResourceRequirements(@NotNull GameContext state) {
        Intrinsics.checkNotNullParameter(state, "state");
        Counter<String> counter = new Counter<String>(null, 1, null);
        Iterator<Unique> iterator2 = this.getMatchingUniquesNotConflicting(UniqueType.CostsResources, state).iterator();
        while (iterator2.hasNext()) {
            Unique unique = iterator2.next();
            int amount = Integer.parseInt(unique.getParams().get(0));
            if (unique.isModifiedByGameSpeed()) {
                float f = amount;
                GameInfo gameInfo = state.getGameInfo();
                Intrinsics.checkNotNull(gameInfo);
                amount = (int)(f * gameInfo.getSpeed().getModifier());
            }
            counter.add(unique.getParams().get(1), amount);
        }
        return counter;
    }

    private static boolean getBaseBuyCost$lambda$0(Stat $stat, City $city, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getParams().get(1), $stat.name()) && City.matchesFilter$default($city, it.getParams().get(2), null, false, 6, null);
    }

    private static String requiredResources$lambda$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParams().get(1);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static Sequence<String> legacyRequiredTechs(@NotNull INonPerpetualConstruction $this) {
            return $this.legacyRequiredTechs();
        }

        @Readonly
        @Deprecated
        public static boolean canBePurchasedWithStat(@NotNull INonPerpetualConstruction $this, @Nullable City city, @NotNull Stat stat) {
            Intrinsics.checkNotNullParameter(stat, "stat");
            return $this.canBePurchasedWithStat(city, stat);
        }

        @Readonly
        @Deprecated
        @NotNull
        public static PurchaseReason canBePurchasedWithStatReasons(@NotNull INonPerpetualConstruction $this, @Nullable City city, @NotNull Stat stat) {
            Intrinsics.checkNotNullParameter(stat, "stat");
            return $this.canBePurchasedWithStatReasons(city, stat);
        }

        @Readonly
        @Deprecated
        public static boolean isPurchasable(@NotNull INonPerpetualConstruction $this, @NotNull CityConstructions cityConstructions) {
            Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
            return $this.isPurchasable(cityConstructions);
        }

        @Readonly
        @Deprecated
        public static boolean canBePurchasedWithAnyStat(@NotNull INonPerpetualConstruction $this, @NotNull City city) {
            Intrinsics.checkNotNullParameter(city, "city");
            return $this.canBePurchasedWithAnyStat(city);
        }

        @Readonly
        @Deprecated
        public static int getCivilopediaGoldCost(@NotNull INonPerpetualConstruction $this) {
            return $this.getCivilopediaGoldCost();
        }

        @Readonly
        @Deprecated
        public static double getBaseGoldCost(@NotNull INonPerpetualConstruction $this, @NotNull Civilization civInfo, @Nullable City city) {
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            return $this.getBaseGoldCost(civInfo, city);
        }

        @Readonly
        @Deprecated
        @Nullable
        public static Float getBaseBuyCost(@NotNull INonPerpetualConstruction $this, @NotNull City city, @NotNull Stat stat) {
            Intrinsics.checkNotNullParameter(city, "city");
            Intrinsics.checkNotNullParameter(stat, "stat");
            return $this.getBaseBuyCost(city, stat);
        }

        @Readonly
        @Deprecated
        public static int getCostForConstructionsIncreasingInPrice(@NotNull INonPerpetualConstruction $this, int baseCost, int increaseCost, int previouslyBought) {
            return $this.getCostForConstructionsIncreasingInPrice(baseCost, increaseCost, previouslyBought);
        }

        @Readonly
        @Deprecated
        @NotNull
        public static Sequence<Unique> getMatchingUniquesNotConflicting(@NotNull INonPerpetualConstruction $this, @NotNull UniqueType uniqueType, @NotNull GameContext gameContext) {
            Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
            Intrinsics.checkNotNullParameter(gameContext, "gameContext");
            return $this.getMatchingUniquesNotConflicting(uniqueType, gameContext);
        }

        @Readonly
        @Deprecated
        @NotNull
        public static Set<String> requiredResources(@NotNull INonPerpetualConstruction $this, @NotNull GameContext state) {
            Intrinsics.checkNotNullParameter(state, "state");
            return $this.requiredResources(state);
        }

        @Readonly
        @Deprecated
        @NotNull
        public static Counter<String> getStockpiledResourceRequirements(@NotNull INonPerpetualConstruction $this, @NotNull GameContext state) {
            Intrinsics.checkNotNullParameter(state, "state");
            return $this.getStockpiledResourceRequirements(state);
        }

        @Deprecated
        @NotNull
        public static List<Unique> uniqueObjectsProvider(@NotNull INonPerpetualConstruction $this) {
            return $this.uniqueObjectsProvider();
        }

        @Deprecated
        @NotNull
        public static List<Unique> uniqueObjectsProvider(@NotNull INonPerpetualConstruction $this, @NotNull List<String> uniques) {
            Intrinsics.checkNotNullParameter(uniques, "uniques");
            return $this.uniqueObjectsProvider(uniques);
        }

        @Deprecated
        @NotNull
        public static UniqueMap uniqueMapProvider(@NotNull INonPerpetualConstruction $this) {
            return $this.uniqueMapProvider();
        }

        @Deprecated
        @NotNull
        public static UniqueMap uniqueMapProvider(@NotNull INonPerpetualConstruction $this, @NotNull List<Unique> uniqueObjects2) {
            Intrinsics.checkNotNullParameter(uniqueObjects2, "uniqueObjects");
            return $this.uniqueMapProvider(uniqueObjects2);
        }

        @Readonly
        @Deprecated
        @NotNull
        public static Sequence<Unique> getMatchingUniques(@NotNull INonPerpetualConstruction $this, @NotNull UniqueType uniqueType, @NotNull GameContext state) {
            Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
            Intrinsics.checkNotNullParameter(state, "state");
            return $this.getMatchingUniques(uniqueType, state);
        }

        @Readonly
        @Deprecated
        @NotNull
        public static Sequence<Unique> getMatchingTagUniques(@NotNull INonPerpetualConstruction $this, @NotNull String uniqueTag, @NotNull GameContext state) {
            Intrinsics.checkNotNullParameter(uniqueTag, "uniqueTag");
            Intrinsics.checkNotNullParameter(state, "state");
            return $this.getMatchingTagUniques(uniqueTag, state);
        }

        @Readonly
        @Deprecated
        public static boolean hasUnique(@NotNull INonPerpetualConstruction $this, @NotNull UniqueType uniqueType, @Nullable GameContext state) {
            Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
            return $this.hasUnique(uniqueType, state);
        }

        @Readonly
        @Deprecated
        public static boolean hasTagUnique(@NotNull INonPerpetualConstruction $this, @NotNull String uniqueTag, @Nullable GameContext state) {
            Intrinsics.checkNotNullParameter(uniqueTag, "uniqueTag");
            return $this.hasTagUnique(uniqueTag, state);
        }

        @Readonly
        @Deprecated
        public static boolean hasTagUnique(@NotNull INonPerpetualConstruction $this, @NotNull String uniqueTag) {
            Intrinsics.checkNotNullParameter(uniqueTag, "uniqueTag");
            return $this.hasTagUnique(uniqueTag);
        }

        @Readonly
        @Deprecated
        @NotNull
        public static Sequence<String> techsRequiredByUniques(@NotNull INonPerpetualConstruction $this) {
            return $this.techsRequiredByUniques();
        }

        @Readonly
        @Deprecated
        @NotNull
        public static Sequence<String> requiredTechs(@NotNull INonPerpetualConstruction $this) {
            return $this.requiredTechs();
        }

        @Readonly
        @Deprecated
        @NotNull
        public static Sequence<Technology> requiredTechnologies(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return $this.requiredTechnologies(ruleset);
        }

        @Readonly
        @Deprecated
        @Nullable
        public static Era era(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return $this.era(ruleset);
        }

        @Readonly
        @Deprecated
        @Nullable
        public static TechColumn techColumn(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return $this.techColumn(ruleset);
        }

        @Readonly
        @Deprecated
        public static boolean availableInEra(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset, @NotNull String requestedEra) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            Intrinsics.checkNotNullParameter(requestedEra, "requestedEra");
            return $this.availableInEra(ruleset, requestedEra);
        }

        @Readonly
        @Deprecated
        public static float getWeightForAiDecision(@NotNull INonPerpetualConstruction $this, @NotNull GameContext gameContext) {
            Intrinsics.checkNotNullParameter(gameContext, "gameContext");
            return $this.getWeightForAiDecision(gameContext);
        }

        @Readonly
        @Deprecated
        public static boolean isUnavailableBySettings(@NotNull INonPerpetualConstruction $this, @NotNull GameInfo gameInfo) {
            Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
            return $this.isUnavailableBySettings(gameInfo);
        }

        @Readonly
        @Deprecated
        public static boolean isHiddenFromCivilopedia(@NotNull INonPerpetualConstruction $this, @Nullable GameInfo gameInfo, @Nullable Ruleset ruleset) {
            return $this.isHiddenFromCivilopedia(gameInfo, ruleset);
        }

        @Readonly
        @Deprecated
        public static boolean isHiddenFromCivilopedia(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return $this.isHiddenFromCivilopedia(ruleset);
        }
    }
}

