/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.nation;

import com.badlogic.gdx.graphics.Color;
import com.unciv.logic.MultiFilter;
import com.unciv.models.ImmutableColor;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.objectdescriptions.BaseUnitDescriptions;
import com.unciv.ui.objectdescriptions.BuildingDescriptions;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.objectdescriptions.ImprovementDescriptions;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b+\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\u000e\u001a\u00020\u0005H\u0007J\b\u0010Y\u001a\u00020ZH\u0016J\u0006\u00103\u001a\u00020\\J\u0006\u0010>\u001a\u00020\\J\u0006\u0010p\u001a\u00020qJ\b\u0010r\u001a\u00020\u0005H\u0016J\u0010\u0010s\u001a\u0002022\u0006\u0010t\u001a\u00020uH\u0016J\u0012\u0010v\u001a\u0004\u0018\u00010\u00052\u0006\u0010t\u001a\u00020uH\u0016J\u0016\u0010w\u001a\b\u0012\u0004\u0012\u00020x012\u0006\u0010t\u001a\u00020uH\u0016J\u0016\u0010y\u001a\b\u0012\u0004\u0012\u00020x012\u0006\u0010t\u001a\u00020uH\u0003J\u0016\u0010z\u001a\b\u0012\u0004\u0012\u00020x0{2\u0006\u0010t\u001a\u00020uH\u0002J\u0016\u0010|\u001a\b\u0012\u0004\u0012\u00020x0{2\u0006\u0010t\u001a\u00020uH\u0002J\u0016\u0010}\u001a\b\u0012\u0004\u0012\u00020x0{2\u0006\u0010t\u001a\u00020uH\u0002J)\u0010~\u001a\u00020_2\u0006\u0010\u007f\u001a\u00020\u00052\f\b\u0002\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u00012\t\b\u0002\u0010\u0082\u0001\u001a\u00020_H\u0007J\u0011\u0010\u0083\u0001\u001a\u00020_2\u0006\u0010\u007f\u001a\u00020\u0005H\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\tR\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\tR\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\tR\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0007\"\u0004\b\u001a\u0010\tR\u001a\u0010\u001b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0007\"\u0004\b\u001d\u0010\tR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0007\"\u0004\b \u0010\tR\u001a\u0010!\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0007\"\u0004\b#\u0010\tR\u001a\u0010$\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0007\"\u0004\b&\u0010\tR\u001a\u0010'\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0007\"\u0004\b)\u0010\tR\u001a\u0010*\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0007\"\u0004\b,\u0010\tR\u001a\u0010-\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0007\"\u0004\b/\u0010\tR \u00100\u001a\b\u0012\u0004\u0012\u00020201X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0007\"\u0004\b9\u0010\tR\u001a\u0010:\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u0007\"\u0004\b<\u0010\tR\"\u0010=\u001a\n\u0012\u0004\u0012\u000202\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u00104\"\u0004\b?\u00106R*\u0010@\u001a\u0012\u0012\u0004\u0012\u00020\u00050Aj\b\u0012\u0004\u0012\u00020\u0005`BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001c\u0010G\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u0007\"\u0004\bI\u0010\tR\u001a\u0010J\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0007\"\u0004\bL\u0010\tR\u001a\u0010M\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u0007\"\u0004\bO\u0010\tR*\u0010P\u001a\u0012\u0012\u0004\u0012\u00020\u00050Aj\b\u0012\u0004\u0012\u00020\u0005`BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010D\"\u0004\bR\u0010FR\u001c\u0010S\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u0007\"\u0004\bU\u0010\tR*\u0010V\u001a\u0012\u0012\u0004\u0012\u00020\u00050Aj\b\u0012\u0004\u0012\u00020\u0005`BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010D\"\u0004\bX\u0010FR\u000e\u0010[\u001a\u00020\\X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\\X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010^\u001a\u00020_8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\ba\u0010b\u001a\u0004\b^\u0010`R\u001b\u0010c\u001a\u00020_8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bd\u0010b\u001a\u0004\bc\u0010`R\u001b\u0010e\u001a\u00020_8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bf\u0010b\u001a\u0004\be\u0010`R\u001b\u0010g\u001a\u00020_8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bh\u0010b\u001a\u0004\bg\u0010`R\u001a\u0010i\u001a\u00020_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010`\"\u0004\bk\u0010lR\u001a\u0010m\u001a\u00020_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010`\"\u0004\bo\u0010l\u00a8\u0006\u0084\u0001"}, d2={"Lcom/unciv/models/ruleset/nation/Nation;", "Lcom/unciv/models/ruleset/RulesetObject;", "<init>", "()V", "leaderName", "", "getLeaderName", "()Ljava/lang/String;", "setLeaderName", "(Ljava/lang/String;)V", "getLeaderDisplayName", "title", "style", "getStyle", "getStyleOrCivName", "cityStateType", "getCityStateType", "setCityStateType", "preferredVictoryType", "getPreferredVictoryType", "setPreferredVictoryType", "declaringWar", "getDeclaringWar", "setDeclaringWar", "attacked", "getAttacked", "setAttacked", "defeated", "getDefeated", "setDefeated", "denounced", "getDenounced", "setDenounced", "declaringFriendship", "getDeclaringFriendship", "setDeclaringFriendship", "introduction", "getIntroduction", "setIntroduction", "tradeRequest", "getTradeRequest", "setTradeRequest", "neutralHello", "getNeutralHello", "setNeutralHello", "hateHello", "getHateHello", "setHateHello", "outerColor", "", "", "getOuterColor", "()Ljava/util/List;", "setOuterColor", "(Ljava/util/List;)V", "uniqueName", "getUniqueName", "setUniqueName", "uniqueText", "getUniqueText", "setUniqueText", "innerColor", "getInnerColor", "setInnerColor", "startBias", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getStartBias", "()Ljava/util/ArrayList;", "setStartBias", "(Ljava/util/ArrayList;)V", "personality", "getPersonality", "setPersonality", "startIntroPart1", "getStartIntroPart1", "setStartIntroPart1", "startIntroPart2", "getStartIntroPart2", "setStartIntroPart2", "spyNames", "getSpyNames", "setSpyNames", "favoredReligion", "getFavoredReligion", "setFavoredReligion", "cities", "getCities", "setCities", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "outerColorObject", "Lcom/unciv/models/ImmutableColor;", "innerColorObject", "isCityState", "", "()Z", "isCityState$delegate", "Lkotlin/Lazy;", "isMajorCiv", "isMajorCiv$delegate", "isBarbarian", "isBarbarian$delegate", "isSpectator", "isSpectator$delegate", "forestsAndJunglesAreRoads", "getForestsAndJunglesAreRoads", "setForestsAndJunglesAreRoads", "(Z)V", "ignoreHillMovementCost", "getIgnoreHillMovementCost", "setIgnoreHillMovementCost", "setTransients", "", "makeLink", "getSortGroup", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getSubCategory", "getCivilopediaTextLines", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "getCityStateInfo", "getUniqueBuildingsText", "Lkotlin/sequences/Sequence;", "getUniqueUnitsText", "getUniqueImprovementsText", "matchesFilter", "filter", "state", "Lcom/unciv/models/ruleset/unique/GameContext;", "multiFilter", "matchesSingleFilter", "core"})
@SourceDebugExtension(value={"SMAP\nNation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Nation.kt\ncom/unciv/models/ruleset/nation/Nation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n1#2:339\n1915#3,2:340\n777#3:342\n873#3,2:343\n1915#3,2:345\n*S KotlinDebug\n*F\n+ 1 Nation.kt\ncom/unciv/models/ruleset/nation/Nation\n*L\n158#1:340,2\n204#1:342\n204#1:343,2\n209#1:345,2\n*E\n"})
public final class Nation
extends RulesetObject {
    @NotNull
    private String leaderName = "";
    @NotNull
    private final String style;
    @Nullable
    private String cityStateType;
    @NotNull
    private String preferredVictoryType = "Neutral";
    @NotNull
    private String declaringWar = "";
    @NotNull
    private String attacked = "";
    @NotNull
    private String defeated = "";
    @NotNull
    private String denounced = "";
    @NotNull
    private String declaringFriendship = "";
    @NotNull
    private String introduction = "";
    @NotNull
    private String tradeRequest = "";
    @NotNull
    private String neutralHello = "";
    @NotNull
    private String hateHello = "";
    public List<Integer> outerColor;
    @NotNull
    private String uniqueName = "";
    @NotNull
    private String uniqueText = "";
    @Nullable
    private List<Integer> innerColor;
    @NotNull
    private ArrayList<String> startBias = new ArrayList();
    @Nullable
    private String personality;
    @NotNull
    private String startIntroPart1 = "";
    @NotNull
    private String startIntroPart2 = "";
    @NotNull
    private ArrayList<String> spyNames = new ArrayList();
    @Nullable
    private String favoredReligion;
    @NotNull
    private ArrayList<String> cities = new ArrayList();
    @NotNull
    private transient ImmutableColor outerColorObject;
    @NotNull
    private transient ImmutableColor innerColorObject;
    @NotNull
    private final Lazy isCityState$delegate;
    @NotNull
    private final Lazy isMajorCiv$delegate;
    @NotNull
    private final Lazy isBarbarian$delegate;
    @NotNull
    private final Lazy isSpectator$delegate;
    private transient boolean forestsAndJunglesAreRoads;
    private transient boolean ignoreHillMovementCost;

    public Nation() {
        this.style = "";
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.outerColorObject = new ImmutableColor(color);
        Color color2 = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color2, "BLACK");
        this.innerColorObject = new ImmutableColor(color2);
        this.isCityState$delegate = LazyKt.lazy(() -> Nation.isCityState_delegate$lambda$0(this));
        this.isMajorCiv$delegate = LazyKt.lazy(() -> Nation.isMajorCiv_delegate$lambda$0(this));
        this.isBarbarian$delegate = LazyKt.lazy(() -> Nation.isBarbarian_delegate$lambda$0(this));
        this.isSpectator$delegate = LazyKt.lazy(() -> Nation.isSpectator_delegate$lambda$0(this));
    }

    @NotNull
    public final String getLeaderName() {
        return this.leaderName;
    }

    public final void setLeaderName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.leaderName = string;
    }

    @Readonly
    @NotNull
    public final String getLeaderDisplayName(@NotNull String title) {
        String string;
        Intrinsics.checkNotNullParameter(title, "title");
        if (this.isCityState() || this.isSpectator()) {
            string = this.getName();
        } else if (((CharSequence)title).length() == 0) {
            string = '[' + this.leaderName + "] of [" + this.getName() + ']';
        } else {
            String[] stringArray = new String[]{this.leaderName};
            string = '[' + TranslationsKt.fillPlaceholders(title, stringArray) + "] of [" + this.getName() + ']';
        }
        return string;
    }

    public static /* synthetic */ String getLeaderDisplayName$default(Nation nation, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return nation.getLeaderDisplayName(string);
    }

    @NotNull
    public final String getStyle() {
        return this.style;
    }

    @Readonly
    @NotNull
    public final String getStyleOrCivName() {
        CharSequence charSequence;
        CharSequence charSequence2 = this.style;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.getName();
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @Nullable
    public final String getCityStateType() {
        return this.cityStateType;
    }

    public final void setCityStateType(@Nullable String string) {
        this.cityStateType = string;
    }

    @NotNull
    public final String getPreferredVictoryType() {
        return this.preferredVictoryType;
    }

    public final void setPreferredVictoryType(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.preferredVictoryType = string;
    }

    @NotNull
    public final String getDeclaringWar() {
        return this.declaringWar;
    }

    public final void setDeclaringWar(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.declaringWar = string;
    }

    @NotNull
    public final String getAttacked() {
        return this.attacked;
    }

    public final void setAttacked(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.attacked = string;
    }

    @NotNull
    public final String getDefeated() {
        return this.defeated;
    }

    public final void setDefeated(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.defeated = string;
    }

    @NotNull
    public final String getDenounced() {
        return this.denounced;
    }

    public final void setDenounced(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.denounced = string;
    }

    @NotNull
    public final String getDeclaringFriendship() {
        return this.declaringFriendship;
    }

    public final void setDeclaringFriendship(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.declaringFriendship = string;
    }

    @NotNull
    public final String getIntroduction() {
        return this.introduction;
    }

    public final void setIntroduction(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.introduction = string;
    }

    @NotNull
    public final String getTradeRequest() {
        return this.tradeRequest;
    }

    public final void setTradeRequest(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.tradeRequest = string;
    }

    @NotNull
    public final String getNeutralHello() {
        return this.neutralHello;
    }

    public final void setNeutralHello(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.neutralHello = string;
    }

    @NotNull
    public final String getHateHello() {
        return this.hateHello;
    }

    public final void setHateHello(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.hateHello = string;
    }

    @NotNull
    public final List<Integer> getOuterColor() {
        List<Integer> list2 = this.outerColor;
        if (list2 != null) {
            return list2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("outerColor");
        return null;
    }

    public final void setOuterColor(@NotNull List<Integer> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.outerColor = list2;
    }

    @NotNull
    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final void setUniqueName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.uniqueName = string;
    }

    @NotNull
    public final String getUniqueText() {
        return this.uniqueText;
    }

    public final void setUniqueText(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.uniqueText = string;
    }

    @Nullable
    public final List<Integer> getInnerColor() {
        return this.innerColor;
    }

    public final void setInnerColor(@Nullable List<Integer> list2) {
        this.innerColor = list2;
    }

    @NotNull
    public final ArrayList<String> getStartBias() {
        return this.startBias;
    }

    public final void setStartBias(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.startBias = arrayList;
    }

    @Nullable
    public final String getPersonality() {
        return this.personality;
    }

    public final void setPersonality(@Nullable String string) {
        this.personality = string;
    }

    @NotNull
    public final String getStartIntroPart1() {
        return this.startIntroPart1;
    }

    public final void setStartIntroPart1(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.startIntroPart1 = string;
    }

    @NotNull
    public final String getStartIntroPart2() {
        return this.startIntroPart2;
    }

    public final void setStartIntroPart2(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.startIntroPart2 = string;
    }

    @NotNull
    public final ArrayList<String> getSpyNames() {
        return this.spyNames;
    }

    public final void setSpyNames(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.spyNames = arrayList;
    }

    @Nullable
    public final String getFavoredReligion() {
        return this.favoredReligion;
    }

    public final void setFavoredReligion(@Nullable String string) {
        this.favoredReligion = string;
    }

    @NotNull
    public final ArrayList<String> getCities() {
        return this.cities;
    }

    public final void setCities(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.cities = arrayList;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Nation;
    }

    @NotNull
    public final ImmutableColor getOuterColor() {
        return this.outerColorObject;
    }

    @NotNull
    public final ImmutableColor getInnerColor() {
        return this.innerColorObject;
    }

    public final boolean isCityState() {
        Lazy lazy = this.isCityState$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isMajorCiv() {
        Lazy lazy = this.isMajorCiv$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isBarbarian() {
        Lazy lazy = this.isBarbarian$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isSpectator() {
        Lazy lazy = this.isSpectator$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getForestsAndJunglesAreRoads() {
        return this.forestsAndJunglesAreRoads;
    }

    public final void setForestsAndJunglesAreRoads(boolean bl) {
        this.forestsAndJunglesAreRoads = bl;
    }

    public final boolean getIgnoreHillMovementCost() {
        return this.ignoreHillMovementCost;
    }

    public final void setIgnoreHillMovementCost(boolean bl) {
        this.ignoreHillMovementCost = bl;
    }

    public final void setTransients() {
        ImmutableColor immutableColor;
        this.outerColorObject = Nation.setTransients$safeColorFromRGB(this.getOuterColor());
        if (this.innerColor == null) {
            immutableColor = new ImmutableColor(ImageGetter.INSTANCE.getCHARCOAL());
        } else {
            List<Integer> list2 = this.innerColor;
            Intrinsics.checkNotNull(list2);
            immutableColor = Nation.setTransients$safeColorFromRGB(list2);
        }
        this.innerColorObject = immutableColor;
        this.forestsAndJunglesAreRoads = UniqueMap.hasUnique$default(this.getUniqueMap(), UniqueType.ForestsAndJunglesAreRoads, null, 2, null);
        this.ignoreHillMovementCost = UniqueMap.hasUnique$default(this.getUniqueMap(), UniqueType.IgnoreHillMovementCost, null, 2, null);
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Nation/" + this.getName();
    }

    @Override
    public int getSortGroup(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return this.isCityState() ? 1 : (this.isBarbarian() ? 9 : 0);
    }

    @Override
    @Nullable
    public String getSubCategory(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return this.isCityState() ? "City-States" : (this.isBarbarian() ? "Other" : "Civilizations");
    }

    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        ArrayList textList = new ArrayList();
        if (this.isCityState()) {
            CollectionsKt.addAll((Collection)textList, (Iterable)this.getCityStateInfo(ruleset));
        }
        if (((CharSequence)this.leaderName).length() > 0) {
            ((Collection)textList).add(new FormattedLine(null, null, null, "LeaderIcons/" + this.leaderName, 200.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16359, null));
            Collection collection = textList;
            String string = Nation.getLeaderDisplayName$default(this, null, 1, null);
            collection.add(new FormattedLine(string, null, null, null, 0.0f, 0, 3, 0, 0.0f, null, false, false, true, false, 12222, null));
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        }
        if (!Intrinsics.areEqual(this.uniqueName, "")) {
            ((Collection)textList).add(new FormattedLine('{' + this.uniqueName + "}:", null, null, null, 0.0f, 0, 4, 0, 0.0f, null, false, false, false, false, 16318, null));
        }
        if (!Intrinsics.areEqual(this.uniqueText, "")) {
            ((Collection)textList).add(new FormattedLine(this.uniqueText, null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null));
        } else {
            DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(this, textList, null, false, null, 12, null);
        }
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        if (!((Collection)this.startBias).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)this.startBias);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                IndexedValue element$iv;
                IndexedValue it = element$iv = iterator2.next();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it.getValue(), '[', false, 2, null)) {
                    string = (String)it.getValue();
                } else {
                    MatchResult matchResult = Regex.find$default(TranslationsKt.getSquareBraceRegex(), (CharSequence)it.getValue(), 0, 2, null);
                    Intrinsics.checkNotNull(matchResult);
                    MatchGroup matchGroup = matchResult.getGroups().get(1);
                    Intrinsics.checkNotNull(matchGroup);
                    string = matchGroup.getValue();
                }
                String link = string;
                ((Collection)textList).add(new FormattedLine((it.getIndex() == 0 ? "[Start bias:] " : "") + TranslationsKt.tr$default((String)it.getValue(), false, false, 3, null), "Terrain/" + link, null, null, 0.0f, 0, 0, it.getIndex() == 0 ? 0 : 1, 0.0f, null, false, false, false, StringsKt.startsWith$default((String)it.getValue(), "Avoid ", false, 2, null), 8060, null));
            }
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        }
        CollectionsKt.addAll((Collection)textList, this.getUniqueBuildingsText(ruleset));
        CollectionsKt.addAll((Collection)textList, this.getUniqueUnitsText(ruleset));
        CollectionsKt.addAll((Collection)textList, this.getUniqueImprovementsText(ruleset));
        return textList;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final List<FormattedLine> getCityStateInfo(Ruleset ruleset) {
        ArrayList<FormattedLine> textList = new ArrayList<FormattedLine>();
        Object v = ((Map)ruleset.getCityStateTypes()).get(this.cityStateType);
        Intrinsics.checkNotNull(v);
        CityStateType cityStateType = (CityStateType)v;
        ((Collection)textList).add(new FormattedLine("{Type}: {" + cityStateType.getName() + '}', null, null, null, 0.0f, 0, 4, 0, 0.0f, "" + '#' + cityStateType.getColor(), false, false, false, false, 15806, null));
        Ref.BooleanRef showResources = new Ref.BooleanRef();
        Nation.getCityStateInfo$addBonusLines(textList, showResources, "When Friends:", cityStateType.getFriendBonusUniqueMap());
        Nation.getCityStateInfo$addBonusLines(textList, showResources, "When Allies:", cityStateType.getAllyBonusUniqueMap());
        if (showResources.element) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Collection<TileResource> collection = ruleset.getTileResources().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TileResource it = (TileResource)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.hasUnique$default(it, UniqueType.CityStateOnlyResource, null, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allMercantileResources = (List)destination$iv$iv;
            if (!((Collection)allMercantileResources).isEmpty()) {
                ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
                ((Collection)textList).add(new FormattedLine("The unique luxury is one of:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = allMercantileResources;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TileResource it = (TileResource)element$iv;
                    boolean bl = false;
                    ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
                }
            }
        }
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, true, false, false, false, 15359, null));
        return textList;
    }

    private final Sequence<FormattedLine> getUniqueBuildingsText(Ruleset ruleset) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>(ruleset, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ruleset $ruleset;
            final /* synthetic */ Nation this$0;
            {
                this.$ruleset = $ruleset;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block16: {
                    var2_2 = (SequenceScope)this.L$0;
                    var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            var3_4 = this.$ruleset.getBuildings().values().iterator();
lbl7:
                            // 9 sources

                            while (var3_4.hasNext()) {
                                v0 = var3_4.next();
                                Intrinsics.checkNotNullExpressionValue(v0, "next(...)");
                                building = (Building)v0;
                                if (building.getUniqueTo() == null) continue;
                                v1 = building.getUniqueTo();
                                Intrinsics.checkNotNull(v1);
                                if (!Nation.matchesFilter$default(this.this$0, v1, null, false, 6, null) || building.isHiddenFromCivilopedia(this.$ruleset)) continue;
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = building;
                                this.L$3 = null;
                                this.label = 1;
                                v2 = $this$sequence.yield(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, true, false, false, false, 15359, null), this);
                                if (v2 == var6_3) {
                                    return var6_3;
                                }
                                ** GOTO lbl30
                            }
                            break;
                        }
                        case 1: {
                            building = (Building)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl30:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = building;
                            this.label = 2;
                            v3 = $this$sequence.yield(new FormattedLine('{' + building.getName() + "} -", building.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null), this);
                            if (v3 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl43
                        }
                        case 2: {
                            building = (Building)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl43:
                            // 2 sources

                            if (building.getReplaces() == null) break;
                            v4 = this.$ruleset.getBuildings();
                            v5 = building.getReplaces();
                            Intrinsics.checkNotNull(v5);
                            if (!v4.containsKey(v5)) break;
                            v6 = this.$ruleset.getBuildings();
                            v7 = building.getReplaces();
                            Intrinsics.checkNotNull(v7);
                            Intrinsics.checkNotNull(v6.get(v7));
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = building;
                            this.L$3 = originalBuilding;
                            this.label = 3;
                            v8 = $this$sequence.yield(new FormattedLine("Replaces [" + originalBuilding.getName() + ']', originalBuilding.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null), this);
                            if (v8 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl67
                        }
                        case 3: {
                            originalBuilding = (Building)this.L$3;
                            building = (Building)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v8 = $result;
lbl67:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable(building);
                            this.L$3 = SpillingKt.nullOutSpilledVariable(originalBuilding);
                            this.label = 4;
                            v9 = $this$sequence.yieldAll(BuildingDescriptions.INSTANCE.getDifferences(originalBuilding, building), (Continuation<? super Unit>)this);
                            if (v9 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl82
                        }
                        case 4: {
                            originalBuilding = (Building)this.L$3;
                            building = (Building)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v9 = $result;
lbl82:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable(building);
                            this.L$3 = SpillingKt.nullOutSpilledVariable(originalBuilding);
                            this.label = 5;
                            v10 = $this$sequence.yield(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null), this);
                            if (v10 != var6_3) ** GOTO lbl7
                            return var6_3;
                        }
                        case 5: {
                            originalBuilding = (Building)this.L$3;
                            building = (Building)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v10 = $result;
                            ** GOTO lbl7
                        }
                    }
                    if (building.getReplaces() == null) break block16;
                    this.L$0 = $this$sequence;
                    this.L$1 = var3_4;
                    this.L$2 = SpillingKt.nullOutSpilledVariable(building);
                    this.label = 6;
                    v11 = $this$sequence.yield(new FormattedLine("Replaces [" + building.getReplaces() + "], which is not found in the ruleset!", null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v11 == var6_3) {
                        return var6_3;
                    }
                    ** GOTO lbl7
                    {
                        case 6: {
                            building = (Building)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v11 = $result;
                            ** GOTO lbl7
                        }
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = var3_4;
                this.L$2 = SpillingKt.nullOutSpilledVariable(building);
                this.label = 7;
                v12 = $this$sequence.yield(new FormattedLine(Building.getShortDescription$default(building, true, null, 2, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                if (v12 != var6_3) ** GOTO lbl7
                return var6_3;
                {
                    case 7: {
                        building = (Building)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v12 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super FormattedLine> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final Sequence<FormattedLine> getUniqueUnitsText(Ruleset ruleset) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>(ruleset, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ruleset $ruleset;
            final /* synthetic */ Nation this$0;
            {
                this.$ruleset = $ruleset;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block21: {
                    var2_2 = (SequenceScope)this.L$0;
                    var16_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            var3_4 = this.$ruleset.getUnits().values().iterator();
lbl7:
                            // 5 sources

                            while (var3_4.hasNext()) {
                                v0 = var3_4.next();
                                Intrinsics.checkNotNullExpressionValue(v0, "next(...)");
                                unit = (BaseUnit)v0;
                                if (unit.isHiddenFromCivilopedia(this.$ruleset) || unit.getUniqueTo() == null) continue;
                                v1 = unit.getUniqueTo();
                                Intrinsics.checkNotNull(v1);
                                if (!Nation.matchesFilter$default(this.this$0, v1, null, false, 6, null)) continue;
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = unit;
                                this.label = 1;
                                v2 = $this$sequence.yield(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, true, false, false, false, 15359, null), this);
                                if (v2 == var16_3) {
                                    return var16_3;
                                }
                                ** GOTO lbl29
                            }
                            break;
                        }
                        case 1: {
                            unit = (BaseUnit)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl29:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = unit;
                            this.label = 2;
                            v3 = $this$sequence.yield(new FormattedLine('{' + unit.getName() + "} -", "Unit/" + unit.getName(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null), this);
                            if (v3 == var16_3) {
                                return var16_3;
                            }
                            ** GOTO lbl42
                        }
                        case 2: {
                            unit = (BaseUnit)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl42:
                            // 2 sources

                            if (unit.getReplaces() == null) break;
                            v4 = this.$ruleset.getUnits();
                            v5 = unit.getReplaces();
                            Intrinsics.checkNotNull(v5);
                            if (!v4.containsKey(v5)) break;
                            v6 = this.$ruleset.getUnits();
                            v7 = unit.getReplaces();
                            Intrinsics.checkNotNull(v7);
                            Intrinsics.checkNotNull(v6.get(v7));
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = unit;
                            this.L$3 = originalUnit;
                            this.label = 3;
                            v8 = $this$sequence.yield(new FormattedLine("Replaces [" + originalUnit.getName() + ']', "Unit/" + originalUnit.getName(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null), this);
                            if (v8 == var16_3) {
                                return var16_3;
                            }
                            ** GOTO lbl66
                        }
                        case 3: {
                            originalUnit = (BaseUnit)this.L$3;
                            unit = (BaseUnit)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v8 = $result;
lbl66:
                            // 2 sources

                            if (unit.getCost() != originalUnit.getCost()) {
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = unit;
                                this.L$3 = originalUnit;
                                this.label = 4;
                                v9 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{Cost} ", false, false, 3, null) + TranslationsKt.tr$default("" + '[' + unit.getCost() + "] vs [" + originalUnit.getCost() + ']', false, false, 3, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                                if (v9 == var16_3) {
                                    return var16_3;
                                }
                            }
                            ** GOTO lbl82
                        }
                        case 4: {
                            originalUnit = (BaseUnit)this.L$3;
                            unit = (BaseUnit)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v9 = $result;
lbl82:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable(unit);
                            this.L$3 = SpillingKt.nullOutSpilledVariable(originalUnit);
                            this.label = 5;
                            v10 = $this$sequence.yieldAll(SequencesKt.map(BaseUnitDescriptions.INSTANCE.getDifferences(this.$ruleset, (BaseUnit)originalUnit, unit), (Function1<Pair, FormattedLine>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(kotlin.Pair ), (Lkotlin/Pair;)Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;)()), (Continuation<? super Unit>)this);
                            if (v10 == var16_3) {
                                return var16_3;
                            }
                            ** GOTO lbl140
                        }
                        case 5: {
                            originalUnit = (BaseUnit)this.L$3;
                            unit = (BaseUnit)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v10 = $result;
                            ** GOTO lbl140
                        }
                    }
                    if (unit.getReplaces() == null) break block21;
                    this.L$0 = $this$sequence;
                    this.L$1 = var3_4;
                    this.L$2 = SpillingKt.nullOutSpilledVariable(unit);
                    this.label = 6;
                    v11 = $this$sequence.yield(new FormattedLine("Replaces [" + unit.getReplaces() + "], which is not found in the ruleset!", null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v11 == var16_3) {
                        return var16_3;
                    }
                    ** GOTO lbl140
                    {
                        case 6: {
                            unit = (BaseUnit)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v11 = $result;
                            ** GOTO lbl140
                        }
                    }
                }
                originalUnit = unit.getCivilopediaTextLines(this.$ruleset);
                var14_15 = $this$sequence;
                $i$f$map = false;
                var7_8 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var12_13 = (FormattedLine)item$iv$iv;
                    var15_16 = destination$iv$iv;
                    $i$a$-map-Nation$getUniqueUnitsText$1$2 = false;
                    var15_16.add(new FormattedLine(it.getText(), it.getLink(), null, null, 0.0f, 0, 0, it.getIndent() + 1, 0.0f, it.getColor(), false, false, false, false, 15740, null));
                }
                this.L$0 = $this$sequence;
                this.L$1 = var3_4;
                this.L$2 = SpillingKt.nullOutSpilledVariable(unit);
                this.label = 7;
                v12 = var14_15.yieldAll((List)destination$iv$iv, (Continuation<? super Unit>)this);
                if (v12 == var16_3) {
                    return var16_3;
                }
                ** GOTO lbl140
                {
                    case 7: {
                        unit = (BaseUnit)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v12 = $result;
lbl140:
                        // 6 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(unit);
                        this.L$3 = null;
                        this.label = 8;
                        v13 = $this$sequence.yield(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null), this);
                        if (v13 != var16_3) ** GOTO lbl7
                        return var16_3;
                    }
                    case 8: {
                        unit = (BaseUnit)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v13 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super FormattedLine> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final FormattedLine invokeSuspend$lambda$0(Pair pair) {
                String text2 = (String)pair.component1();
                String link = (String)pair.component2();
                String string = link;
                if (string == null) {
                    string = "";
                }
                return new FormattedLine(text2, string, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null);
            }
        });
    }

    private final Sequence<FormattedLine> getUniqueImprovementsText(Ruleset ruleset) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>(ruleset, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ruleset $ruleset;
            final /* synthetic */ Nation this$0;
            {
                this.$ruleset = $ruleset;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block18: {
                    var2_2 = (SequenceScope)this.L$0;
                    var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            var3_4 = this.$ruleset.getTileImprovements().values().iterator();
lbl7:
                            // 9 sources

                            while (var3_4.hasNext()) {
                                v0 = var3_4.next();
                                Intrinsics.checkNotNullExpressionValue(v0, "next(...)");
                                improvement = (TileImprovement)v0;
                                if (improvement.isHiddenFromCivilopedia(this.$ruleset) || improvement.getUniqueTo() == null) continue;
                                v1 = improvement.getUniqueTo();
                                Intrinsics.checkNotNull(v1);
                                if (!Nation.matchesFilter$default(this.this$0, v1, null, false, 6, null)) continue;
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = improvement;
                                this.L$3 = null;
                                this.label = 1;
                                v2 = $this$sequence.yield(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, true, false, false, false, 15359, null), this);
                                if (v2 == var6_3) {
                                    return var6_3;
                                }
                                ** GOTO lbl30
                            }
                            break;
                        }
                        case 1: {
                            improvement = (TileImprovement)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl30:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = improvement;
                            this.label = 2;
                            v3 = $this$sequence.yield(new FormattedLine(improvement.getName(), "Improvement/" + improvement.getName(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null), this);
                            if (v3 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl43
                        }
                        case 2: {
                            improvement = (TileImprovement)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl43:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = improvement;
                            this.label = 3;
                            v4 = $this$sequence.yield(new FormattedLine(improvement.cloneStats().toString(), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v4 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl56
                        }
                        case 3: {
                            improvement = (TileImprovement)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v4 = $result;
lbl56:
                            // 2 sources

                            if (improvement.getReplaces() == null) break;
                            v5 = this.$ruleset.getTileImprovements();
                            v6 = improvement.getReplaces();
                            Intrinsics.checkNotNull(v6);
                            if (!v5.containsKey(v6)) break;
                            v7 = this.$ruleset.getTileImprovements();
                            v8 = improvement.getReplaces();
                            Intrinsics.checkNotNull(v8);
                            Intrinsics.checkNotNull(v7.get(v8));
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = improvement;
                            this.L$3 = originalImprovement;
                            this.label = 4;
                            v9 = $this$sequence.yield(new FormattedLine("Replaces [" + originalImprovement.getName() + ']', originalImprovement.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null), this);
                            if (v9 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl80
                        }
                        case 4: {
                            originalImprovement = (TileImprovement)this.L$3;
                            improvement = (TileImprovement)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v9 = $result;
lbl80:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable(improvement);
                            this.L$3 = SpillingKt.nullOutSpilledVariable(originalImprovement);
                            this.label = 5;
                            v10 = $this$sequence.yieldAll(ImprovementDescriptions.INSTANCE.getDifferences(this.$ruleset, originalImprovement, improvement), (Continuation<? super Unit>)this);
                            if (v10 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl95
                        }
                        case 5: {
                            originalImprovement = (TileImprovement)this.L$3;
                            improvement = (TileImprovement)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v10 = $result;
lbl95:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable(improvement);
                            this.L$3 = SpillingKt.nullOutSpilledVariable(originalImprovement);
                            this.label = 6;
                            v11 = $this$sequence.yield(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null), this);
                            if (v11 != var6_3) ** GOTO lbl7
                            return var6_3;
                        }
                        case 6: {
                            originalImprovement = (TileImprovement)this.L$3;
                            improvement = (TileImprovement)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v11 = $result;
                            ** GOTO lbl7
                        }
                    }
                    if (improvement.getReplaces() == null) break block18;
                    this.L$0 = $this$sequence;
                    this.L$1 = var3_4;
                    this.L$2 = SpillingKt.nullOutSpilledVariable(improvement);
                    this.label = 7;
                    v12 = $this$sequence.yield(new FormattedLine("Replaces [" + improvement.getReplaces() + "], which is not found in the ruleset!", null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v12 == var6_3) {
                        return var6_3;
                    }
                    ** GOTO lbl7
                    {
                        case 7: {
                            improvement = (TileImprovement)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v12 = $result;
                            ** GOTO lbl7
                        }
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = var3_4;
                this.L$2 = SpillingKt.nullOutSpilledVariable(improvement);
                this.label = 8;
                v13 = $this$sequence.yieldAll(improvement.getShortDecription(), (Continuation<? super Unit>)this);
                if (v13 != var6_3) ** GOTO lbl7
                return var6_3;
                {
                    case 8: {
                        improvement = (TileImprovement)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v13 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super FormattedLine> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Readonly
    public final boolean matchesFilter(@NotNull String filter2, @Nullable GameContext state, boolean multiFilter) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return multiFilter ? MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, arg_0 -> Nation.matchesFilter$lambda$0(this, filter2, state, arg_0), false, 4, null) : this.matchesSingleFilter(filter2) || state != null && this.hasTagUnique(filter2, state) || state == null && this.hasTagUnique(filter2);
    }

    public static /* synthetic */ boolean matchesFilter$default(Nation nation, String string, GameContext gameContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return nation.matchesFilter(string, gameContext, bl);
    }

    @Readonly
    private final boolean matchesSingleFilter(String filter2) {
        boolean bl;
        switch (filter2) {
            case "All": 
            case "all": {
                bl = true;
                break;
            }
            case "Major": {
                bl = this.isMajorCiv();
                break;
            }
            case "City-States": 
            case "City-State": {
                bl = this.isCityState();
                break;
            }
            default: {
                bl = Intrinsics.areEqual(filter2, this.getName());
            }
        }
        return bl;
    }

    private static final boolean isCityState_delegate$lambda$0(Nation this$0) {
        return this$0.cityStateType != null;
    }

    private static final boolean isMajorCiv_delegate$lambda$0(Nation this$0) {
        return !this$0.isBarbarian() && !this$0.isCityState() && !this$0.isSpectator();
    }

    private static final boolean isBarbarian_delegate$lambda$0(Nation this$0) {
        return Intrinsics.areEqual(this$0.getName(), "Barbarians");
    }

    private static final boolean isSpectator_delegate$lambda$0(Nation this$0) {
        return Intrinsics.areEqual(this$0.getName(), "Spectator");
    }

    private static final ImmutableColor setTransients$safeColorFromRGB(List<Integer> rgb) {
        Color color = rgb.size() >= 3 ? Scene2dExtensionsKt.colorFromRGB(rgb) : Color.PURPLE;
        Intrinsics.checkNotNull(color);
        return new ImmutableColor(color);
    }

    private static final boolean getCityStateInfo$addBonusLines$lambda$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isHiddenToUsers();
    }

    private static final void getCityStateInfo$addBonusLines(ArrayList<FormattedLine> textList, Ref.BooleanRef showResources, String header, UniqueMap uniqueMap2) {
        Sequence<Unique> bonuses = SequencesKt.filterNot(uniqueMap2.getAllUniques(), Nation::getCityStateInfo$addBonusLines$lambda$0);
        if (SequencesKt.none(bonuses)) {
            return;
        }
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        ((Collection)textList).add(new FormattedLine('{' + header + "} ", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        Iterator<Unique> iterator2 = bonuses.iterator();
        while (iterator2.hasNext()) {
            Unique unique = iterator2.next();
            ((Collection)textList).add(new FormattedLine(unique, 1));
            if (unique.getType() != UniqueType.CityStateUniqueLuxury) continue;
            showResources.element = true;
        }
    }

    private static final boolean matchesFilter$lambda$0(Nation this$0, String $filter, GameContext $state, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.matchesSingleFilter($filter) || $state != null && this$0.hasTagUnique(it, $state) || $state == null && this$0.hasTagUnique(it);
    }
}

