/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.UncivGame;
import com.unciv.ui.images.ImageGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH&J\b\u0010\u0014\u001a\u00020\u0007H\u0014J\f\u0010\u0015\u001a\u00020\u0012*\u00020\fH\u0014J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\fH\u0014J\b\u0010\u0018\u001a\u00020\tH\u0004J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\tH\u0004J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0014\u0010 \u001a\u00020\u0012*\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020\u0012H\u0016J\u0018\u0010$\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020\u0007J \u0010'\u001a\u00020\u0012*\u00020\u00052\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020*0)H\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/unciv/ui/components/ParticleEffectAnimation;", "Lcom/badlogic/gdx/utils/Disposable;", "<init>", "()V", "templateEffect", "Lcom/badlogic/gdx/graphics/g2d/ParticleEffect;", "maxDuration", "", "nextIndex", "", "activeEffectData", "Ljava/util/ArrayList;", "Lcom/unciv/ui/components/ParticleEffectAnimation$ParticleEffectData;", "Lkotlin/collections/ArrayList;", "targetBounds", "Lcom/badlogic/gdx/math/Rectangle;", "lastScale", "getTargetBounds", "", "bounds", "getScale", "configure", "onComplete", "effectData", "activeCount", "load", "effectsFile", "", "atlasName", "count", "newEffect", "dummy", "add", "Lcom/badlogic/gdx/graphics/g2d/ParticleEmitter$RangedNumericValue;", "delta", "dispose", "render", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "removeEmitters", "predicate", "Lkotlin/Function1;", "", "Companion", "ParticleEffectData", "core"})
@SourceDebugExtension(value={"SMAP\nParticleEffectAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleEffectAnimation.kt\ncom/unciv/ui/components/ParticleEffectAnimation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1#2:202\n*E\n"})
public abstract class ParticleEffectAnimation
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParticleEffect templateEffect = new ParticleEffect();
    private float maxDuration;
    private int nextIndex;
    @NotNull
    private final ArrayList<ParticleEffectData> activeEffectData = new ArrayList();
    @NotNull
    private final Rectangle targetBounds = new Rectangle();
    private float lastScale = 1.0f;
    @NotNull
    public static final String defaultAtlasName = "ConstructionIcons";
    @NotNull
    private static final Vector2 halfPoint = new Vector2(0.5f, 0.5f);

    public abstract void getTargetBounds(@NotNull Rectangle var1);

    protected float getScale() {
        return 1.0f;
    }

    protected void configure(@NotNull ParticleEffectData $this$configure) {
        Intrinsics.checkNotNullParameter($this$configure, "<this>");
    }

    protected int onComplete(@NotNull ParticleEffectData effectData) {
        Intrinsics.checkNotNullParameter(effectData, "effectData");
        return 0;
    }

    protected final int activeCount() {
        return this.activeEffectData.size();
    }

    protected final void load(@NotNull String effectsFile, @NotNull String atlasName, int count2) {
        float f;
        Intrinsics.checkNotNullParameter(effectsFile, "effectsFile");
        Intrinsics.checkNotNullParameter(atlasName, "atlasName");
        this.activeEffectData.clear();
        TextureAtlas textureAtlas = ImageGetter.INSTANCE.getSpecificAtlas(atlasName);
        Intrinsics.checkNotNull(textureAtlas);
        TextureAtlas atlas = textureAtlas;
        this.templateEffect.load(Gdx.files.internal(effectsFile), atlas);
        this.templateEffect.setEmittersCleanUpBlendFunction(false);
        Array<ParticleEmitter> array = this.templateEffect.getEmitters();
        Intrinsics.checkNotNullExpressionValue(array, "getEmitters(...)");
        Iterable iterable = array;
        ParticleEffectAnimation particleEffectAnimation = this;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        ParticleEmitter it22 = (ParticleEmitter)iterator2.next();
        boolean bl = false;
        float it22 = it22.getDuration().getLowMax() + (it22.getDelay().isActive() ? it22.getDelay().getLowMax() : 0.0f);
        while (iterator2.hasNext()) {
            ParticleEmitter it = (ParticleEmitter)iterator2.next();
            $i$a$-maxOf-ParticleEffectAnimation$load$1 = false;
            float f2 = it.getDuration().getLowMax() + (it.getDelay().isActive() ? it.getDelay().getLowMax() : 0.0f);
            it22 = Math.max(it22, f2);
        }
        particleEffectAnimation.maxDuration = f = it22;
        int n = 0;
        while (n < count2) {
            int p0 = n++;
            boolean bl2 = false;
            this.newEffect(p0);
        }
    }

    private final void newEffect(int dummy) {
        ParticleEffect effect = new ParticleEffect(this.templateEffect);
        ParticleEffectData data = new ParticleEffectData(this.nextIndex, effect, null, null, 0.0f, this.maxDuration / (float)1000, null, 92, null);
        int n = this.nextIndex;
        this.nextIndex = n + 1;
        this.configure(data);
        if (data.getDelay() > 0.0f) {
            Iterator iterator2 = effect.getEmitters().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (((Array.ArrayIterator)iterator3).hasNext()) {
                ParticleEmitter emitter = (ParticleEmitter)((Array.ArrayIterator)iterator3).next();
                ParticleEmitter.RangedNumericValue rangedNumericValue = emitter.getDelay();
                Intrinsics.checkNotNullExpressionValue(rangedNumericValue, "getDelay(...)");
                this.add(rangedNumericValue, data.getDelay() * (float)1000);
            }
        }
        if (!(this.lastScale == 1.0f)) {
            effect.scaleEffect(this.lastScale);
        }
        effect.start();
        ((Collection)this.activeEffectData).add(data);
    }

    private final void add(ParticleEmitter.RangedNumericValue $this$add, float delta) {
        if ($this$add.isActive()) {
            $this$add.setLowMin($this$add.getLowMin() + delta);
            $this$add.setLowMax($this$add.getLowMax() + delta);
        } else {
            $this$add.setActive(true);
            $this$add.setLowMin(delta);
            $this$add.setLowMax(delta);
        }
    }

    @Override
    public void dispose() {
        List<ParticleEffectData> effects = CollectionsKt.toList((Iterable)this.activeEffectData);
        this.activeEffectData.clear();
        for (ParticleEffectData effect : effects) {
            effect.getEffect().dispose();
        }
        this.templateEffect.dispose();
    }

    public final void render(@Nullable Stage stage, float delta) {
        ParticleEffect effect;
        if (this.maxDuration == 0.0f) {
            return;
        }
        Disposable disposable = stage;
        if (disposable == null || (disposable = ((Stage)disposable).getBatch()) == null) {
            return;
        }
        Disposable effectsBatch = disposable;
        effectsBatch.setProjectionMatrix(stage.getViewport().getCamera().combined);
        this.getTargetBounds(this.targetBounds);
        float newScale = this.getScale();
        if (!(newScale == this.lastScale)) {
            float scaleChange = newScale / this.lastScale;
            this.lastScale = newScale;
            Iterator<ParticleEffectData> iterator2 = this.activeEffectData.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<ParticleEffectData> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                ParticleEffectData particleEffectData = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(particleEffectData, "next(...)");
                effect = particleEffectData.component2();
                effect.scaleEffect(scaleChange);
            }
        }
        int repeatCount = 0;
        effectsBatch.begin();
        Iterator<ParticleEffectData> iterator4 = this.activeEffectData.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        Iterator<ParticleEffectData> iterator5 = iterator4;
        while (iterator5.hasNext()) {
            ParticleEffectData effectData;
            Intrinsics.checkNotNullExpressionValue(iterator5.next(), "next(...)");
            effect = effectData.getEffect();
            effectData.update(delta);
            float x = this.targetBounds.x + this.targetBounds.width * effectData.currentX();
            float y = this.targetBounds.y + this.targetBounds.height * effectData.currentY();
            effect.setPosition(x, y);
            effect.draw((Batch)effectsBatch, delta);
            if (!effect.isComplete()) continue;
            repeatCount += this.onComplete(effectData);
            effect.dispose();
            iterator5.remove();
        }
        effectsBatch.setBlendFunction(770, 771);
        effectsBatch.end();
        int n = 0;
        while (n < repeatCount) {
            int p0 = n++;
            boolean bl = false;
            this.newEffect(p0);
        }
    }

    protected final void removeEmitters(@NotNull ParticleEffect $this$removeEmitters, @NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$removeEmitters, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Array<ParticleEmitter> matches = new Array<ParticleEmitter>();
        Iterator iterator2 = $this$removeEmitters.getEmitters().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (((Array.ArrayIterator)iterator3).hasNext()) {
            ParticleEmitter emitter = (ParticleEmitter)((Array.ArrayIterator)iterator3).next();
            String string = emitter.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (!predicate.invoke(string).booleanValue()) continue;
            matches.add(emitter);
        }
        $this$removeEmitters.getEmitters().removeAll(matches, true);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/components/ParticleEffectAnimation$Companion;", "", "<init>", "()V", "defaultAtlasName", "", "isEnabled", "", "game", "Lcom/unciv/UncivGame;", "atlasName", "halfPoint", "Lcom/badlogic/gdx/math/Vector2;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled(@NotNull UncivGame game, @NotNull String atlasName) {
            Intrinsics.checkNotNullParameter(game, "game");
            Intrinsics.checkNotNullParameter(atlasName, "atlasName");
            return game.getSettings().getContinuousRendering() && ImageGetter.INSTANCE.getSpecificAtlas(atlasName) != null;
        }

        public static /* synthetic */ boolean isEnabled$default(Companion companion, UncivGame uncivGame, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = ParticleEffectAnimation.defaultAtlasName;
            }
            return companion.isEnabled(uncivGame, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\nJ\u0006\u0010)\u001a\u00020\nJ\u0006\u0010*\u001a\u00020\nJ\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\nH\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\rH\u00c6\u0003JO\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0014\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u00106\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u00107\u001a\u000208H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/unciv/ui/components/ParticleEffectAnimation$ParticleEffectData;", "", "index", "", "effect", "Lcom/badlogic/gdx/graphics/g2d/ParticleEffect;", "startPoint", "Lcom/badlogic/gdx/math/Vector2;", "endPoint", "delay", "", "travelTime", "interpolation", "Lcom/badlogic/gdx/math/Interpolation;", "<init>", "(ILcom/badlogic/gdx/graphics/g2d/ParticleEffect;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;FFLcom/badlogic/gdx/math/Interpolation;)V", "getIndex", "()I", "getEffect", "()Lcom/badlogic/gdx/graphics/g2d/ParticleEffect;", "getStartPoint", "()Lcom/badlogic/gdx/math/Vector2;", "setStartPoint", "(Lcom/badlogic/gdx/math/Vector2;)V", "getEndPoint", "setEndPoint", "getDelay", "()F", "setDelay", "(F)V", "getTravelTime", "setTravelTime", "getInterpolation", "()Lcom/badlogic/gdx/math/Interpolation;", "setInterpolation", "(Lcom/badlogic/gdx/math/Interpolation;)V", "accumulatedTime", "percent", "update", "", "delta", "currentX", "currentY", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    protected static final class ParticleEffectData {
        private final int index;
        @NotNull
        private final ParticleEffect effect;
        @NotNull
        private Vector2 startPoint;
        @NotNull
        private Vector2 endPoint;
        private float delay;
        private float travelTime;
        @NotNull
        private Interpolation interpolation;
        private float accumulatedTime;
        private float percent;

        public ParticleEffectData(int index, @NotNull ParticleEffect effect, @NotNull Vector2 startPoint, @NotNull Vector2 endPoint, float delay2, float travelTime, @NotNull Interpolation interpolation) {
            Intrinsics.checkNotNullParameter(effect, "effect");
            Intrinsics.checkNotNullParameter(startPoint, "startPoint");
            Intrinsics.checkNotNullParameter(endPoint, "endPoint");
            Intrinsics.checkNotNullParameter(interpolation, "interpolation");
            this.index = index;
            this.effect = effect;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.delay = delay2;
            this.travelTime = travelTime;
            this.interpolation = interpolation;
        }

        public /* synthetic */ ParticleEffectData(int n, ParticleEffect particleEffect, Vector2 vector2, Vector2 vector22, float f, float f2, Interpolation interpolation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                vector2 = halfPoint;
            }
            if ((n2 & 8) != 0) {
                vector22 = halfPoint;
            }
            if ((n2 & 0x10) != 0) {
                f = 0.0f;
            }
            if ((n2 & 0x40) != 0) {
                Interpolation interpolation2 = Interpolation.linear;
                Intrinsics.checkNotNullExpressionValue(interpolation2, "linear");
                interpolation = interpolation2;
            }
            this(n, particleEffect, vector2, vector22, f, f2, interpolation);
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final ParticleEffect getEffect() {
            return this.effect;
        }

        @NotNull
        public final Vector2 getStartPoint() {
            return this.startPoint;
        }

        public final void setStartPoint(@NotNull Vector2 vector2) {
            Intrinsics.checkNotNullParameter(vector2, "<set-?>");
            this.startPoint = vector2;
        }

        @NotNull
        public final Vector2 getEndPoint() {
            return this.endPoint;
        }

        public final void setEndPoint(@NotNull Vector2 vector2) {
            Intrinsics.checkNotNullParameter(vector2, "<set-?>");
            this.endPoint = vector2;
        }

        public final float getDelay() {
            return this.delay;
        }

        public final void setDelay(float f) {
            this.delay = f;
        }

        public final float getTravelTime() {
            return this.travelTime;
        }

        public final void setTravelTime(float f) {
            this.travelTime = f;
        }

        @NotNull
        public final Interpolation getInterpolation() {
            return this.interpolation;
        }

        public final void setInterpolation(@NotNull Interpolation interpolation) {
            Intrinsics.checkNotNullParameter(interpolation, "<set-?>");
            this.interpolation = interpolation;
        }

        public final void update(float delta) {
            this.accumulatedTime += delta;
            float rawPercent = (this.accumulatedTime - this.delay) / this.travelTime;
            this.percent = this.interpolation.apply(RangesKt.coerceIn(rawPercent, 0.0f, 1.0f));
        }

        public final float currentX() {
            return this.startPoint.x + this.percent * (this.endPoint.x - this.startPoint.x);
        }

        public final float currentY() {
            return this.startPoint.y + this.percent * (this.endPoint.y - this.startPoint.y);
        }

        public final int component1() {
            return this.index;
        }

        @NotNull
        public final ParticleEffect component2() {
            return this.effect;
        }

        @NotNull
        public final Vector2 component3() {
            return this.startPoint;
        }

        @NotNull
        public final Vector2 component4() {
            return this.endPoint;
        }

        public final float component5() {
            return this.delay;
        }

        public final float component6() {
            return this.travelTime;
        }

        @NotNull
        public final Interpolation component7() {
            return this.interpolation;
        }

        @NotNull
        public final ParticleEffectData copy(int index, @NotNull ParticleEffect effect, @NotNull Vector2 startPoint, @NotNull Vector2 endPoint, float delay2, float travelTime, @NotNull Interpolation interpolation) {
            Intrinsics.checkNotNullParameter(effect, "effect");
            Intrinsics.checkNotNullParameter(startPoint, "startPoint");
            Intrinsics.checkNotNullParameter(endPoint, "endPoint");
            Intrinsics.checkNotNullParameter(interpolation, "interpolation");
            return new ParticleEffectData(index, effect, startPoint, endPoint, delay2, travelTime, interpolation);
        }

        public static /* synthetic */ ParticleEffectData copy$default(ParticleEffectData particleEffectData, int n, ParticleEffect particleEffect, Vector2 vector2, Vector2 vector22, float f, float f2, Interpolation interpolation, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = particleEffectData.index;
            }
            if ((n2 & 2) != 0) {
                particleEffect = particleEffectData.effect;
            }
            if ((n2 & 4) != 0) {
                vector2 = particleEffectData.startPoint;
            }
            if ((n2 & 8) != 0) {
                vector22 = particleEffectData.endPoint;
            }
            if ((n2 & 0x10) != 0) {
                f = particleEffectData.delay;
            }
            if ((n2 & 0x20) != 0) {
                f2 = particleEffectData.travelTime;
            }
            if ((n2 & 0x40) != 0) {
                interpolation = particleEffectData.interpolation;
            }
            return particleEffectData.copy(n, particleEffect, vector2, vector22, f, f2, interpolation);
        }

        @NotNull
        public String toString() {
            return "ParticleEffectData(index=" + this.index + ", effect=" + this.effect + ", startPoint=" + this.startPoint + ", endPoint=" + this.endPoint + ", delay=" + this.delay + ", travelTime=" + this.travelTime + ", interpolation=" + this.interpolation + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.index);
            result2 = result2 * 31 + this.effect.hashCode();
            result2 = result2 * 31 + this.startPoint.hashCode();
            result2 = result2 * 31 + this.endPoint.hashCode();
            result2 = result2 * 31 + Float.hashCode(this.delay);
            result2 = result2 * 31 + Float.hashCode(this.travelTime);
            result2 = result2 * 31 + this.interpolation.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParticleEffectData)) {
                return false;
            }
            ParticleEffectData particleEffectData = (ParticleEffectData)other;
            if (this.index != particleEffectData.index) {
                return false;
            }
            if (!Intrinsics.areEqual(this.effect, particleEffectData.effect)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.startPoint, particleEffectData.startPoint)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.endPoint, particleEffectData.endPoint)) {
                return false;
            }
            if (Float.compare(this.delay, particleEffectData.delay) != 0) {
                return false;
            }
            if (Float.compare(this.travelTime, particleEffectData.travelTime) != 0) {
                return false;
            }
            return Intrinsics.areEqual(this.interpolation, particleEffectData.interpolation);
        }
    }
}

