/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.fonts;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Array;
import com.unciv.UncivGame;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.FontMetricsCommon;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.civilopediascreen.CivilopediaImageGetters;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000fJ\u001e\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005J\u001c\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050*2\u0006\u0010%\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR-\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\bj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/unciv/ui/components/fonts/FontRulesetIcons;", "", "<init>", "()V", "UNUSED_CHARACTER_CODES_START", "", "UNUSED_CHARACTER_CODES_END", "rulesetObjectNameToChar", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getRulesetObjectNameToChar", "()Ljava/util/HashMap;", "charToRulesetImageActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getCharToRulesetImageActor", "nextUnusedCharacterNumber", "addRulesetImages", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "frameBuffer", "Lcom/badlogic/gdx/graphics/glutils/FrameBuffer;", "getFrameBuffer", "()Lcom/badlogic/gdx/graphics/glutils/FrameBuffer;", "frameBuffer$delegate", "Lkotlin/Lazy;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSpriteBatch", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "spriteBatch$delegate", "transform", "Lcom/badlogic/gdx/math/Matrix4;", "getPixmapFromActor", "Lcom/badlogic/gdx/graphics/Pixmap;", "actor", "getPixmapFromActorBase", "boxWidth", "boxHeight", "scaleAndPositionActor", "Lkotlin/Pair;", "core"})
@SourceDebugExtension(value={"SMAP\nFontRulesetIcons.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontRulesetIcons.kt\ncom/unciv/ui/components/fonts/FontRulesetIcons\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
public final class FontRulesetIcons {
    @NotNull
    public static final FontRulesetIcons INSTANCE = new FontRulesetIcons();
    public static final int UNUSED_CHARACTER_CODES_START = 57344;
    private static final int UNUSED_CHARACTER_CODES_END = 63743;
    @NotNull
    private static final HashMap<String, Character> rulesetObjectNameToChar = new HashMap();
    @NotNull
    private static final HashMap<Character, Actor> charToRulesetImageActor = new HashMap();
    private static int nextUnusedCharacterNumber = 57344;
    @NotNull
    private static final Lazy frameBuffer$delegate = LazyKt.lazy(FontRulesetIcons::frameBuffer_delegate$lambda$0);
    @NotNull
    private static final Lazy spriteBatch$delegate = LazyKt.lazy(FontRulesetIcons::spriteBatch_delegate$lambda$0);
    @NotNull
    private static final Matrix4 transform = new Matrix4();

    private FontRulesetIcons() {
    }

    @NotNull
    public final HashMap<String, Character> getRulesetObjectNameToChar() {
        return rulesetObjectNameToChar;
    }

    @NotNull
    public final HashMap<Character, Actor> getCharToRulesetImageActor() {
        return charToRulesetImageActor;
    }

    /*
     * WARNING - void declaration
     */
    public final void addRulesetImages(@NotNull Ruleset ruleset) {
        Image image;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        rulesetObjectNameToChar.clear();
        charToRulesetImageActor.clear();
        nextUnusedCharacterNumber = 57344;
        Iterator<Object> iterator2 = ruleset.getTileResources().keySet().iterator();
        while (iterator2.hasNext()) {
            String resourceName;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            FontRulesetIcons.addRulesetImages$addChar(resourceName, ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resourceName, 100.0f, 0, 4, null));
        }
        iterator2 = ruleset.getBuildings().keySet().iterator();
        while (iterator2.hasNext()) {
            String buildingName;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            FontRulesetIcons.addRulesetImages$addChar(buildingName, ImageGetter.INSTANCE.getConstructionPortrait(buildingName, 100.0f));
        }
        iterator2 = ruleset.getUnits().keySet().iterator();
        while (iterator2.hasNext()) {
            String unitName;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            FontRulesetIcons.addRulesetImages$addChar(unitName, ImageGetter.INSTANCE.getConstructionPortrait(unitName, 100.0f));
        }
        iterator2 = ruleset.getUnitPromotions().keySet().iterator();
        while (iterator2.hasNext()) {
            String promotionName;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            FontRulesetIcons.addRulesetImages$addChar(promotionName, ImageGetter.INSTANCE.getPromotionPortrait(promotionName, 100.0f));
        }
        iterator2 = ruleset.getTileImprovements().keySet().iterator();
        while (iterator2.hasNext()) {
            String improvementName;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            FontRulesetIcons.addRulesetImages$addChar(improvementName, ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, improvementName, 100.0f, false, 4, null));
        }
        iterator2 = ruleset.getTechnologies().keySet().iterator();
        while (iterator2.hasNext()) {
            String techName;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            FontRulesetIcons.addRulesetImages$addChar(techName, ImageGetter.INSTANCE.getTechIconPortrait(techName, 100.0f));
        }
        for (Object object : ruleset.getNations().values()) {
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Nation nation = (Nation)object;
            FontRulesetIcons.addRulesetImages$addChar(nation.getName(), ImageGetter.INSTANCE.getNationPortrait(nation, 100.0f));
        }
        for (Object object : ruleset.getPolicies().values()) {
            void $this$addRulesetImages_u24lambda_u240;
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Policy policy = (Policy)object;
            String fileLocation = ((Map)ruleset.getPolicyBranches()).containsKey(policy.getName()) ? "PolicyBranchIcons/" + policy.getName() : "PolicyIcons/" + policy.getName();
            if (!ImageGetter.INSTANCE.imageExists(fileLocation)) continue;
            Image image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, fileLocation, null, 2, null);
            image = image2;
            String string = policy.getName();
            boolean bl = false;
            Scene2dExtensionsKt.setSize((Image)$this$addRulesetImages_u24lambda_u240, 100.0f);
            FontRulesetIcons.addRulesetImages$addChar(string, image2);
        }
        if (TileSetCache.INSTANCE.containsKey((Object)UncivGame.Companion.getCurrent().getSettings().getTileSet())) {
            TileSetStrings tileSetStrings = new TileSetStrings(ruleset, UncivGame.Companion.getCurrent().getSettings());
            Iterator<Terrain> iterator3 = ruleset.getTerrains().values().iterator();
            while (iterator3.hasNext()) {
                Terrain terrain;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                Group tileGroup = CivilopediaImageGetters.INSTANCE.terrainImage$core(terrain, ruleset, 100.0f, tileSetStrings);
                tileGroup.setWidth(tileGroup.getWidth() * 1.5f);
                tileGroup.setHeight(tileGroup.getHeight() * 1.5f);
                Intrinsics.checkNotNullExpressionValue(tileGroup.getChildren().iterator(), "iterator(...)");
                while (((Array.ArrayIterator)((Object)image)).hasNext()) {
                    Actor layer = (Actor)((Array.ArrayIterator)((Object)image)).next();
                    Intrinsics.checkNotNull(layer);
                    Scene2dExtensionsKt.center(layer, tileGroup);
                }
                FontRulesetIcons.addRulesetImages$addChar(terrain.getName(), tileGroup);
            }
        }
    }

    private final FrameBuffer getFrameBuffer() {
        Lazy lazy = frameBuffer$delegate;
        return (FrameBuffer)lazy.getValue();
    }

    private final SpriteBatch getSpriteBatch() {
        Lazy lazy = spriteBatch$delegate;
        return (SpriteBatch)lazy.getValue();
    }

    @NotNull
    public final Pixmap getPixmapFromActor(@NotNull Actor actor) {
        Intrinsics.checkNotNullParameter(actor, "actor");
        Pair<Integer, Integer> pair = this.scaleAndPositionActor(actor);
        int boxWidth = ((Number)pair.component1()).intValue();
        int boxHeight = ((Number)pair.component2()).intValue();
        return this.getPixmapFromActorBase(actor, boxWidth, boxHeight);
    }

    @NotNull
    public final Pixmap getPixmapFromActorBase(@NotNull Actor actor, int boxWidth, int boxHeight) {
        Intrinsics.checkNotNullParameter(actor, "actor");
        Pixmap pixmap = new Pixmap(boxWidth, boxHeight, Pixmap.Format.RGBA8888);
        this.getFrameBuffer().begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        this.getSpriteBatch().begin();
        actor.draw(this.getSpriteBatch(), 1.0f);
        this.getSpriteBatch().end();
        Gdx.gl.glReadPixels(0, 0, boxWidth, boxHeight, 6408, 5121, pixmap.getPixels());
        this.getFrameBuffer().end();
        return pixmap;
    }

    private final Pair<Integer, Integer> scaleAndPositionActor(Actor actor) {
        float border;
        FontMetricsCommon metrics = Fonts.INSTANCE.getFontImplementation().getMetrics();
        float scaledActorHeight = metrics.getAscent() * 0.93f;
        float scaledActorWidth = actor.getWidth() * (scaledActorHeight / actor.getHeight());
        int boxHeight = (int)Math.ceil(metrics.getHeight());
        int boxWidth = (int)Math.ceil(scaledActorWidth);
        Portrait portrait = actor instanceof Portrait ? (Portrait)actor : null;
        float f = border = portrait != null ? portrait.getBorderSize() : 0.0f;
        if (actor instanceof Group) {
            ((Group)actor).setTransform(true);
            float scale = scaledActorWidth / ((Group)actor).getWidth();
            actor.setScale(scale, -scale);
            actor.setPosition(0.0f, metrics.getLeading() + metrics.getAscent() + border * scale + 1.0f);
        } else {
            actor.setPosition(0.0f, metrics.getLeading() + border);
            actor.setSize(scaledActorWidth, scaledActorHeight);
            transform.idt().scl(1.0f, -1.0f, 1.0f).trn(0.0f, boxHeight, 0.0f);
            this.getSpriteBatch().setTransformMatrix(transform);
        }
        return TuplesKt.to(boxWidth, boxHeight);
    }

    private static final void addRulesetImages$addChar(String objectName, Actor objectActor) {
        if (nextUnusedCharacterNumber > 63743) {
            return;
        }
        int n = nextUnusedCharacterNumber;
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid Char code: " + n);
        }
        char c = (char)n;
        n = nextUnusedCharacterNumber;
        nextUnusedCharacterNumber = n + 1;
        ((Map)rulesetObjectNameToChar).put(objectName, Character.valueOf(c));
        ((Map)charToRulesetImageActor).put(Character.valueOf(c), objectActor);
    }

    private static final FrameBuffer frameBuffer_delegate$lambda$0() {
        return new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
    }

    private static final SpriteBatch spriteBatch_delegate$lambda$0() {
        return new SpriteBatch();
    }
}

